/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.event;

import com.github.tartaricacid.touhoulittlemaid.client.sound.data.MaidSoundInstance;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MaidConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class MaidSoundFreqEvent {
    @SubscribeEvent
    public static void onPlaySoundEvent(PlaySoundEvent event) {
        SoundInstance soundInstance = event.getSound();
        if (soundInstance instanceof MaidSoundInstance) {
            MaidSoundInstance maidSoundInstance = (MaidSoundInstance)soundInstance;
            EntityMaid maid = maidSoundInstance.getMaid();
            if (maid == null) {
                event.setSound(null);
                return;
            }
            double soundFrequency = maid.getConfigManager().getSoundFreq();
            if ((soundFrequency = soundFrequency * (double)((Integer)MaidConfig.GLOBAL_MAID_SOUND_FREQUENCY.get()).intValue() / 100.0) < 1.0 && !maidSoundInstance.isTestSound() && Math.random() > soundFrequency) {
                event.setSound(null);
            }
        }
    }
}

