/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.entity;

import com.github.tartaricacid.touhoulittlemaid.api.animation.IMagicCastingState;
import com.github.tartaricacid.touhoulittlemaid.api.entity.IMaid;
import com.github.tartaricacid.touhoulittlemaid.client.animation.HardcodedAnimationManger;
import com.github.tartaricacid.touhoulittlemaid.client.animation.gecko.AnimationManager;
import com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.MaidModelInfo;
import com.github.tartaricacid.touhoulittlemaid.compat.immersivemelodies.ImmersiveMelodiesCompat;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.AnimatableEntity;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.controller.AnimationController;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.event.predicate.AnimationEvent;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.molang.MolangParser;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.molang.context.AnimationContext;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.IGeoEntity;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.animated.AnimatedGeoBone;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.animated.AnimatedGeoModel;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.animated.ILocationModel;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.model.provider.data.EntityModelData;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.resource.GeckoLibCache;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector2f;

public class GeckoMaidEntity<T extends Mob>
extends AnimatableEntity<T>
implements IGeoEntity {
    private static final ResourceLocation GECKO_DEFAULT_ID = new ResourceLocation("touhou_little_maid", "fox_miko");
    private static final ResourceLocation GECKO_DEFAULT_TEXTURE = new ResourceLocation("touhou_little_maid", "textures/entity/empty.png");
    private static final int FPS = 60;
    private final IMaid maid;
    private final Vector2f headRot = new Vector2f();
    private final MaidState<T> state;
    private MaidModelInfo maidInfo;
    private float currentTick = -1.0f;
    private boolean modelDirty = false;
    private ImmersiveMelodiesCompat.ImmersiveMelodiesData imData = new ImmersiveMelodiesCompat.ImmersiveMelodiesData();
    private IMagicCastingState.CastingPhase lastCastingPhase = IMagicCastingState.CastingPhase.NONE;

    public GeckoMaidEntity(T mob, IMaid maid) {
        super(mob, 60);
        this.maid = maid;
        this.state = new MaidState<T>(mob);
        this.registerControllers();
    }

    public void registerControllers() {
        String animationName;
        String controllerName;
        int i;
        AnimationManager manager = AnimationManager.getInstance();
        for (i = 0; i < 8; ++i) {
            controllerName = String.format("pre_parallel_%d_controller", i);
            animationName = String.format("pre_parallel%d", i);
            this.addAnimationController(new AnimationController<GeckoMaidEntity>(this, controllerName, 0.0f, e -> manager.predicateParallel(e, animationName)));
        }
        this.addAnimationController(new AnimationController<GeckoMaidEntity>(this, "main", 2.0f, manager::predicateMain));
        this.addAnimationController(new AnimationController<GeckoMaidEntity>(this, "hold_offhand", 0.0f, manager::predicateOffhandHold));
        this.addAnimationController(new AnimationController<GeckoMaidEntity>(this, "hold_mainhand", 0.0f, manager::predicateMainhandHold));
        this.addAnimationController(new AnimationController<GeckoMaidEntity>(this, "swing", 2.0f, manager::predicateSwing));
        this.addAnimationController(new AnimationController<GeckoMaidEntity>(this, "use", 2.0f, manager::predicateUse));
        this.addAnimationController(new AnimationController<GeckoMaidEntity>(this, "magic_casting", 2.0f, manager::predicateMagicCastingAnimation));
        this.addAnimationController(new AnimationController<GeckoMaidEntity>(this, "misc", 2.0f, manager::predicateMisc));
        this.addAnimationController(new AnimationController<GeckoMaidEntity>(this, "passenger", 2.0f, manager::predicatePassengerAnimation));
        for (i = 0; i < 8; ++i) {
            controllerName = String.format("parallel_%d_controller", i);
            animationName = String.format("parallel%d", i);
            this.addAnimationController(new AnimationController<GeckoMaidEntity>(this, controllerName, 0.0f, e -> manager.predicateParallel(e, animationName)));
        }
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            if (slot.m_20743_() != EquipmentSlot.Type.ARMOR) continue;
            String controllerName2 = String.format("%s_controller", slot.m_20751_());
            this.addAnimationController(new AnimationController<GeckoMaidEntity>(this, controllerName2, 0.0f, e -> manager.predicateArmor(e, slot)));
        }
    }

    @Override
    public boolean setCustomAnimations(AnimationContext context, @NotNull AnimationEvent event) {
        Object object;
        List<Object> extraData = event.getExtraData();
        MolangParser parser = GeckoLibCache.getInstance().parser;
        if (!Minecraft.m_91087_().m_91104_() && extraData.size() == 1 && (object = extraData.get(0)) instanceof EntityModelData) {
            EntityModelData data = (EntityModelData)object;
            boolean update = super.setCustomAnimations(context, event);
            AnimatedGeoModel currentModel = this.getCurrentModel();
            if (currentModel != null) {
                this.updateHead(data, currentModel, update);
                HardcodedAnimationManger.playGeckoMaidAnimation(this.maid, currentModel, event.getLimbSwing(), event.getLimbSwingAmount(), (float)this.maid.asEntity().f_19797_ + event.getPartialTick(), data.netHeadYaw, data.headPitch);
                ImmersiveMelodiesCompat.updateMelodyProgress((LivingEntity)this.maid.asEntity(), this.imData);
            }
            return update;
        }
        return super.setCustomAnimations(context, event);
    }

    private void updateHead(EntityModelData data, AnimatedGeoModel currentModel, boolean update) {
        if (currentModel.head() != null) {
            AnimatedGeoBone head = currentModel.head();
            if (update) {
                this.headRot.set(head.getRotationX(), head.getRotationY());
            }
            head.setRotationX(this.headRot.x + (float)Math.toRadians(data.headPitch));
            head.setRotationY(this.headRot.y + (float)Math.toRadians(data.netHeadYaw));
        }
    }

    @Override
    public ResourceLocation getModelLocation() {
        if (this.maidInfo != null && GeckoLibCache.getInstance().getGeoModels().containsKey(this.maidInfo.getModelId())) {
            return this.maidInfo.getModelId();
        }
        return GECKO_DEFAULT_ID;
    }

    @Override
    public ResourceLocation getTextureLocation() {
        return this.maidInfo != null ? this.maidInfo.getTexture() : GECKO_DEFAULT_TEXTURE;
    }

    @Override
    public ResourceLocation getAnimationFileLocation() {
        if (this.maidInfo != null && GeckoLibCache.getInstance().getAnimations().containsKey(this.maidInfo.getModelId())) {
            return this.maidInfo.getModelId();
        }
        return GECKO_DEFAULT_ID;
    }

    @Override
    protected boolean forceUpdate(AnimationEvent<?> animationEvent) {
        float tick = (float)this.getCurrentTick(animationEvent);
        if (tick > this.currentTick) {
            this.currentTick = tick;
            this.state.updateState();
            this.modelDirty = false;
            return false;
        }
        if (this.modelDirty || !this.state.compareState()) {
            this.state.updateState();
            this.modelDirty = false;
            return true;
        }
        return false;
    }

    @Override
    public IMaid getMaid() {
        return this.maid;
    }

    @Override
    public MaidModelInfo getMaidInfo() {
        return this.maidInfo;
    }

    @Override
    public ILocationModel getGeoModel() {
        return this.getCurrentModel();
    }

    @Override
    public void setMaidInfo(MaidModelInfo info) {
        if (this.maidInfo != info) {
            this.maidInfo = info;
            this.modelDirty = true;
        }
    }

    @Override
    public void setYsmModel(String modelId, String texture) {
    }

    @Override
    public void updateRoamingVars(Object2FloatOpenHashMap<String> roamingVars) {
    }

    public ImmersiveMelodiesCompat.ImmersiveMelodiesData getImmersiveMelodiesData() {
        return this.imData;
    }

    public IMagicCastingState.CastingPhase getLastCastingPhase() {
        return this.lastCastingPhase;
    }

    public void setLastCastingPhase(IMagicCastingState.CastingPhase phase) {
        this.lastCastingPhase = phase;
    }

    private static class MaidState<T extends Mob> {
        private final T maid;
        private float yHeadRot = 0.0f;
        private float yBodyRot = 0.0f;

        private MaidState(T maid) {
            this.maid = maid;
        }

        public boolean compareState() {
            return this.yHeadRot == ((Mob)this.maid).f_20885_ && this.yBodyRot == ((Mob)this.maid).f_20883_;
        }

        public void updateState() {
            this.yHeadRot = ((Mob)this.maid).f_20885_;
            this.yBodyRot = ((Mob)this.maid).f_20883_;
        }
    }
}

