/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.animation.gecko.molang.functions.physics;

import com.github.tartaricacid.touhoulittlemaid.client.animation.gecko.molang.functions.physics.IPhysics;
import net.minecraft.util.Mth;

public class SecondOrder
implements IPhysics {
    private float inputFunction = 0.0f;
    private float lastSimulation = 0.0f;
    private float lastSimulationDot = 0.0f;
    private float arg0;
    private float arg1;
    private float arg2;
    private float arg3;

    public SecondOrder(float input, float frequency, float coefficient, float response) {
        this.arg0 = input;
        this.arg1 = Mth.m_14036_((float)frequency, (float)0.0f, (float)5.0f);
        this.arg2 = Mth.m_14036_((float)coefficient, (float)0.0f, (float)1.0f);
        this.arg3 = response;
    }

    @Override
    public void update(float timeStep) {
        float input = this.arg0;
        float frequency = Mth.m_14036_((float)this.arg1, (float)0.0f, (float)5.0f);
        float coefficient = Mth.m_14036_((float)this.arg2, (float)0.0f, (float)1.0f);
        float response = this.arg3;
        float k1 = coefficient / (float)Math.PI / frequency;
        float k2 = 1.0f / ((float)Math.PI * 2 * frequency) / ((float)Math.PI * 2 * frequency);
        float k3 = response * coefficient / 2.0f / (float)Math.PI / frequency;
        float inputFunctionDot = (input - this.inputFunction) / timeStep;
        this.inputFunction = input;
        float maxTimeStep = (float)Math.sqrt(4.0f * k2 + k1 * k1) - k1;
        int cycleTime = (int)Math.ceil(timeStep / maxTimeStep);
        timeStep /= (float)cycleTime;
        float lastSimulationDot = this.lastSimulationDot;
        float lastSimulation = this.lastSimulation;
        while (cycleTime > 0) {
            lastSimulationDot += timeStep * (k3 * inputFunctionDot + input - (lastSimulation += timeStep * lastSimulationDot) - k1 * lastSimulationDot) / k2;
            --cycleTime;
        }
        this.lastSimulation = lastSimulation;
        this.lastSimulationDot = lastSimulationDot;
    }

    @Override
    public void setArgs(float arg0, float arg1, float arg2, float arg3) {
        this.arg0 = arg0;
        this.arg1 = arg1;
        this.arg2 = arg2;
        this.arg3 = arg3;
    }

    @Override
    public float getValue() {
        return this.lastSimulation;
    }
}

