/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.animation.gecko.molang;

import com.github.tartaricacid.touhoulittlemaid.client.animation.gecko.molang.functions.physics.IPhysics;
import it.unimi.dsi.fastutil.objects.Object2ReferenceOpenHashMap;
import org.jetbrains.annotations.Nullable;

public class PhysicsManager {
    private final Object2ReferenceOpenHashMap<String, IPhysics> physicsValues = new Object2ReferenceOpenHashMap(16);
    private float lastRenderTicks = 0.0f;

    public void update(float renderTicks) {
        if (this.lastRenderTicks > 0.0f) {
            if (renderTicks > this.lastRenderTicks) {
                float interval = (renderTicks - this.lastRenderTicks) / 20.0f;
                this.lastRenderTicks = renderTicks;
                this.physicsValues.forEach((key, value) -> value.update(interval));
            }
        } else {
            this.lastRenderTicks = renderTicks;
        }
    }

    public void put(String key, IPhysics physics) {
        this.physicsValues.put((Object)key, (Object)physics);
    }

    @Nullable
    public IPhysics get(String key) {
        return (IPhysics)this.physicsValues.get((Object)key);
    }

    public void reset() {
        this.lastRenderTicks = 0.0f;
        this.physicsValues.clear();
    }
}

