/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.animation.gecko.magic;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.api.ILittleMaid;
import com.github.tartaricacid.touhoulittlemaid.api.animation.IMagicCastingAnimationProvider;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Comparator;
import java.util.List;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MagicCastingAnimationManager {
    private static List<IMagicCastingAnimationProvider> PROVIDERS = Lists.newArrayList();

    public static void init() {
        MagicCastingAnimationManager manager = new MagicCastingAnimationManager();
        for (ILittleMaid littleMaid : TouhouLittleMaid.EXTENSIONS) {
            littleMaid.registerMagicCastingAnimation(manager);
        }
        PROVIDERS = ImmutableList.copyOf(PROVIDERS);
    }

    public void register(IMagicCastingAnimationProvider provider) {
        PROVIDERS.add(provider);
        PROVIDERS.sort(Comparator.comparingInt(IMagicCastingAnimationProvider::getPriority).reversed());
    }

    public static List<IMagicCastingAnimationProvider> getProviders() {
        return PROVIDERS;
    }

    public static void clear() {
        PROVIDERS.clear();
    }
}

