/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.animation.gecko;

import com.github.tartaricacid.touhoulittlemaid.api.entity.IMaid;
import com.github.tartaricacid.touhoulittlemaid.client.animation.gecko.AnimationManager;
import com.github.tartaricacid.touhoulittlemaid.client.animation.gecko.AnimationState;
import com.github.tartaricacid.touhoulittlemaid.entity.favorability.Type;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntitySit;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.builder.ILoopType;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.event.predicate.AnimationEvent;
import java.util.function.BiPredicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.vehicle.Boat;

public class AnimationRegister {
    private static final double MIN_SPEED = 0.05;

    public static void registerAnimationState() {
        AnimationRegister.register("death", ILoopType.EDefaultLoopTypes.PLAY_ONCE, 0, (maid, event) -> maid.asEntity().m_21224_());
        AnimationRegister.register("sleep", 0, (maid, event) -> maid.asEntity().m_20089_() == Pose.SLEEPING);
        AnimationRegister.register("swim", 0, (maid, event) -> maid.asEntity().m_6067_());
        AnimationRegister.register("ladder_up", 0, (maid, event) -> maid.m_6147_() && AnimationRegister.getVerticalSpeed(maid) > 0.0f);
        AnimationRegister.register("ladder_stillness", 0, (maid, event) -> maid.m_6147_() && AnimationRegister.getVerticalSpeed(maid) == 0.0f);
        AnimationRegister.register("ladder_down", 0, (maid, event) -> maid.m_6147_() && AnimationRegister.getVerticalSpeed(maid) < 0.0f);
        AnimationRegister.register("gomoku", 1, (maid, event) -> AnimationRegister.sitInJoy(maid, Type.GOMOKU));
        AnimationRegister.register("bookshelf", 1, (maid, event) -> AnimationRegister.sitInJoy(maid, Type.BOOKSHELF));
        AnimationRegister.register("computer", 1, (maid, event) -> AnimationRegister.sitInJoy(maid, Type.COMPUTER));
        AnimationRegister.register("keyboard", 1, (maid, event) -> AnimationRegister.sitInJoy(maid, Type.KEYBOARD));
        AnimationRegister.register("picnic", 1, (maid, event) -> AnimationRegister.sitInJoy(maid, Type.ON_HOME_MEAL));
        AnimationRegister.register("boat", 1, (maid, event) -> maid.asEntity().m_20202_() instanceof Boat);
        AnimationRegister.register("chair", 1, (maid, event) -> maid.asEntity().m_20159_());
        AnimationRegister.register("sit", 1, (maid, event) -> maid.isMaidInSittingPose());
        AnimationRegister.register("swim_stand", 2, (maid, event) -> maid.asEntity().m_20069_());
        AnimationRegister.register("attacked", ILoopType.EDefaultLoopTypes.PLAY_ONCE, 2, (maid, event) -> maid.asEntity().f_20916_ > 0);
        AnimationRegister.register("jump", 2, (maid, event) -> !maid.asEntity().m_20096_() && !maid.asEntity().m_20069_());
        AnimationRegister.register("run", 3, (maid, event) -> maid.asEntity().m_20096_() && maid.asEntity().m_20142_());
        AnimationRegister.register("walk", 3, (maid, event) -> maid.asEntity().m_20096_() && (double)event.getLimbSwingAmount() > 0.05);
        AnimationRegister.register("idle", 4, (maid, event) -> true);
    }

    private static boolean sitInJoy(IMaid maid, Type type) {
        EntitySit sit;
        Entity entity = maid.asEntity().m_20202_();
        return entity instanceof EntitySit && (sit = (EntitySit)entity).getJoyType().equals(type.getTypeName());
    }

    private static void register(String animationName, ILoopType loopType, int priority, BiPredicate<IMaid, AnimationEvent<?>> predicate) {
        AnimationManager manager = AnimationManager.getInstance();
        manager.register(new AnimationState(animationName, loopType, priority, predicate));
    }

    private static void register(String animationName, int priority, BiPredicate<IMaid, AnimationEvent<?>> predicate) {
        AnimationRegister.register(animationName, ILoopType.EDefaultLoopTypes.LOOP, priority, predicate);
    }

    private static float getVerticalSpeed(IMaid maid) {
        Mob entity = maid.asEntity();
        return 20.0f * (float)(entity.m_20182_().f_82480_ - entity.f_19855_);
    }
}

