/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.block;

import com.github.tartaricacid.touhoulittlemaid.client.resource.CustomPackLoader;
import com.github.tartaricacid.touhoulittlemaid.init.InitBlocks;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import com.github.tartaricacid.touhoulittlemaid.item.ItemGarageKit;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityGarageKit;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.TerrainParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientBlockExtensions;
import net.minecraftforge.registries.ForgeRegistries;

public class BlockGarageKit
extends Block
implements EntityBlock {
    public static final VoxelShape BLOCK_AABB = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    private static final String ENTITY_INFO = "EntityInfo";

    public BlockGarageKit() {
        super(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_222469_).m_60913_(1.0f, 2.0f).m_60955_());
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void fillItemCategory(CreativeModeTab.Output items) {
        for (String modelId : CustomPackLoader.MAID_MODELS.getModelIdSet()) {
            ItemStack stack = new ItemStack((ItemLike)InitBlocks.GARAGE_KIT.get());
            CompoundTag data = stack.m_41698_(ENTITY_INFO);
            data.m_128359_("id", Objects.requireNonNull(ForgeRegistries.ENTITY_TYPES.getKey((Object)((EntityType)InitEntities.MAID.get()))).toString());
            data.m_128359_("ModelId", modelId);
            data.m_128379_("IsYsmModel", false);
            items.m_246342_(stack);
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TileEntityGarageKit(pos, state);
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockGarageKit.m_49840_((Level)worldIn, (BlockPos)pos, (ItemStack)this.getGarageKitFromWorld((BlockGetter)worldIn, pos));
        super.m_6810_(state, worldIn, pos, newState, isMoving);
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        this.getGarageKit((BlockGetter)worldIn, pos).ifPresent(te -> {
            Direction facing = Direction.SOUTH;
            if (placer != null) {
                facing = placer.m_6350_().m_122424_();
            }
            te.setData(facing, ItemGarageKit.getMaidData(stack));
        });
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        return this.getGarageKitFromWorld(world, pos);
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player playerIn, InteractionHand hand, BlockHitResult hit) {
        ItemStack stack = playerIn.m_21120_(hand);
        if (!(worldIn instanceof ServerLevel) || !(stack.m_41720_() instanceof SpawnEggItem)) {
            return InteractionResult.PASS;
        }
        BlockEntity tile = worldIn.m_7702_(pos);
        if (!(tile instanceof TileEntityGarageKit)) {
            return InteractionResult.PASS;
        }
        TileEntityGarageKit garageKit = (TileEntityGarageKit)tile;
        EntityType type = ((SpawnEggItem)stack.m_41720_()).m_43228_(stack.m_41783_());
        ResourceLocation key = ForgeRegistries.ENTITY_TYPES.getKey((Object)type);
        if (key == null) {
            return InteractionResult.PASS;
        }
        String id = key.toString();
        CompoundTag data = new CompoundTag();
        data.m_128359_("id", id);
        Entity entity = type.m_20615_(worldIn);
        if (entity instanceof Mob) {
            Mob mobEntity = (Mob)entity;
            mobEntity.m_6518_((ServerLevelAccessor)((ServerLevel)worldIn), worldIn.m_6436_(pos), MobSpawnType.SPAWN_EGG, null, data);
            mobEntity.m_7380_(data);
        }
        garageKit.setData(garageKit.getFacing(), data);
        return InteractionResult.SUCCESS;
    }

    public void initializeClient(Consumer<IClientBlockExtensions> consumer) {
        consumer.accept(new IClientBlockExtensions(){

            public boolean addHitEffects(BlockState state, Level world, HitResult target, ParticleEngine manager) {
                if (target instanceof BlockHitResult && world instanceof ClientLevel) {
                    BlockHitResult blockTarget = (BlockHitResult)target;
                    BlockPos pos = blockTarget.m_82425_();
                    ClientLevel clientWorld = (ClientLevel)world;
                    this.crack(clientWorld, pos, Blocks.f_50129_.m_49966_(), blockTarget.m_82434_());
                }
                return true;
            }

            public boolean addDestroyEffects(BlockState state, Level world, BlockPos pos, ParticleEngine manager) {
                Minecraft.m_91087_().f_91061_.m_107355_(pos, Blocks.f_50129_.m_49966_());
                return true;
            }

            @OnlyIn(value=Dist.CLIENT)
            private void crack(ClientLevel world, BlockPos pos, BlockState state, Direction side) {
                if (state.m_60799_() != RenderShape.INVISIBLE) {
                    int posX = pos.m_123341_();
                    int posY = pos.m_123342_();
                    int posZ = pos.m_123343_();
                    AABB aabb = state.m_60808_((BlockGetter)world, pos).m_83215_();
                    double x = (double)posX + world.f_46441_.m_188500_() * (aabb.f_82291_ - aabb.f_82288_ - 0.2) + 0.1 + aabb.f_82288_;
                    double y = (double)posY + world.f_46441_.m_188500_() * (aabb.f_82292_ - aabb.f_82289_ - 0.2) + 0.1 + aabb.f_82289_;
                    double z = (double)posZ + world.f_46441_.m_188500_() * (aabb.f_82293_ - aabb.f_82290_ - 0.2) + 0.1 + aabb.f_82290_;
                    if (side == Direction.DOWN) {
                        y = (double)posY + aabb.f_82289_ - 0.1;
                    }
                    if (side == Direction.UP) {
                        y = (double)posY + aabb.f_82292_ + 0.1;
                    }
                    if (side == Direction.NORTH) {
                        z = (double)posZ + aabb.f_82290_ - 0.1;
                    }
                    if (side == Direction.SOUTH) {
                        z = (double)posZ + aabb.f_82293_ + 0.1;
                    }
                    if (side == Direction.WEST) {
                        x = (double)posX + aabb.f_82288_ - 0.1;
                    }
                    if (side == Direction.EAST) {
                        x = (double)posX + aabb.f_82291_ + 0.1;
                    }
                    TerrainParticle diggingParticle = new TerrainParticle(world, x, y, z, 0.0, 0.0, 0.0, state);
                    Minecraft.m_91087_().f_91061_.m_107344_(diggingParticle.updateSprite(state, pos).m_107268_(0.2f).m_6569_(0.6f));
                }
            }
        });
    }

    private ItemStack getGarageKitFromWorld(BlockGetter world, BlockPos pos) {
        ItemStack stack = new ItemStack((ItemLike)InitBlocks.GARAGE_KIT.get());
        this.getGarageKit(world, pos).ifPresent(te -> stack.m_41784_().m_128365_(ENTITY_INFO, (Tag)te.getExtraData()));
        return stack;
    }

    private Optional<TileEntityGarageKit> getGarageKit(BlockGetter world, BlockPos pos) {
        BlockEntity te = world.m_7702_(pos);
        if (te instanceof TileEntityGarageKit) {
            return Optional.of((TileEntityGarageKit)te);
        }
        return Optional.empty();
    }

    @Nullable
    public EntityType<?> getType(@Nullable CompoundTag nbt) {
        CompoundTag compound;
        if (nbt != null && nbt.m_128425_("EntityTag", 10) && (compound = nbt.m_128469_("EntityTag")).m_128425_("id", 8)) {
            return EntityType.m_20632_((String)compound.m_128461_("id")).orElse(null);
        }
        return null;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return BLOCK_AABB;
    }
}

