/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.api.game.gomoku;

import com.github.tartaricacid.touhoulittlemaid.api.game.gomoku.Point;
import java.io.ByteArrayOutputStream;
import java.util.Base64;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.apache.commons.lang3.StringUtils;

public final class GomokuCodec {
    private GomokuCodec() {
    }

    public static String encode(StateData stateData) {
        int[][] board = stateData.board();
        int turnCount = stateData.turnCount();
        Point latestPoint = stateData.latestPoint();
        byte[] data = new byte[450];
        for (int i = 0; i < 15; ++i) {
            for (int j = 0; j < 15; ++j) {
                int type = board[i][j];
                int pos = i * 15 + j;
                if (type == 1) {
                    data[pos] = 1;
                    continue;
                }
                if (type != 2) continue;
                data[225 + pos] = 1;
            }
        }
        Deflater deflater = new Deflater(9, false);
        deflater.setInput(data);
        deflater.finish();
        try {
            String string;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                byte[] buf = new byte[4096];
                while (!deflater.finished()) {
                    int len = deflater.deflate(buf);
                    if (len <= 0) continue;
                    out.write(buf, 0, len);
                }
                byte[] compressed = out.toByteArray();
                String payload = Base64.getUrlEncoder().withoutPadding().encodeToString(compressed);
                string = payload + ", " + turnCount + ", " + latestPoint.x + "_" + latestPoint.y;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        out.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to encode gomoku state", e);
                }
            }
            out.close();
            return string;
        }
        finally {
            deflater.end();
        }
    }

    public static StateData decode(String dataStr) {
        String clean = StringUtils.deleteWhitespace((String)dataStr);
        String[] parts = clean.split(",");
        if (parts.length != 3) {
            throw new IllegalArgumentException("Data must be in format <base64>, turnCount, x_y");
        }
        byte[] compressed = Base64.getUrlDecoder().decode(parts[0]);
        Inflater inflater = new Inflater();
        inflater.setInput(compressed);
        byte[] data = new byte[450];
        try {
            int resultLength = inflater.inflate(data);
            if (resultLength != data.length) {
                throw new IllegalArgumentException("Decompressed data length mismatch");
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to decompress data", e);
        }
        finally {
            inflater.end();
        }
        int[][] board = new int[15][15];
        for (int i = 0; i < 15; ++i) {
            for (int j = 0; j < 15; ++j) {
                int pos = i * 15 + j;
                board[i][j] = data[pos] == 1 ? 1 : (data[225 + pos] == 1 ? 2 : 0);
            }
        }
        int turnCount = Integer.parseInt(parts[1]);
        String[] pointParts = parts[2].split("_");
        if (pointParts.length != 2) {
            throw new IllegalArgumentException("Latest point must be in format x_y");
        }
        int x = Integer.parseInt(pointParts[0]);
        int y = Integer.parseInt(pointParts[1]);
        int type = board[x][y];
        Point latestPoint = new Point(x, y, type);
        return new StateData(board, turnCount, latestPoint);
    }

    public record StateData(int[][] board, int turnCount, Point latestPoint) {
    }
}

