/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.api.event.client;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.client.resource.GeckoModelLoader;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.file.AnimationFile;
import java.io.IOException;
import java.io.InputStream;
import java.util.EnumMap;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.ApiStatus;

public class DefaultGeckoAnimationEvent
extends Event {
    private final EnumMap<AnimationType, AnimationFile> animationFiles;

    public DefaultGeckoAnimationEvent(EnumMap<AnimationType, AnimationFile> animationFiles) {
        this.animationFiles = animationFiles;
    }

    @Deprecated(since="1.4.7")
    public AnimationFile getMaidAnimationFile() {
        return this.animationFiles.get((Object)AnimationType.MAID);
    }

    @Deprecated(since="1.4.7")
    public AnimationFile getTacAnimationFile() {
        return this.animationFiles.get((Object)AnimationType.TAC);
    }

    @Deprecated(since="1.4.7")
    public AnimationFile getChairAnimationFile() {
        return this.animationFiles.get((Object)AnimationType.CHAIR);
    }

    @ApiStatus.AvailableSince(value="1.4.7")
    public AnimationFile getAnimationFile(AnimationType type) {
        return this.animationFiles.get((Object)type);
    }

    public void addAnimation(AnimationFile animationFile, ResourceLocation file) {
        try (InputStream stream = Minecraft.m_91087_().m_91098_().m_215595_(file);){
            GeckoModelLoader.mergeAnimationFile(stream, animationFile);
        }
        catch (IOException e) {
            TouhouLittleMaid.LOGGER.error("Failed to load animation file", (Throwable)e);
        }
    }

    @ApiStatus.AvailableSince(value="1.4.7")
    public void addAnimation(AnimationType type, ResourceLocation file) {
        AnimationFile animationFile = this.animationFiles.get((Object)type);
        if (animationFile != null) {
            this.addAnimation(animationFile, file);
        }
    }

    public static enum AnimationType {
        MAID,
        TAC,
        CHAIR,
        ISS,
        IM;

    }
}

