/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.api.block;

import com.github.tartaricacid.touhoulittlemaid.datagen.tag.TagBlock;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.AvailableSince(value="1.4.7")
public interface IMaidEdibleBlock {
    public static boolean belowIsSnackStand(EntityMaid maid, BlockPos pos) {
        BlockPos belowPos = pos.m_7495_();
        BlockState belowState = maid.f_19853_.m_8055_(belowPos);
        return belowState.m_204336_(TagBlock.MAID_SNACK_STAND_BLOCK);
    }

    public boolean shouldMoveTo(EntityMaid var1, BlockPos var2, BlockState var3);

    public int getFavorabilityPoints(EntityMaid var1, BlockPos var2, BlockState var3);

    public boolean consume(EntityMaid var1, BlockPos var2, BlockState var3);

    default public boolean canPlaceAsFood(EntityMaid maid, ItemStack stack, int slotIndex) {
        return false;
    }

    default public boolean shouldPlaceTo(EntityMaid maid, BlockPos pos, BlockState state, ItemStack stack) {
        if (pos.equals((Object)maid.m_20183_())) {
            return false;
        }
        if (!state.m_247087_()) {
            return false;
        }
        return IMaidEdibleBlock.belowIsSnackStand(maid, pos);
    }

    default public boolean placeAsFood(EntityMaid maid, BlockPos pos, ItemStack stack, int slotIndex) {
        CombinedInvWrapper availableInv = maid.getAvailableInv(true);
        ItemStack stackExtra = availableInv.extractItem(slotIndex, 1, false);
        if (stackExtra.m_41619_()) {
            return false;
        }
        return maid.placeItemBlock(pos, stackExtra);
    }
}

