/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.api.bauble;

import com.github.tartaricacid.touhoulittlemaid.api.task.IRangedAttackTask;
import com.github.tartaricacid.touhoulittlemaid.api.task.meal.MaidMealType;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.util.Random;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.jetbrains.annotations.ApiStatus;

public interface IMaidBauble {
    public static final Random RANDOM = new Random();

    default public void onTick(EntityMaid maid, ItemStack baubleItem) {
    }

    @ApiStatus.AvailableSince(value="1.4.2")
    default public boolean onInjured(EntityMaid maid, ItemStack baubleItem, DamageSource source, MutableFloat damage) {
        return false;
    }

    @ApiStatus.AvailableSince(value="1.4.2")
    default public boolean onDeath(EntityMaid maid, ItemStack baubleItem, DamageSource source) {
        return false;
    }

    @ApiStatus.AvailableSince(value="1.4.2")
    default public void onPutOn(EntityMaid maid, ItemStack baubleItem) {
    }

    @ApiStatus.AvailableSince(value="1.4.2")
    default public void onTakeOff(EntityMaid maid, ItemStack baubleItem) {
    }

    @ApiStatus.AvailableSince(value="1.4.2")
    default public void onMeleeAttack(EntityMaid maid, ItemStack baubleItem, Entity target) {
    }

    @ApiStatus.AvailableSince(value="1.4.2")
    default public void onRangedAttack(EntityMaid maid, ItemStack baubleItem, IRangedAttackTask task) {
    }

    @ApiStatus.AvailableSince(value="1.4.2")
    default public void onMaidEat(EntityMaid maid, ItemStack baubleItem, ItemStack foodItem, MaidMealType mealType) {
    }

    @ApiStatus.AvailableSince(value="1.4.2")
    default public void onFavorabilityLevelChange(EntityMaid maid, ItemStack baubleItem, int oldLevel, int newLevel) {
    }

    @ApiStatus.AvailableSince(value="1.4.7")
    default public boolean syncClient(EntityMaid maid, ItemStack baubleItem) {
        return false;
    }

    @Deprecated
    default public String getChatBubbleId() {
        return "";
    }
}

