/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.ai.service.llm;

import com.github.tartaricacid.touhoulittlemaid.ai.service.llm.Role;
import com.github.tartaricacid.touhoulittlemaid.ai.service.llm.openai.response.ToolCall;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;

public record LLMMessage(Role role, String message, long gameTime, @Nullable List<ToolCall> toolCalls, @Nullable String toolCallId) {
    public static Codec<LLMMessage> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Role.CODEC.fieldOf("role").forGetter(LLMMessage::role), (App)Codec.STRING.optionalFieldOf("message").forGetter(s -> Optional.ofNullable(s.message)), (App)Codec.LONG.fieldOf("game_time").forGetter(LLMMessage::gameTime), (App)ToolCall.CODEC.listOf().optionalFieldOf("tool_calls").forGetter(s -> Optional.ofNullable(s.toolCalls)), (App)Codec.STRING.optionalFieldOf("tool_call_id").forGetter(s -> Optional.ofNullable(s.toolCallId))).apply((Applicative)instance, (role, message, gameTime, toolCalls, toolCallId) -> new LLMMessage((Role)((Object)((Object)role)), message.orElse(""), (long)gameTime, toolCalls.orElse(null), toolCallId.orElse(null))));

    public static LLMMessage userChat(EntityMaid maid, String message) {
        long time = maid.f_19853_.m_46467_();
        return new LLMMessage(Role.USER, message, time, null, null);
    }

    public static LLMMessage assistantChat(EntityMaid maid, String message) {
        long time = maid.f_19853_.m_46467_();
        return new LLMMessage(Role.ASSISTANT, message, time, null, null);
    }

    public static LLMMessage assistantChat(EntityMaid maid, String message, List<ToolCall> toolCalls) {
        long time = maid.f_19853_.m_46467_();
        return new LLMMessage(Role.ASSISTANT, message, time, toolCalls, null);
    }

    public static LLMMessage systemChat(EntityMaid maid, String message) {
        long time = maid.f_19853_.m_46467_();
        return new LLMMessage(Role.SYSTEM, message, time, null, null);
    }

    public static LLMMessage toolChat(EntityMaid maid, String message, String toolCallId) {
        long time = maid.f_19853_.m_46467_();
        return new LLMMessage(Role.TOOL, message, time, null, toolCallId);
    }
}

