/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.ai.manager.entity;

import com.github.tartaricacid.touhoulittlemaid.client.resource.CustomPackLoader;
import com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.MaidModelInfo;
import com.github.tartaricacid.touhoulittlemaid.compat.ysm.YsmCompat;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.util.ParseI18n;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public record ChatClientInfo(String language, String name, List<String> description) {
    public void encode(FriendlyByteBuf buf) {
        buf.m_130070_(this.language);
        buf.m_130070_(this.name);
        buf.m_130130_(this.description.size());
        for (String line : this.description) {
            buf.m_130070_(line);
        }
    }

    public static ChatClientInfo decode(FriendlyByteBuf buf) {
        String language = buf.m_130277_();
        String name = buf.m_130277_();
        int size = buf.m_130242_();
        ArrayList description = Lists.newArrayListWithExpectedSize((int)size);
        for (int i = 0; i < size; ++i) {
            description.add(buf.m_130277_());
        }
        return new ChatClientInfo(language, name, description);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static ChatClientInfo fromMaid(EntityMaid maid) {
        String language = ChatClientInfo.getClientLanguage();
        String name = ChatClientInfo.getMaidName(maid);
        List<String> description = ChatClientInfo.getMaidDescription(maid);
        return new ChatClientInfo(language, name, description);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static String getClientLanguage() {
        return Minecraft.m_91087_().m_91102_().m_264236_();
    }

    @OnlyIn(value=Dist.CLIENT)
    private static String getMaidName(EntityMaid maid) {
        return maid.m_7755_().getString();
    }

    @OnlyIn(value=Dist.CLIENT)
    private static List<String> getMaidDescription(EntityMaid maid) {
        ArrayList description = Lists.newArrayList();
        if (YsmCompat.isInstalled() && maid.isYsmModel()) {
            return description;
        }
        Optional<MaidModelInfo> info = CustomPackLoader.MAID_MODELS.getInfo(maid.getModelId());
        if (info.isPresent()) {
            MaidModelInfo maidModelInfo = info.get();
            List<Component> parse = ParseI18n.parse(maidModelInfo.getDescription());
            parse.forEach(component -> description.add(component.getString()));
        }
        return description;
    }
}

