/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.simplebedrockmodel.client.bedrock.pojo;

import com.google.gson.annotations.SerializedName;

public class FaceItem {
    @SerializedName(value="uv")
    private float[] uv;
    @SerializedName(value="uv_size")
    private float[] uvSize;
    @SerializedName(value="uv_rotation")
    private int uvRotation = 0;

    public FaceItem(float[] uv, float[] uvSize) {
        this.uv = uv;
        this.uvSize = uvSize;
    }

    public float[] getUv() {
        return this.uv;
    }

    public float[] getUvSize() {
        return this.uvSize;
    }

    public float[] getRotatedUVs(float texWidth, float texHeight) {
        float[] fArray;
        float u1 = this.uv[0] / texWidth;
        float v1 = this.uv[1] / texHeight;
        float u2 = (this.uv[0] + this.uvSize[0]) / texWidth;
        float v2 = (this.uv[1] + this.uvSize[1]) / texHeight;
        switch (this.uvRotation) {
            case 90: {
                float[] fArray2 = new float[8];
                fArray2[0] = u1;
                fArray2[1] = v1;
                fArray2[2] = u1;
                fArray2[3] = v2;
                fArray2[4] = u2;
                fArray2[5] = v2;
                fArray2[6] = u2;
                fArray = fArray2;
                fArray2[7] = v1;
                break;
            }
            case 180: {
                float[] fArray3 = new float[8];
                fArray3[0] = u1;
                fArray3[1] = v2;
                fArray3[2] = u2;
                fArray3[3] = v2;
                fArray3[4] = u2;
                fArray3[5] = v1;
                fArray3[6] = u1;
                fArray = fArray3;
                fArray3[7] = v1;
                break;
            }
            case 270: {
                float[] fArray4 = new float[8];
                fArray4[0] = u2;
                fArray4[1] = v2;
                fArray4[2] = u2;
                fArray4[3] = v1;
                fArray4[4] = u1;
                fArray4[5] = v1;
                fArray4[6] = u1;
                fArray = fArray4;
                fArray4[7] = v2;
                break;
            }
            default: {
                float[] fArray5 = new float[8];
                fArray5[0] = u2;
                fArray5[1] = v1;
                fArray5[2] = u1;
                fArray5[3] = v1;
                fArray5[4] = u1;
                fArray5[5] = v2;
                fArray5[6] = u2;
                fArray = fArray5;
                fArray5[7] = v2;
            }
        }
        return fArray;
    }
}

