/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.simplebedrockmodel.client.bedrock.pojo;

import com.github.tartaricacid.simplebedrockmodel.SimpleBedrockModel;
import com.github.tartaricacid.simplebedrockmodel.client.bedrock.pojo.BedrockModelPOJO;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;

@OnlyIn(value=Dist.CLIENT)
public enum BedrockVersion {
    LEGACY("[1.10.0]"),
    NEW("[1.12.0,)");

    private final VersionRange versionRange;

    private BedrockVersion(String version) {
        this.versionRange = BedrockVersion.createFromVersionSpec(version);
    }

    public static boolean isNewVersion(BedrockModelPOJO bedrockModel) {
        DefaultArtifactVersion inputVersion = new DefaultArtifactVersion(bedrockModel.getFormatVersion());
        return BedrockVersion.NEW.versionRange.containsVersion((ArtifactVersion)inputVersion);
    }

    public static boolean isLegacyVersion(BedrockModelPOJO bedrockModel) {
        DefaultArtifactVersion inputVersion = new DefaultArtifactVersion(bedrockModel.getFormatVersion());
        return BedrockVersion.LEGACY.versionRange.containsVersion((ArtifactVersion)inputVersion);
    }

    private static VersionRange createFromVersionSpec(String spec) {
        try {
            return VersionRange.createFromVersionSpec((String)spec);
        }
        catch (InvalidVersionSpecificationException e) {
            SimpleBedrockModel.LOGGER.fatal("Failed to parse version spec {}", (Object)spec, (Object)e);
            throw new RuntimeException("Failed to parse spec", e);
        }
    }

    public static BedrockVersion getVersion(BedrockModelPOJO pojo) throws InvalidVersionSpecificationException {
        if (BedrockVersion.isNewVersion(pojo)) {
            return NEW;
        }
        if (BedrockVersion.isLegacyVersion(pojo)) {
            return LEGACY;
        }
        throw new InvalidVersionSpecificationException("Invalid version for model: " + pojo);
    }
}

