/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.simplebedrockmodel.client.bedrock.model;

import com.github.tartaricacid.simplebedrockmodel.client.bedrock.model.BedrockCube;
import com.github.tartaricacid.simplebedrockmodel.client.bedrock.pojo.FaceItem;
import com.github.tartaricacid.simplebedrockmodel.client.bedrock.pojo.FaceUVsItem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.core.Direction;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class BedrockCubePerFace
implements BedrockCube {
    protected static final Vector3f[] VERTICES = new Vector3f[8];
    protected static final Vector3f EDGE_X = new Vector3f();
    protected static final Vector3f EDGE_Y = new Vector3f();
    protected static final Vector3f EDGE_Z = new Vector3f();
    protected final float width;
    protected final float height;
    protected final float depth;
    protected final float x;
    protected final float y;
    protected final float z;
    protected final float[][] uvs = new float[6][8];
    protected int emptyFacesMask = 0;

    public BedrockCubePerFace(float x, float y, float z, float width, float height, float depth, float delta, float texWidth, float texHeight, FaceUVsItem faces) {
        this.x = (x - delta) / 16.0f;
        this.y = (y - delta) / 16.0f;
        this.z = (z - delta) / 16.0f;
        this.width = (width + delta * 2.0f) / 16.0f;
        this.height = (height + delta * 2.0f) / 16.0f;
        this.depth = (depth + delta * 2.0f) / 16.0f;
        for (Direction direction : Direction.values()) {
            this.fillUV(direction, faces, texWidth, texHeight);
        }
    }

    private static boolean equalZero(float[] uvSize) {
        return (double)Math.abs(uvSize[0]) < 1.0E-9 && (double)Math.abs(uvSize[1]) < 1.0E-9;
    }

    private void fillUV(Direction direction, FaceUVsItem faces, float texWidth, float texHeight) {
        FaceItem face = faces.getFace(direction);
        if (face == null) {
            this.emptyFacesMask |= 1 << direction.ordinal();
            return;
        }
        if (BedrockCubePerFace.equalZero(face.getUvSize())) {
            this.emptyFacesMask |= 1 << direction.ordinal();
            return;
        }
        float[] rotatedUVs = face.getRotatedUVs(texWidth, texHeight);
        System.arraycopy(rotatedUVs, 0, this.uvs[direction.ordinal()], 0, 8);
    }

    protected void prepareVertices(Matrix4f pose) {
        EDGE_X.set(pose.m00(), pose.m01(), pose.m02()).mul(this.width);
        EDGE_Y.set(pose.m10(), pose.m11(), pose.m12()).mul(this.height);
        EDGE_Z.set(pose.m20(), pose.m21(), pose.m22()).mul(this.depth);
        VERTICES[0].set(this.x, this.y, this.z).mulPosition((Matrix4fc)pose);
        VERTICES[0].add((Vector3fc)EDGE_X, VERTICES[1]);
        VERTICES[1].add((Vector3fc)EDGE_Y, VERTICES[2]);
        VERTICES[0].add((Vector3fc)EDGE_Y, VERTICES[3]);
        VERTICES[0].add((Vector3fc)EDGE_Z, VERTICES[4]);
        VERTICES[1].add((Vector3fc)EDGE_Z, VERTICES[5]);
        VERTICES[2].add((Vector3fc)EDGE_Z, VERTICES[6]);
        VERTICES[3].add((Vector3fc)EDGE_Z, VERTICES[7]);
    }

    @Override
    public void compile(PoseStack.Pose pose, Vector3f[] normals, VertexConsumer consumer, int lightmap, int overlay, float r, float g, float b, float a) {
        Matrix4f matrix4f = pose.m_252922_();
        this.prepareVertices(matrix4f);
        for (int i = 0; i < 6; ++i) {
            if ((this.emptyFacesMask & 1 << i) != 0) continue;
            consumer.m_5954_(BedrockCubePerFace.VERTICES[BedrockCubePerFace.VERTEX_ORDER[i][0]].x, BedrockCubePerFace.VERTICES[BedrockCubePerFace.VERTEX_ORDER[i][0]].y, BedrockCubePerFace.VERTICES[BedrockCubePerFace.VERTEX_ORDER[i][0]].z, r, g, b, a, this.uvs[i][0], this.uvs[i][1], overlay, lightmap, normals[i].x, normals[i].y, normals[i].z);
            consumer.m_5954_(BedrockCubePerFace.VERTICES[BedrockCubePerFace.VERTEX_ORDER[i][1]].x, BedrockCubePerFace.VERTICES[BedrockCubePerFace.VERTEX_ORDER[i][1]].y, BedrockCubePerFace.VERTICES[BedrockCubePerFace.VERTEX_ORDER[i][1]].z, r, g, b, a, this.uvs[i][2], this.uvs[i][3], overlay, lightmap, normals[i].x, normals[i].y, normals[i].z);
            consumer.m_5954_(BedrockCubePerFace.VERTICES[BedrockCubePerFace.VERTEX_ORDER[i][2]].x, BedrockCubePerFace.VERTICES[BedrockCubePerFace.VERTEX_ORDER[i][2]].y, BedrockCubePerFace.VERTICES[BedrockCubePerFace.VERTEX_ORDER[i][2]].z, r, g, b, a, this.uvs[i][4], this.uvs[i][5], overlay, lightmap, normals[i].x, normals[i].y, normals[i].z);
            consumer.m_5954_(BedrockCubePerFace.VERTICES[BedrockCubePerFace.VERTEX_ORDER[i][3]].x, BedrockCubePerFace.VERTICES[BedrockCubePerFace.VERTEX_ORDER[i][3]].y, BedrockCubePerFace.VERTICES[BedrockCubePerFace.VERTEX_ORDER[i][3]].z, r, g, b, a, this.uvs[i][6], this.uvs[i][7], overlay, lightmap, normals[i].x, normals[i].y, normals[i].z);
        }
    }

    static {
        for (int i = 0; i < VERTICES.length; ++i) {
            BedrockCubePerFace.VERTICES[i] = new Vector3f();
        }
    }
}

