/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdlib.util.client.particles.lightning_particle;

import com.finderfeed.fdlib.util.client.particles.lightning_particle.LightningParticleOptions;
import com.finderfeed.fdlib.util.math.FDMathUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Random;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class LightningParticle
extends Particle {
    private LightningParticleOptions options;
    private float particleRoll;
    private int seed;
    public static final ParticleRenderType RENDER_TYPE = new ParticleRenderType(){

        @Nullable
        public void m_6505_(BufferBuilder tesselator, TextureManager manager) {
            RenderSystem.depthMask((boolean)true);
            RenderSystem.enableBlend();
            RenderSystem.disableCull();
            RenderSystem.setShader(GameRenderer::m_172753_);
            RenderSystem.blendFunc((int)770, (int)771);
            tesselator.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        }

        public void m_6294_(Tesselator tesselator) {
            tesselator.m_85914_();
        }

        public String toString() {
            return "LIGHTNING_RENDER_TYPE";
        }
    };

    public LightningParticle(LightningParticleOptions options, ClientLevel level, double x, double y, double z, double xd, double yd, double zd) {
        super(level, x, y, z, xd, yd, zd);
        this.f_107212_ = x;
        this.f_107213_ = y;
        this.f_107214_ = z;
        this.f_107215_ = xd;
        this.f_107216_ = yd;
        this.f_107217_ = zd;
        this.options = options;
        this.f_107225_ = options.getLifetime();
        this.m_107250_(options.getQuadSize(), options.getQuadSize());
        if (level != null) {
            this.particleRoll = level.f_46441_.m_188501_() * 360.0f;
            if (options.getSeed() == -1) {
                this.seed = level.f_46441_.m_188502_();
            }
        } else {
            this.particleRoll = 0.0f;
        }
        this.f_107219_ = options.hasPhysics();
        options.getProcessor().init(this);
    }

    public void m_5989_() {
        this.options.getProcessor().processParticle(this);
        super.m_5989_();
    }

    public void m_5744_(VertexConsumer vertex, Camera camera, float pticks) {
        Vec3 lpos = new Vec3(FDMathUtil.lerp(this.f_107209_, this.f_107212_, (double)pticks), FDMathUtil.lerp(this.f_107210_, this.f_107213_, (double)pticks), FDMathUtil.lerp(this.f_107211_, this.f_107214_, (double)pticks));
        Matrix4fStack mat = new Matrix4fStack();
        long time = this.f_107208_.m_46467_();
        Random r = new Random(time + (long)this.seed);
        Matrix4f rotMat = new Matrix4f();
        Quaternionf q = camera.m_253121_();
        q.get(rotMat);
        Vec3 pos = lpos.m_82546_(camera.m_90583_());
        mat.translate((float)pos.f_82479_, (float)pos.f_82480_, (float)pos.f_82481_);
        mat.mul((Matrix4fc)rotMat);
        mat.rotateZ((float)Math.toRadians(this.particleRoll + (float)(this.options.isRandomRoll() ? r.nextInt(360) : 0)));
        float size = this.options.getQuadSize();
        Vector3f startPos = new Vector3f(-size / 2.0f, 0.0f, 0.0f);
        int remainingParts = this.options.getMaxLightningSegments();
        float length = size / (float)remainingParts;
        float width = size / 8.0f;
        LightningNode main = this.constructLightningNodes(null, r, startPos, new Vector3f(length, 0.0f, 0.0f), remainingParts, r.nextInt(3) + 2);
        if (main != null) {
            this.renderLightningNode((Matrix4f)mat, main, vertex, width, (float)this.options.getR() / 255.0f, (float)this.options.getG() / 255.0f, (float)this.options.getB() / 255.0f, 1.0f, 0.0f);
            this.renderLightningNode((Matrix4f)mat, main, vertex, width / 4.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0E-4f);
        }
    }

    private void renderLightningNode(Matrix4f transform, LightningNode node, VertexConsumer vertex, float lightningWidth, float r, float g, float b, float a, float zOffset) {
        Vector3f direction = node.end.sub((Vector3fc)node.start, new Vector3f()).normalize();
        Vector3f prev = this.vectorBetweenCurrentAndPrevious(node);
        Vector3f vector3f = new Vector3f(0.0f, 1.0f, 0.0f);
        if (prev.dot((Vector3fc)vector3f) < 0.0f) {
            prev = prev.mul(-1.0f);
        }
        Vector3f cr = direction.cross((Vector3fc)prev, new Vector3f());
        float sin1 = cr.length();
        Vector3f currentBetween = this.vectorBetweenCurrentAndNext(node, 0);
        Vector3f vector3f2 = new Vector3f(0.0f, 1.0f, 0.0f);
        if (currentBetween.dot((Vector3fc)vector3f2) < 0.0f) {
            currentBetween = currentBetween.mul(-1.0f);
        }
        Vector3f cr2 = direction.cross((Vector3fc)currentBetween, new Vector3f());
        float sin2 = cr2.length();
        float whiteWidthMult = 0.25f;
        float widthStart = lightningWidth / sin1;
        float widthEnd = lightningWidth / sin2;
        vertex.m_252986_(transform, node.start.x - prev.x * widthStart * whiteWidthMult, node.start.y - prev.y * widthStart * whiteWidthMult, zOffset).m_85950_(r, g, b, a).m_5752_();
        vertex.m_252986_(transform, node.end.x - currentBetween.x * widthEnd * whiteWidthMult, node.end.y - currentBetween.y * widthEnd * whiteWidthMult, zOffset).m_85950_(r, g, b, a).m_5752_();
        vertex.m_252986_(transform, node.end.x + currentBetween.x * widthEnd * whiteWidthMult, node.end.y + currentBetween.y * widthEnd * whiteWidthMult, zOffset).m_85950_(r, g, b, a).m_5752_();
        vertex.m_252986_(transform, node.start.x + prev.x * widthStart * whiteWidthMult, node.start.y + prev.y * widthStart * whiteWidthMult, zOffset).m_85950_(r, g, b, a).m_5752_();
        for (int i = 0; i < node.branches.size(); ++i) {
            this.renderLightningNode(transform, node.branches.get(i), vertex, lightningWidth, r, g, b, a, zOffset);
        }
    }

    private Vector3f vectorBetweenCurrentAndPrevious(LightningNode node) {
        Vector3f currentDir = node.end.sub((Vector3fc)node.start, new Vector3f());
        if (node.previous == null) {
            return new Vector3f(0.0f, 1.0f, 0.0f);
        }
        Vector3f lastDir = node.previous.start.sub((Vector3fc)node.previous.end, new Vector3f());
        return FDMathUtil.vectorBetweenVectors(currentDir, lastDir);
    }

    private Vector3f vectorBetweenCurrentAndNext(LightningNode node, int id) {
        Vector3f lastDir;
        Vector3f currentDir = node.start.sub((Vector3fc)node.end, new Vector3f());
        if (node.branches.isEmpty()) {
            lastDir = currentDir.normalize(new Vector3f()).rotateZ(1.5707964f);
        } else {
            LightningNode nd = node.branches.get(id);
            lastDir = nd.end.sub((Vector3fc)nd.start, new Vector3f());
        }
        return FDMathUtil.vectorBetweenVectors(currentDir, lastDir);
    }

    private LightningNode constructLightningNodes(LightningNode previous, Random random, Vector3f startPos, Vector3f direction, int remainingParts, int branches) {
        Vector3f endPos = startPos.add((Vector3fc)direction, new Vector3f());
        ArrayList<LightningNode> b = new ArrayList<LightningNode>();
        LightningNode node = new LightningNode(previous, startPos, endPos, b);
        if (remainingParts <= 0) {
            return null;
        }
        for (int i = 0; i < branches; ++i) {
            Vector3f newDir = direction.rotateZ(random.nextFloat() * (float)Math.PI / 1.5f - 1.0471976f, new Vector3f());
            LightningNode node1 = this.constructLightningNodes(node, random, endPos, newDir, remainingParts - random.nextInt(1) - 1, random.nextInt(2) + 1);
            if (node1 == null) continue;
            b.add(node1);
        }
        return node;
    }

    public ParticleRenderType m_7556_() {
        return RENDER_TYPE;
    }

    public record LightningNode(LightningNode previous, Vector3f start, Vector3f end, List<LightningNode> branches) {
    }

    public static class Factory
    implements ParticleProvider<LightningParticleOptions> {
        @Nullable
        public Particle createParticle(LightningParticleOptions options, ClientLevel level, double x, double y, double z, double xd, double yd, double zd) {
            return new LightningParticle(options, level, x, y, z, xd, yd, zd);
        }
    }
}

