/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdlib.util.client.particles.ball_particle;

import com.finderfeed.fdlib.init.FDParticles;
import com.finderfeed.fdlib.systems.particle.EmptyParticleProcessor;
import com.finderfeed.fdlib.systems.particle.ParticleProcessor;
import com.finderfeed.fdlib.systems.stream_codecs.NetworkCodec;
import com.finderfeed.fdlib.util.FDCodecs;
import com.finderfeed.fdlib.util.FDColor;
import com.finderfeed.fdlib.util.client.particles.options.AlphaOptions;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;

public class BallParticleOptions
implements ParticleOptions {
    public static final ParticleOptions.Deserializer<BallParticleOptions> DESERIALIZER = new ParticleOptions.Deserializer<BallParticleOptions>(){

        public BallParticleOptions fromCommand(ParticleType<BallParticleOptions> p_123733_, StringReader p_123734_) throws CommandSyntaxException {
            return BallParticleOptions.builder().build();
        }

        public BallParticleOptions fromNetwork(ParticleType<BallParticleOptions> p_123735_, FriendlyByteBuf p_123736_) {
            return STREAM_CODEC.fromNetwork(p_123736_);
        }
    };
    public static final Codec<BallParticleOptions> CODEC = RecordCodecBuilder.create(p -> p.group((App)ParticleProcessor.CODEC.fieldOf("processor").forGetter(v -> v.particleProcessor), (App)AlphaOptions.CODEC.fieldOf("scalingOptions").forGetter(v -> v.scalingOptions), (App)FDCodecs.COLOR.fieldOf("color").forGetter(v -> v.color), (App)Codec.FLOAT.fieldOf("friction").forGetter(v -> Float.valueOf(v.friction)), (App)Codec.BOOL.fieldOf("hasPhysics").forGetter(v -> v.hasPhysics), (App)Codec.FLOAT.fieldOf("size").forGetter(v -> Float.valueOf(v.size)), (App)Codec.INT.fieldOf("brightness").forGetter(v -> v.brightness)).apply((Applicative)p, (processor, scaling, color, friction, physics, size, brightness) -> {
        BallParticleOptions ballParticleOptions = new BallParticleOptions();
        ballParticleOptions.size = size.floatValue();
        ballParticleOptions.particleProcessor = processor;
        ballParticleOptions.color = color;
        ballParticleOptions.friction = friction.floatValue();
        ballParticleOptions.hasPhysics = physics;
        ballParticleOptions.scalingOptions = scaling;
        ballParticleOptions.brightness = brightness;
        return ballParticleOptions;
    }));
    public static final MapCodec<BallParticleOptions> MAP_CODEC = CODEC.fieldOf("options");
    public static final NetworkCodec<BallParticleOptions> STREAM_CODEC = NetworkCodec.composite(ParticleProcessor.STREAM_CODEC, v -> v.particleProcessor, AlphaOptions.STREAM_CODEC, v -> v.scalingOptions, NetworkCodec.COLOR, v -> v.color, NetworkCodec.FLOAT, v -> Float.valueOf(v.friction), NetworkCodec.BOOL, v -> v.hasPhysics, NetworkCodec.FLOAT, v -> Float.valueOf(v.size), NetworkCodec.INT, v -> v.brightness, (processor, scaling, color, friction, physics, size, brightness) -> {
        BallParticleOptions ballParticleOptions = new BallParticleOptions();
        ballParticleOptions.size = size.floatValue();
        ballParticleOptions.particleProcessor = processor;
        ballParticleOptions.color = color;
        ballParticleOptions.friction = friction.floatValue();
        ballParticleOptions.hasPhysics = physics;
        ballParticleOptions.brightness = brightness;
        ballParticleOptions.scalingOptions = scaling;
        return ballParticleOptions;
    });
    public ParticleProcessor<?> particleProcessor = new EmptyParticleProcessor();
    public AlphaOptions scalingOptions = new AlphaOptions();
    public FDColor color = new FDColor(1.0f, 1.0f, 1.0f, 1.0f);
    public float friction = 1.0f;
    public boolean hasPhysics = false;
    public float size = 0.25f;
    public int brightness = 1;

    public static Builder builder() {
        return new Builder();
    }

    public ParticleType<?> m_6012_() {
        return FDParticles.BALL_PARTICLE.get();
    }

    public void m_7711_(FriendlyByteBuf p_123732_) {
        STREAM_CODEC.toNetwork(p_123732_, this);
    }

    public String m_5942_() {
        return "";
    }

    public static class Builder {
        private BallParticleOptions options = new BallParticleOptions();

        public Builder particleProcessor(ParticleProcessor<?> particleProcessor) {
            this.options.particleProcessor = particleProcessor;
            return this;
        }

        public Builder brightness(int brightness) {
            this.options.brightness = brightness;
            return this;
        }

        public Builder scalingOptions(int in, int stay, int out) {
            this.options.scalingOptions.stayTime = stay;
            this.options.scalingOptions.inTime = in;
            this.options.scalingOptions.outTime = out;
            return this;
        }

        public Builder in(int in) {
            this.options.scalingOptions.inTime = in;
            return this;
        }

        public Builder out(int out) {
            this.options.scalingOptions.outTime = out;
            return this;
        }

        public Builder stay(int stay) {
            this.options.scalingOptions.stayTime = stay;
            return this;
        }

        public Builder friction(float fricton) {
            this.options.friction = fricton;
            return this;
        }

        public Builder size(float size) {
            this.options.size = size;
            return this;
        }

        public Builder physics(boolean physcis) {
            this.options.hasPhysics = physcis;
            return this;
        }

        public Builder color(float r, float g, float b) {
            this.options.color.r = r;
            this.options.color.g = g;
            this.options.color.b = b;
            return this;
        }

        public Builder color(int r, int g, int b) {
            this.options.color.r = (float)r / 255.0f;
            this.options.color.g = (float)g / 255.0f;
            this.options.color.b = (float)b / 255.0f;
            return this;
        }

        public Builder color(float r, float g, float b, float a) {
            this.options.color.r = r;
            this.options.color.g = g;
            this.options.color.b = b;
            this.options.color.a = a;
            return this;
        }

        public BallParticleOptions build() {
            return this.options;
        }
    }
}

