/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdlib.systems.stream_codecs;

import com.finderfeed.fdlib.util.FDColor;
import com.mojang.datafixers.util.Function10;
import com.mojang.datafixers.util.Function11;
import com.mojang.datafixers.util.Function12;
import com.mojang.datafixers.util.Function3;
import com.mojang.datafixers.util.Function4;
import com.mojang.datafixers.util.Function5;
import com.mojang.datafixers.util.Function6;
import com.mojang.datafixers.util.Function7;
import com.mojang.datafixers.util.Function8;
import com.mojang.datafixers.util.Function9;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.IdMapper;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.joml.Vector3f;

public abstract class NetworkCodec<K> {
    public static NetworkCodec<ItemStack> ITEM = new NetworkCodec<ItemStack>(){

        @Override
        public void toNetwork(FriendlyByteBuf buf, ItemStack object) {
            buf.m_130055_(object);
        }

        @Override
        public ItemStack fromNetwork(FriendlyByteBuf buf) {
            return buf.m_130267_();
        }
    };
    public static NetworkCodec<ResourceLocation> RESOURCE_LOCATION = new NetworkCodec<ResourceLocation>(){

        @Override
        public void toNetwork(FriendlyByteBuf buf, ResourceLocation object) {
            buf.m_130085_(object);
        }

        @Override
        public ResourceLocation fromNetwork(FriendlyByteBuf buf) {
            return buf.m_130281_();
        }
    };
    public static NetworkCodec<SoundEvent> SOUND_EVENT = new NetworkCodec<SoundEvent>(){

        @Override
        public void toNetwork(FriendlyByteBuf buf, SoundEvent object) {
            ResourceLocation key = ForgeRegistries.SOUND_EVENTS.getKey((Object)object);
            buf.m_130085_(key);
        }

        @Override
        public SoundEvent fromNetwork(FriendlyByteBuf buf) {
            return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(buf.m_130281_());
        }
    };
    public static NetworkCodec<Integer> INT = new NetworkCodec<Integer>(){

        @Override
        public void toNetwork(FriendlyByteBuf buf, Integer object) {
            buf.writeInt(object.intValue());
        }

        @Override
        public Integer fromNetwork(FriendlyByteBuf buf) {
            return buf.readInt();
        }
    };
    public static NetworkCodec<Boolean> BOOL = new NetworkCodec<Boolean>(){

        @Override
        public void toNetwork(FriendlyByteBuf buf, Boolean object) {
            buf.writeByte(object != false ? 1 : 0);
        }

        @Override
        public Boolean fromNetwork(FriendlyByteBuf buf) {
            return buf.readByte() == 1;
        }
    };
    public static NetworkCodec<Float> FLOAT = new NetworkCodec<Float>(){

        @Override
        public void toNetwork(FriendlyByteBuf buf, Float object) {
            buf.writeFloat(object.floatValue());
        }

        @Override
        public Float fromNetwork(FriendlyByteBuf buf) {
            return Float.valueOf(buf.readFloat());
        }
    };
    public static NetworkCodec<Double> DOUBLE = new NetworkCodec<Double>(){

        @Override
        public void toNetwork(FriendlyByteBuf buf, Double object) {
            buf.writeDouble(object.doubleValue());
        }

        @Override
        public Double fromNetwork(FriendlyByteBuf buf) {
            return buf.readDouble();
        }
    };
    public static NetworkCodec<Direction> DIRECTION = new NetworkCodec<Direction>(){

        @Override
        public void toNetwork(FriendlyByteBuf buf, Direction object) {
            buf.writeInt(object.ordinal());
        }

        @Override
        public Direction fromNetwork(FriendlyByteBuf buf) {
            return Direction.values()[buf.readInt()];
        }
    };
    public static NetworkCodec<UUID> UUID = new NetworkCodec<UUID>(){

        @Override
        public UUID fromNetwork(FriendlyByteBuf buf) {
            return buf.m_130259_();
        }

        @Override
        public void toNetwork(FriendlyByteBuf buf, UUID uuid) {
            buf.m_130077_(uuid);
        }
    };
    public static NetworkCodec<String> STRING = new NetworkCodec<String>(){

        @Override
        public void toNetwork(FriendlyByteBuf buf, String object) {
            buf.m_130070_(object);
        }

        @Override
        public String fromNetwork(FriendlyByteBuf buf) {
            return buf.m_130277_();
        }
    };
    public static NetworkCodec<Vector3f> VECTOR3F = NetworkCodec.composite(FLOAT, v -> Float.valueOf(v.x), FLOAT, v -> Float.valueOf(v.y), FLOAT, v -> Float.valueOf(v.z), Vector3f::new);
    public static NetworkCodec<Vec3> VEC3 = new NetworkCodec<Vec3>(){

        @Override
        public Vec3 fromNetwork(FriendlyByteBuf buf) {
            return new Vec3((double)buf.readFloat(), (double)buf.readFloat(), (double)buf.readFloat());
        }

        @Override
        public void toNetwork(FriendlyByteBuf buf, Vec3 vec3) {
            buf.writeFloat((float)vec3.f_82479_);
            buf.writeFloat((float)vec3.f_82480_);
            buf.writeFloat((float)vec3.f_82481_);
        }
    };
    public static NetworkCodec<BlockPos> BLOCK_POS = new NetworkCodec<BlockPos>(){

        @Override
        public BlockPos fromNetwork(FriendlyByteBuf buf) {
            return new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        }

        @Override
        public void toNetwork(FriendlyByteBuf buf, BlockPos pos) {
            buf.writeInt(pos.m_123341_());
            buf.writeInt(pos.m_123342_());
            buf.writeInt(pos.m_123343_());
        }
    };
    public static NetworkCodec<FDColor> COLOR = new NetworkCodec<FDColor>(){

        @Override
        public FDColor fromNetwork(FriendlyByteBuf buf) {
            return FDColor.decode(buf.readInt());
        }

        @Override
        public void toNetwork(FriendlyByteBuf buf, FDColor color) {
            buf.writeInt(color.encode());
        }
    };

    public abstract void toNetwork(FriendlyByteBuf var1, K var2);

    public abstract K fromNetwork(FriendlyByteBuf var1);

    public static <C> NetworkCodec<C> instance(final C instance) {
        return new NetworkCodec<C>(){

            @Override
            public void toNetwork(FriendlyByteBuf buf, C object) {
            }

            @Override
            public C fromNetwork(FriendlyByteBuf buf) {
                return instance;
            }
        };
    }

    public static <C> NetworkCodec<C> registry(final Supplier<IForgeRegistry<C>> registry) {
        return new NetworkCodec<C>(){

            @Override
            public void toNetwork(FriendlyByteBuf buf, C object) {
                ResourceLocation key = ((IForgeRegistry)registry.get()).getKey(object);
                buf.m_130085_(key);
            }

            @Override
            public C fromNetwork(FriendlyByteBuf buf) {
                return ((IForgeRegistry)registry.get()).getValue(buf.m_130281_());
            }
        };
    }

    public static <C> NetworkCodec<List<C>> listOf(final NetworkCodec<C> singleCodec) {
        return new NetworkCodec<List<C>>(){

            @Override
            public void toNetwork(FriendlyByteBuf buf, List<C> list) {
                buf.writeInt(list.size());
                for (Object object : list) {
                    singleCodec.toNetwork(buf, object);
                }
            }

            @Override
            public List<C> fromNetwork(FriendlyByteBuf buf) {
                ArrayList list = new ArrayList();
                int size = buf.readInt();
                for (int i = 0; i < size; ++i) {
                    list.add(singleCodec.fromNetwork(buf));
                }
                return list;
            }
        };
    }

    public static <C> NetworkCodec<C> idMapper(final IdMapper<C> idMapper) {
        return new NetworkCodec<C>(){

            @Override
            public void toNetwork(FriendlyByteBuf buf, C object) {
                int id = idMapper.m_7447_(object);
                buf.writeInt(id);
            }

            @Override
            public C fromNetwork(FriendlyByteBuf buf) {
                return idMapper.m_7942_(buf.readInt());
            }
        };
    }

    public static <C, T1> NetworkCodec<C> composite(final NetworkCodec<T1> c1, final Function<C, T1> f1, final Function<T1, C> constructor) {
        return new NetworkCodec<C>(){

            @Override
            public C fromNetwork(FriendlyByteBuf p_330310_) {
                Object t1 = c1.fromNetwork(p_330310_);
                return constructor.apply(t1);
            }

            @Override
            public void toNetwork(FriendlyByteBuf buf, C p_331912_) {
                c1.toNetwork(buf, f1.apply(p_331912_));
            }
        };
    }

    public static <C, T1, T2> NetworkCodec<C> composite(final NetworkCodec<T1> c1, final Function<C, T1> f1, final NetworkCodec<T2> c2, final Function<C, T2> f2, final BiFunction<T1, T2, C> constructor) {
        return new NetworkCodec<C>(){

            @Override
            public C fromNetwork(FriendlyByteBuf p_330310_) {
                Object t1 = c1.fromNetwork(p_330310_);
                Object t2 = c2.fromNetwork(p_330310_);
                return constructor.apply(t1, t2);
            }

            @Override
            public void toNetwork(FriendlyByteBuf buf, C p_331912_) {
                c1.toNetwork(buf, f1.apply(p_331912_));
                c2.toNetwork(buf, f2.apply(p_331912_));
            }
        };
    }

    public static <C, T1, T2, T3> NetworkCodec<C> composite(final NetworkCodec<T1> c1, final Function<C, T1> f1, final NetworkCodec<T2> c2, final Function<C, T2> f2, final NetworkCodec<T3> c3, final Function<C, T3> f3, final Function3<T1, T2, T3, C> constructor) {
        return new NetworkCodec<C>(){

            @Override
            public C fromNetwork(FriendlyByteBuf p_330310_) {
                Object t1 = c1.fromNetwork(p_330310_);
                Object t2 = c2.fromNetwork(p_330310_);
                Object t3 = c3.fromNetwork(p_330310_);
                return constructor.apply(t1, t2, t3);
            }

            @Override
            public void toNetwork(FriendlyByteBuf buf, C p_331912_) {
                c1.toNetwork(buf, f1.apply(p_331912_));
                c2.toNetwork(buf, f2.apply(p_331912_));
                c3.toNetwork(buf, f3.apply(p_331912_));
            }
        };
    }

    public static <C, T1, T2, T3, T4> NetworkCodec<C> composite(final NetworkCodec<T1> c1, final Function<C, T1> f1, final NetworkCodec<T2> c2, final Function<C, T2> f2, final NetworkCodec<T3> c3, final Function<C, T3> f3, final NetworkCodec<T4> c4, final Function<C, T4> f4, final Function4<T1, T2, T3, T4, C> constructor) {
        return new NetworkCodec<C>(){

            @Override
            public C fromNetwork(FriendlyByteBuf p_330310_) {
                Object t1 = c1.fromNetwork(p_330310_);
                Object t2 = c2.fromNetwork(p_330310_);
                Object t3 = c3.fromNetwork(p_330310_);
                Object t4 = c4.fromNetwork(p_330310_);
                return constructor.apply(t1, t2, t3, t4);
            }

            @Override
            public void toNetwork(FriendlyByteBuf buf, C p_331912_) {
                c1.toNetwork(buf, f1.apply(p_331912_));
                c2.toNetwork(buf, f2.apply(p_331912_));
                c3.toNetwork(buf, f3.apply(p_331912_));
                c4.toNetwork(buf, f4.apply(p_331912_));
            }
        };
    }

    public static <C, T1, T2, T3, T4, T5> NetworkCodec<C> composite(final NetworkCodec<T1> c1, final Function<C, T1> f1, final NetworkCodec<T2> c2, final Function<C, T2> f2, final NetworkCodec<T3> c3, final Function<C, T3> f3, final NetworkCodec<T4> c4, final Function<C, T4> f4, final NetworkCodec<T5> c5, final Function<C, T5> f5, final Function5<T1, T2, T3, T4, T5, C> constructor) {
        return new NetworkCodec<C>(){

            @Override
            public C fromNetwork(FriendlyByteBuf p_330310_) {
                Object t1 = c1.fromNetwork(p_330310_);
                Object t2 = c2.fromNetwork(p_330310_);
                Object t3 = c3.fromNetwork(p_330310_);
                Object t4 = c4.fromNetwork(p_330310_);
                Object t5 = c5.fromNetwork(p_330310_);
                return constructor.apply(t1, t2, t3, t4, t5);
            }

            @Override
            public void toNetwork(FriendlyByteBuf buf, C p_331912_) {
                c1.toNetwork(buf, f1.apply(p_331912_));
                c2.toNetwork(buf, f2.apply(p_331912_));
                c3.toNetwork(buf, f3.apply(p_331912_));
                c4.toNetwork(buf, f4.apply(p_331912_));
                c5.toNetwork(buf, f5.apply(p_331912_));
            }
        };
    }

    public static <C, T1, T2, T3, T4, T5, T6> NetworkCodec<C> composite(final NetworkCodec<T1> c1, final Function<C, T1> f1, final NetworkCodec<T2> c2, final Function<C, T2> f2, final NetworkCodec<T3> c3, final Function<C, T3> f3, final NetworkCodec<T4> c4, final Function<C, T4> f4, final NetworkCodec<T5> c5, final Function<C, T5> f5, final NetworkCodec<T6> c6, final Function<C, T6> f6, final Function6<T1, T2, T3, T4, T5, T6, C> constructor) {
        return new NetworkCodec<C>(){

            @Override
            public C fromNetwork(FriendlyByteBuf p_330310_) {
                Object t1 = c1.fromNetwork(p_330310_);
                Object t2 = c2.fromNetwork(p_330310_);
                Object t3 = c3.fromNetwork(p_330310_);
                Object t4 = c4.fromNetwork(p_330310_);
                Object t5 = c5.fromNetwork(p_330310_);
                Object t6 = c6.fromNetwork(p_330310_);
                return constructor.apply(t1, t2, t3, t4, t5, t6);
            }

            @Override
            public void toNetwork(FriendlyByteBuf buf, C p_331912_) {
                c1.toNetwork(buf, f1.apply(p_331912_));
                c2.toNetwork(buf, f2.apply(p_331912_));
                c3.toNetwork(buf, f3.apply(p_331912_));
                c4.toNetwork(buf, f4.apply(p_331912_));
                c5.toNetwork(buf, f5.apply(p_331912_));
                c6.toNetwork(buf, f6.apply(p_331912_));
            }
        };
    }

    public static <C, T1, T2, T3, T4, T5, T6, T7> NetworkCodec<C> composite(final NetworkCodec<T1> c1, final Function<C, T1> f1, final NetworkCodec<T2> c2, final Function<C, T2> f2, final NetworkCodec<T3> c3, final Function<C, T3> f3, final NetworkCodec<T4> c4, final Function<C, T4> f4, final NetworkCodec<T5> c5, final Function<C, T5> f5, final NetworkCodec<T6> c6, final Function<C, T6> f6, final NetworkCodec<T7> c7, final Function<C, T7> f7, final Function7<T1, T2, T3, T4, T5, T6, T7, C> constructor) {
        return new NetworkCodec<C>(){

            @Override
            public C fromNetwork(FriendlyByteBuf p_330310_) {
                Object t1 = c1.fromNetwork(p_330310_);
                Object t2 = c2.fromNetwork(p_330310_);
                Object t3 = c3.fromNetwork(p_330310_);
                Object t4 = c4.fromNetwork(p_330310_);
                Object t5 = c5.fromNetwork(p_330310_);
                Object t6 = c6.fromNetwork(p_330310_);
                Object t7 = c7.fromNetwork(p_330310_);
                return constructor.apply(t1, t2, t3, t4, t5, t6, t7);
            }

            @Override
            public void toNetwork(FriendlyByteBuf buf, C p_331912_) {
                c1.toNetwork(buf, f1.apply(p_331912_));
                c2.toNetwork(buf, f2.apply(p_331912_));
                c3.toNetwork(buf, f3.apply(p_331912_));
                c4.toNetwork(buf, f4.apply(p_331912_));
                c5.toNetwork(buf, f5.apply(p_331912_));
                c6.toNetwork(buf, f6.apply(p_331912_));
                c7.toNetwork(buf, f7.apply(p_331912_));
            }
        };
    }

    public static <C, T1, T2, T3, T4, T5, T6, T7, T8> NetworkCodec<C> composite(final NetworkCodec<T1> c1, final Function<C, T1> f1, final NetworkCodec<T2> c2, final Function<C, T2> f2, final NetworkCodec<T3> c3, final Function<C, T3> f3, final NetworkCodec<T4> c4, final Function<C, T4> f4, final NetworkCodec<T5> c5, final Function<C, T5> f5, final NetworkCodec<T6> c6, final Function<C, T6> f6, final NetworkCodec<T7> c7, final Function<C, T7> f7, final NetworkCodec<T8> c8, final Function<C, T8> f8, final Function8<T1, T2, T3, T4, T5, T6, T7, T8, C> constructor) {
        return new NetworkCodec<C>(){

            @Override
            public C fromNetwork(FriendlyByteBuf p_330310_) {
                Object t1 = c1.fromNetwork(p_330310_);
                Object t2 = c2.fromNetwork(p_330310_);
                Object t3 = c3.fromNetwork(p_330310_);
                Object t4 = c4.fromNetwork(p_330310_);
                Object t5 = c5.fromNetwork(p_330310_);
                Object t6 = c6.fromNetwork(p_330310_);
                Object t7 = c7.fromNetwork(p_330310_);
                Object t8 = c8.fromNetwork(p_330310_);
                return constructor.apply(t1, t2, t3, t4, t5, t6, t7, t8);
            }

            @Override
            public void toNetwork(FriendlyByteBuf buf, C p_331912_) {
                c1.toNetwork(buf, f1.apply(p_331912_));
                c2.toNetwork(buf, f2.apply(p_331912_));
                c3.toNetwork(buf, f3.apply(p_331912_));
                c4.toNetwork(buf, f4.apply(p_331912_));
                c5.toNetwork(buf, f5.apply(p_331912_));
                c6.toNetwork(buf, f6.apply(p_331912_));
                c7.toNetwork(buf, f7.apply(p_331912_));
                c8.toNetwork(buf, f8.apply(p_331912_));
            }
        };
    }

    public static <C, T1, T2, T3, T4, T5, T6, T7, T8, T9> NetworkCodec<C> composite(final NetworkCodec<T1> c1, final Function<C, T1> f1, final NetworkCodec<T2> c2, final Function<C, T2> f2, final NetworkCodec<T3> c3, final Function<C, T3> f3, final NetworkCodec<T4> c4, final Function<C, T4> f4, final NetworkCodec<T5> c5, final Function<C, T5> f5, final NetworkCodec<T6> c6, final Function<C, T6> f6, final NetworkCodec<T7> c7, final Function<C, T7> f7, final NetworkCodec<T8> c8, final Function<C, T8> f8, final NetworkCodec<T9> c9, final Function<C, T9> f9, final Function9<T1, T2, T3, T4, T5, T6, T7, T8, T9, C> constructor) {
        return new NetworkCodec<C>(){

            @Override
            public C fromNetwork(FriendlyByteBuf p_330310_) {
                Object t1 = c1.fromNetwork(p_330310_);
                Object t2 = c2.fromNetwork(p_330310_);
                Object t3 = c3.fromNetwork(p_330310_);
                Object t4 = c4.fromNetwork(p_330310_);
                Object t5 = c5.fromNetwork(p_330310_);
                Object t6 = c6.fromNetwork(p_330310_);
                Object t7 = c7.fromNetwork(p_330310_);
                Object t8 = c8.fromNetwork(p_330310_);
                Object t9 = c9.fromNetwork(p_330310_);
                return constructor.apply(t1, t2, t3, t4, t5, t6, t7, t8, t9);
            }

            @Override
            public void toNetwork(FriendlyByteBuf buf, C p_331912_) {
                c1.toNetwork(buf, f1.apply(p_331912_));
                c2.toNetwork(buf, f2.apply(p_331912_));
                c3.toNetwork(buf, f3.apply(p_331912_));
                c4.toNetwork(buf, f4.apply(p_331912_));
                c5.toNetwork(buf, f5.apply(p_331912_));
                c6.toNetwork(buf, f6.apply(p_331912_));
                c7.toNetwork(buf, f7.apply(p_331912_));
                c8.toNetwork(buf, f8.apply(p_331912_));
                c9.toNetwork(buf, f9.apply(p_331912_));
            }
        };
    }

    public static <C, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10> NetworkCodec<C> composite(final NetworkCodec<T1> c1, final Function<C, T1> f1, final NetworkCodec<T2> c2, final Function<C, T2> f2, final NetworkCodec<T3> c3, final Function<C, T3> f3, final NetworkCodec<T4> c4, final Function<C, T4> f4, final NetworkCodec<T5> c5, final Function<C, T5> f5, final NetworkCodec<T6> c6, final Function<C, T6> f6, final NetworkCodec<T7> c7, final Function<C, T7> f7, final NetworkCodec<T8> c8, final Function<C, T8> f8, final NetworkCodec<T9> c9, final Function<C, T9> f9, final NetworkCodec<T10> c10, final Function<C, T10> f10, final Function10<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, C> constructor) {
        return new NetworkCodec<C>(){

            @Override
            public C fromNetwork(FriendlyByteBuf p_330310_) {
                Object t1 = c1.fromNetwork(p_330310_);
                Object t2 = c2.fromNetwork(p_330310_);
                Object t3 = c3.fromNetwork(p_330310_);
                Object t4 = c4.fromNetwork(p_330310_);
                Object t5 = c5.fromNetwork(p_330310_);
                Object t6 = c6.fromNetwork(p_330310_);
                Object t7 = c7.fromNetwork(p_330310_);
                Object t8 = c8.fromNetwork(p_330310_);
                Object t9 = c9.fromNetwork(p_330310_);
                Object t10 = c10.fromNetwork(p_330310_);
                return constructor.apply(t1, t2, t3, t4, t5, t6, t7, t8, t9, t10);
            }

            @Override
            public void toNetwork(FriendlyByteBuf buf, C p_331912_) {
                c1.toNetwork(buf, f1.apply(p_331912_));
                c2.toNetwork(buf, f2.apply(p_331912_));
                c3.toNetwork(buf, f3.apply(p_331912_));
                c4.toNetwork(buf, f4.apply(p_331912_));
                c5.toNetwork(buf, f5.apply(p_331912_));
                c6.toNetwork(buf, f6.apply(p_331912_));
                c7.toNetwork(buf, f7.apply(p_331912_));
                c8.toNetwork(buf, f8.apply(p_331912_));
                c9.toNetwork(buf, f9.apply(p_331912_));
                c10.toNetwork(buf, f10.apply(p_331912_));
            }
        };
    }

    public static <C, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11> NetworkCodec<C> composite(final NetworkCodec<T1> c1, final Function<C, T1> f1, final NetworkCodec<T2> c2, final Function<C, T2> f2, final NetworkCodec<T3> c3, final Function<C, T3> f3, final NetworkCodec<T4> c4, final Function<C, T4> f4, final NetworkCodec<T5> c5, final Function<C, T5> f5, final NetworkCodec<T6> c6, final Function<C, T6> f6, final NetworkCodec<T7> c7, final Function<C, T7> f7, final NetworkCodec<T8> c8, final Function<C, T8> f8, final NetworkCodec<T9> c9, final Function<C, T9> f9, final NetworkCodec<T10> c10, final Function<C, T10> f10, final NetworkCodec<T11> c11, final Function<C, T11> f11, final Function11<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, C> constructor) {
        return new NetworkCodec<C>(){

            @Override
            public C fromNetwork(FriendlyByteBuf p_330310_) {
                Object t1 = c1.fromNetwork(p_330310_);
                Object t2 = c2.fromNetwork(p_330310_);
                Object t3 = c3.fromNetwork(p_330310_);
                Object t4 = c4.fromNetwork(p_330310_);
                Object t5 = c5.fromNetwork(p_330310_);
                Object t6 = c6.fromNetwork(p_330310_);
                Object t7 = c7.fromNetwork(p_330310_);
                Object t8 = c8.fromNetwork(p_330310_);
                Object t9 = c9.fromNetwork(p_330310_);
                Object t10 = c10.fromNetwork(p_330310_);
                Object t11 = c11.fromNetwork(p_330310_);
                return constructor.apply(t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11);
            }

            @Override
            public void toNetwork(FriendlyByteBuf buf, C p_331912_) {
                c1.toNetwork(buf, f1.apply(p_331912_));
                c2.toNetwork(buf, f2.apply(p_331912_));
                c3.toNetwork(buf, f3.apply(p_331912_));
                c4.toNetwork(buf, f4.apply(p_331912_));
                c5.toNetwork(buf, f5.apply(p_331912_));
                c6.toNetwork(buf, f6.apply(p_331912_));
                c7.toNetwork(buf, f7.apply(p_331912_));
                c8.toNetwork(buf, f8.apply(p_331912_));
                c9.toNetwork(buf, f9.apply(p_331912_));
                c10.toNetwork(buf, f10.apply(p_331912_));
                c11.toNetwork(buf, f11.apply(p_331912_));
            }
        };
    }

    public static <C, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12> NetworkCodec<C> composite(final NetworkCodec<T1> c1, final Function<C, T1> f1, final NetworkCodec<T2> c2, final Function<C, T2> f2, final NetworkCodec<T3> c3, final Function<C, T3> f3, final NetworkCodec<T4> c4, final Function<C, T4> f4, final NetworkCodec<T5> c5, final Function<C, T5> f5, final NetworkCodec<T6> c6, final Function<C, T6> f6, final NetworkCodec<T7> c7, final Function<C, T7> f7, final NetworkCodec<T8> c8, final Function<C, T8> f8, final NetworkCodec<T9> c9, final Function<C, T9> f9, final NetworkCodec<T10> c10, final Function<C, T10> f10, final NetworkCodec<T11> c11, final Function<C, T11> f11, final NetworkCodec<T12> c12, final Function<C, T12> f12, final Function12<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, C> constructor) {
        return new NetworkCodec<C>(){

            @Override
            public C fromNetwork(FriendlyByteBuf p_330310_) {
                Object t1 = c1.fromNetwork(p_330310_);
                Object t2 = c2.fromNetwork(p_330310_);
                Object t3 = c3.fromNetwork(p_330310_);
                Object t4 = c4.fromNetwork(p_330310_);
                Object t5 = c5.fromNetwork(p_330310_);
                Object t6 = c6.fromNetwork(p_330310_);
                Object t7 = c7.fromNetwork(p_330310_);
                Object t8 = c8.fromNetwork(p_330310_);
                Object t9 = c9.fromNetwork(p_330310_);
                Object t10 = c10.fromNetwork(p_330310_);
                Object t11 = c11.fromNetwork(p_330310_);
                Object t12 = c12.fromNetwork(p_330310_);
                return constructor.apply(t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11, t12);
            }

            @Override
            public void toNetwork(FriendlyByteBuf buf, C p_331912_) {
                c1.toNetwork(buf, f1.apply(p_331912_));
                c2.toNetwork(buf, f2.apply(p_331912_));
                c3.toNetwork(buf, f3.apply(p_331912_));
                c4.toNetwork(buf, f4.apply(p_331912_));
                c5.toNetwork(buf, f5.apply(p_331912_));
                c6.toNetwork(buf, f6.apply(p_331912_));
                c7.toNetwork(buf, f7.apply(p_331912_));
                c8.toNetwork(buf, f8.apply(p_331912_));
                c9.toNetwork(buf, f9.apply(p_331912_));
                c10.toNetwork(buf, f10.apply(p_331912_));
                c11.toNetwork(buf, f11.apply(p_331912_));
                c12.toNetwork(buf, f12.apply(p_331912_));
            }
        };
    }
}

