/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdlib.systems.screen.screen_effect;

import com.finderfeed.fdlib.network.FDPacket;
import com.finderfeed.fdlib.network.RegisterFDPacket;
import com.finderfeed.fdlib.systems.FDRegistries;
import com.finderfeed.fdlib.systems.screen.screen_effect.ScreenEffect;
import com.finderfeed.fdlib.systems.screen.screen_effect.ScreenEffectData;
import com.finderfeed.fdlib.systems.screen.screen_effect.ScreenEffectOverlay;
import com.finderfeed.fdlib.systems.screen.screen_effect.ScreenEffectType;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.IForgeRegistry;

@RegisterFDPacket(value="fdlib:screen_effect")
public class SendScreenEffectPacket<D extends ScreenEffectData, T extends ScreenEffect<D>>
extends FDPacket {
    private D data;
    private ScreenEffectType<D, T> type;
    private int inTime;
    private int stayTime;
    private int outTime;

    public SendScreenEffectPacket(D data, ScreenEffectType<D, T> type, int inTime, int stayTime, int outTime) {
        this.data = data;
        this.type = type;
        this.stayTime = stayTime;
        this.outTime = outTime;
        this.inTime = inTime;
    }

    public SendScreenEffectPacket(FriendlyByteBuf buf) {
        IForgeRegistry<ScreenEffectType<?, ?>> registry = FDRegistries.SCREEN_EFFECTS.get();
        String location = buf.m_130277_();
        ScreenEffectType t = (ScreenEffectType)registry.getValue(ResourceLocation.m_135820_((String)location));
        ScreenEffectData effectData = (ScreenEffectData)t.dataCodec.fromNetwork(buf);
        this.data = effectData;
        this.type = t;
        this.inTime = buf.readInt();
        this.stayTime = buf.readInt();
        this.outTime = buf.readInt();
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        IForgeRegistry<ScreenEffectType<?, ?>> registry = FDRegistries.SCREEN_EFFECTS.get();
        ResourceLocation location = registry.getKey(this.type);
        buf.m_130070_(location.toString());
        this.type.dataCodec.toNetwork(buf, this.data);
        buf.writeInt(this.inTime);
        buf.writeInt(this.stayTime);
        buf.writeInt(this.outTime);
    }

    @Override
    public void clientAction(Supplier<NetworkEvent.Context> context) {
        Object effect = this.type.factory.create(this.data, this.inTime, this.stayTime, this.outTime);
        ScreenEffectOverlay.addScreenEffect(effect);
    }

    @Override
    public void serverAction(Supplier<NetworkEvent.Context> context) {
    }
}

