/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdlib.systems.screen.screen_effect;

import com.finderfeed.fdlib.systems.screen.screen_effect.ScreenEffect;
import com.finderfeed.fdlib.systems.screen.screen_effect.ScreenEffectInstance;
import com.mojang.blaze3d.platform.Window;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT}, modid="fdlib")
public class ScreenEffectOverlay
implements IGuiOverlay {
    private static final List<ScreenEffectInstance> screenEffects = new ArrayList<ScreenEffectInstance>();

    public void render(ForgeGui gui, GuiGraphics guiGraphics, float partialTick, int screenWidth, int screenHeight) {
        Window window = Minecraft.m_91087_().m_91268_();
        float width = window.m_85445_();
        float height = window.m_85446_();
        for (ScreenEffectInstance instance : screenEffects) {
            instance.effect.render(guiGraphics, partialTick, instance.currentTime, width, height);
        }
    }

    @SubscribeEvent
    public static void tickEvent(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (Minecraft.m_91087_().m_91104_()) {
            return;
        }
        Iterator<ScreenEffectInstance> screenEffectInstanceIterator = screenEffects.iterator();
        while (screenEffectInstanceIterator.hasNext()) {
            ScreenEffectInstance instance = screenEffectInstanceIterator.next();
            if (instance.isFinished()) {
                screenEffectInstanceIterator.remove();
                continue;
            }
            instance.tick();
        }
    }

    public static List<ScreenEffectInstance> getScreenEffects() {
        return screenEffects;
    }

    public static void addScreenEffect(ScreenEffect effect) {
        screenEffects.add(new ScreenEffectInstance(effect));
    }
}

