/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdlib.systems.particle.particle_emitter.processors;

import com.finderfeed.fdlib.FDClientHelpers;
import com.finderfeed.fdlib.systems.particle.particle_emitter.EmitterProcessor;
import com.finderfeed.fdlib.systems.particle.particle_emitter.EmitterProcessorType;
import com.finderfeed.fdlib.systems.particle.particle_emitter.FDEmitterProcessorTypes;
import com.finderfeed.fdlib.systems.particle.particle_emitter.ParticleEmitter;
import com.finderfeed.fdlib.systems.stream_codecs.NetworkCodec;
import net.minecraft.client.particle.Particle;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class BoundToEntityProcessor
implements EmitterProcessor<BoundToEntityProcessor> {
    private int id;
    private Vec3 offset;
    private Entity entity;

    public BoundToEntityProcessor(int id, Vec3 offset) {
        this.id = id;
        this.offset = offset;
    }

    @Override
    public void initEmitter(ParticleEmitter emitter) {
        Level level = FDClientHelpers.getClientLevel();
        Entity entity = level.m_6815_(this.id);
        if (entity == null) {
            emitter.removed = true;
        } else {
            this.entity = entity;
            emitter.data.position = entity.m_20182_().m_82549_(this.offset);
        }
    }

    @Override
    public void tickEmitter(ParticleEmitter emitter) {
        if (this.entity == null) {
            emitter.removed = true;
            return;
        }
        emitter.data.position = this.entity.m_20182_().m_82549_(this.offset);
        if (this.entity.m_213877_()) {
            emitter.removed = true;
        }
    }

    @Override
    public void tickParticle(Particle particle) {
    }

    @Override
    public void initParticle(Particle particle) {
    }

    @Override
    public EmitterProcessorType<BoundToEntityProcessor> type() {
        return FDEmitterProcessorTypes.BOUND_TO_ENTITY;
    }

    public static class Type
    implements EmitterProcessorType<BoundToEntityProcessor> {
        public static final NetworkCodec<BoundToEntityProcessor> STREAM_CODEC = NetworkCodec.composite(NetworkCodec.INT, v -> v.id, NetworkCodec.VEC3, v -> v.offset, (id, offset) -> {
            BoundToEntityProcessor processor = new BoundToEntityProcessor((int)id, (Vec3)offset);
            return processor;
        });

        @Override
        public NetworkCodec<BoundToEntityProcessor> codec() {
            return STREAM_CODEC;
        }

        @Override
        public ResourceLocation id() {
            return ResourceLocation.m_214293_((String)"fdlib", (String)"bound_to_entity");
        }
    }
}

