/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdlib.systems.particle;

import com.finderfeed.fdlib.systems.particle.FDParticleProcessors;
import com.finderfeed.fdlib.systems.particle.ParticleProcessor;
import com.finderfeed.fdlib.systems.particle.ParticleProcessorType;
import com.finderfeed.fdlib.systems.stream_codecs.NetworkCodec;
import com.mojang.serialization.Codec;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.particle.Particle;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public class CompositeParticleProcessor
implements ParticleProcessor<CompositeParticleProcessor> {
    private ParticleProcessor<?>[] processors;

    public CompositeParticleProcessor(ParticleProcessor<?> ... processors) {
        this.processors = processors;
    }

    @Override
    public ParticleProcessorType<CompositeParticleProcessor> type() {
        return FDParticleProcessors.COMPOSITE;
    }

    @Override
    public void processParticle(Particle particle) {
        for (ParticleProcessor<?> particleProcessor : this.processors) {
            particleProcessor.processParticle(particle);
        }
    }

    @Override
    public void init(Particle particle) {
        for (ParticleProcessor<?> particleProcessor : this.processors) {
            particleProcessor.init(particle);
        }
    }

    public static class Type
    implements ParticleProcessorType<CompositeParticleProcessor> {
        private static Codec<List<ParticleProcessor<?>>> PARTICLE_PROCESSOR_LIST = Codec.list(ParticleProcessor.CODEC).fieldOf("processors").codec();
        public static final ResourceLocation LOCATION = ResourceLocation.m_214293_((String)"fdlib", (String)"composite");
        public static Codec<CompositeParticleProcessor> CODEC = PARTICLE_PROCESSOR_LIST.xmap(particleProcessors -> {
            ParticleProcessor[] arr = particleProcessors.toArray(new ParticleProcessor[0]);
            return new CompositeParticleProcessor(arr);
        }, compositeParticleProcessor -> Arrays.asList(compositeParticleProcessor.processors));
        public static NetworkCodec<CompositeParticleProcessor> STREAM_CODEC = new NetworkCodec<CompositeParticleProcessor>(){

            @Override
            public CompositeParticleProcessor fromNetwork(FriendlyByteBuf buf) {
                int len = buf.readInt();
                ParticleProcessor[] processors = new ParticleProcessor[len];
                for (int i = 0; i < processors.length; ++i) {
                    processors[i] = ParticleProcessor.STREAM_CODEC.fromNetwork(buf);
                }
                CompositeParticleProcessor compositeParticleProcessor = new CompositeParticleProcessor(processors);
                return compositeParticleProcessor;
            }

            @Override
            public void toNetwork(FriendlyByteBuf buf, CompositeParticleProcessor processor) {
                int len = processor.processors.length;
                buf.writeInt(len);
                for (ParticleProcessor<?> particleProcessor : processor.processors) {
                    ParticleProcessor.STREAM_CODEC.toNetwork(buf, particleProcessor);
                }
            }
        };

        @Override
        public NetworkCodec<CompositeParticleProcessor> networkCodec() {
            return STREAM_CODEC;
        }

        @Override
        public Codec<CompositeParticleProcessor> codec() {
            return CODEC;
        }

        @Override
        public ResourceLocation id() {
            return LOCATION;
        }
    }
}

