/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdlib.systems.particle;

import com.finderfeed.fdlib.systems.particle.FDParticleProcessors;
import com.finderfeed.fdlib.systems.particle.ParticleProcessor;
import com.finderfeed.fdlib.systems.particle.ParticleProcessorType;
import com.finderfeed.fdlib.systems.stream_codecs.NetworkCodec;
import com.finderfeed.fdlib.util.FDCodecs;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.client.particle.Particle;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import org.joml.AxisAngle4f;
import org.joml.Quaternionf;
import org.joml.Vector3d;
import org.joml.Vector3f;

public class CircleParticleProcessor
implements ParticleProcessor<CircleParticleProcessor> {
    private Vec3 point = null;
    private boolean forward = true;
    private boolean in = true;
    private float circleCount = 1.0f;
    private Vec3 previousPoint = null;
    private Vec3 initialPoint = null;
    private Vector3f axis = null;
    private Vec3 oldSpeed = Vec3.f_82478_;

    public CircleParticleProcessor(Vec3 point, boolean forward, boolean in, float circleCount) {
        this.point = point;
        this.forward = forward;
        this.in = in;
        this.circleCount = circleCount;
    }

    @Override
    public ParticleProcessorType<CircleParticleProcessor> type() {
        return FDParticleProcessors.CIRCLE_PARTICLE_PROCESSOR;
    }

    @Override
    public void init(Particle particle) {
        this.initialPoint = new Vec3(particle.f_107212_, particle.f_107213_, particle.f_107214_);
        Vec3 b = this.initialPoint.m_82546_(this.point);
        Vec3 left = b.m_82537_(new Vec3(0.0, 1.0, 0.0));
        Vec3 axis = left.m_82537_(b);
        this.axis = new Vector3f((float)axis.f_82479_, (float)axis.f_82480_, (float)axis.f_82481_).normalize();
        if (!this.in) {
            particle.m_107264_(this.point.f_82479_, this.point.f_82480_, this.point.f_82481_);
            particle.f_107209_ = this.point.f_82479_;
            particle.f_107210_ = this.point.f_82480_;
            particle.f_107211_ = this.point.f_82481_;
            this.previousPoint = this.point;
        } else {
            this.previousPoint = this.initialPoint;
        }
    }

    @Override
    public void processParticle(Particle particle) {
        int particleLifetime = particle.f_107225_ - 2;
        if (particle.f_107224_ > particleLifetime) {
            return;
        }
        float p2 = (float)particle.f_107224_ / (float)particleLifetime;
        double len = this.initialPoint.m_82546_(this.point).m_82553_();
        double targetRad = this.in ? len * (double)(1.0f - p2) : len * (double)p2;
        float fullAngle = (float)Math.PI * 2 * this.circleCount;
        float targetAngle = fullAngle * p2;
        if (!this.forward) {
            targetAngle = -targetAngle;
        }
        Quaternionf q = new Quaternionf(new AxisAngle4f(targetAngle, this.axis.x, this.axis.y, this.axis.z));
        Vector3d p = q.transform((this.initialPoint.f_82479_ - this.point.f_82479_) / len, (this.initialPoint.f_82480_ - this.point.f_82480_) / len, (this.initialPoint.f_82481_ - this.point.f_82481_) / len, new Vector3d());
        Vec3 targetPoint = this.point.m_82520_(p.x * targetRad, p.y * targetRad, p.z * targetRad);
        Vec3 speed = targetPoint.m_82546_(this.previousPoint);
        this.previousPoint = targetPoint;
        particle.f_107215_ -= this.oldSpeed.f_82479_;
        particle.f_107216_ -= this.oldSpeed.f_82480_;
        particle.f_107217_ -= this.oldSpeed.f_82481_;
        particle.f_107215_ += speed.f_82479_;
        particle.f_107216_ += speed.f_82480_;
        particle.f_107217_ += speed.f_82481_;
        this.oldSpeed = speed;
    }

    public static class Type
    implements ParticleProcessorType<CircleParticleProcessor> {
        public static final NetworkCodec<CircleParticleProcessor> STREAM_CODEC = NetworkCodec.composite(NetworkCodec.VEC3, v -> v.point, NetworkCodec.BOOL, v -> v.forward, NetworkCodec.BOOL, v -> v.in, NetworkCodec.FLOAT, v -> Float.valueOf(v.circleCount), CircleParticleProcessor::new);
        public static final Codec<CircleParticleProcessor> CODEC = RecordCodecBuilder.create(p -> p.group((App)FDCodecs.VEC3.fieldOf("point").forGetter(v -> v.point), (App)Codec.BOOL.fieldOf("forward").forGetter(v -> v.forward), (App)Codec.BOOL.fieldOf("in").forGetter(v -> v.in), (App)Codec.FLOAT.fieldOf("circleCount").forGetter(v -> Float.valueOf(v.circleCount))).apply((Applicative)p, CircleParticleProcessor::new));

        @Override
        public NetworkCodec<CircleParticleProcessor> networkCodec() {
            return STREAM_CODEC;
        }

        @Override
        public Codec<CircleParticleProcessor> codec() {
            return CODEC;
        }

        @Override
        public ResourceLocation id() {
            return ResourceLocation.m_214293_((String)"fdlib", (String)"circle_particle_processor");
        }
    }
}

