/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdlib.systems.bedrock.animations.animation_system.model_system.attachments.instances.fdmodel;

import com.finderfeed.fdlib.systems.FDRegistries;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.model_system.attachments.BaseModelAttachmentData;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.model_system.attachments.ModelAttachment;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.model_system.attachments.instances.fdmodel.FDModelAttachmentData;
import com.finderfeed.fdlib.systems.bedrock.models.FDModel;
import com.finderfeed.fdlib.systems.bedrock.models.FDModelInfo;
import com.finderfeed.fdlib.systems.render_types.FDRenderType;
import com.finderfeed.fdlib.util.FDColor;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.UnknownNullability;

public class FDModelAttachment
implements ModelAttachment<FDModelAttachment, FDModelAttachmentData> {
    private FDModelAttachmentData data;
    private FDModel fdModel;

    protected FDModelAttachment() {
    }

    public FDModelAttachment(FDModelAttachmentData fdModelAttachmentData) {
        this.data = fdModelAttachmentData;
        this.fdModel = new FDModel(fdModelAttachmentData.getFdModelInfo());
    }

    public FDModel getFdModel() {
        return this.fdModel;
    }

    public FDColor getColor() {
        return this.data.getColor();
    }

    public FDRenderType getRenderType() {
        return this.data.getRenderType();
    }

    public ResourceLocation getTexture() {
        return this.data.getTexture();
    }

    public BaseModelAttachmentData getData() {
        return this.data.getBaseModelAttachmentData();
    }

    @Override
    public FDModelAttachmentData attachmentData() {
        return this.data;
    }

    public @UnknownNullability CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        ResourceLocation id = FDRegistries.MODELS.get().getKey((Object)this.data.getFdModelInfo());
        tag.m_128359_("modelInfo", id.toString());
        tag.m_128365_("data", (Tag)this.data.getBaseModelAttachmentData().serializeNBT());
        ResourceLocation rtid = FDRegistries.RENDER_TYPE.get().getKey((Object)this.data.getRenderType());
        tag.m_128359_("renderType", rtid.toString());
        tag.m_128359_("texture", this.data.getTexture().toString());
        FDColor fdColor = this.data.getColor();
        tag.m_128405_("color", fdColor.encode());
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        ResourceLocation location = ResourceLocation.m_135820_((String)nbt.m_128461_("modelInfo"));
        FDModelInfo info = (FDModelInfo)FDRegistries.MODELS.get().getValue(location);
        BaseModelAttachmentData baseModelAttachmentData = new BaseModelAttachmentData();
        baseModelAttachmentData.deserializeNBT(nbt.m_128469_("data"));
        ResourceLocation texture = ResourceLocation.m_135820_((String)nbt.m_128461_("texture"));
        ResourceLocation renderTypeLocation = ResourceLocation.m_135820_((String)nbt.m_128461_("renderType"));
        FDRenderType fdRenderType = (FDRenderType)FDRegistries.RENDER_TYPE.get().getValue(renderTypeLocation);
        FDColor color = FDColor.decode(nbt.m_128451_("color"));
        this.data = new FDModelAttachmentData(baseModelAttachmentData, fdRenderType, info, texture, color);
        this.fdModel = new FDModel(info);
    }
}

