/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdlib.systems.bedrock.animations.animation_system.model_system;

import com.finderfeed.fdlib.data_structures.Pair;
import com.finderfeed.fdlib.systems.FDRegistries;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.model_system.attachments.ModelAttachment;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.model_system.attachments.ModelAttachmentType;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.util.INBTSerializable;

public class BoneAttachments
implements INBTSerializable<CompoundTag> {
    private List<Pair<UUID, ModelAttachment<?, ?>>> boneAttachments = new ArrayList();

    public boolean hasAttachment(UUID attachmentUUID) {
        return this.listContainsAttachmentWithUUID(this.boneAttachments, attachmentUUID);
    }

    protected boolean removeAttachment(UUID uuid) {
        ListIterator<Pair<UUID, ModelAttachment<?, ?>>> iterator = this.boneAttachments.listIterator();
        while (iterator.hasNext()) {
            Pair<UUID, ModelAttachment<?, ?>> pair = iterator.next();
            UUID uuid2 = (UUID)pair.first;
            if (!uuid2.equals(uuid)) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    protected void attach(UUID uuid, ModelAttachment<?, ?> fdModel) {
        if (!this.hasAttachment(uuid)) {
            this.boneAttachments.add(new Pair(uuid, fdModel));
        }
    }

    private boolean listContainsAttachmentWithUUID(List<Pair<UUID, ModelAttachment<?, ?>>> list, UUID uuid) {
        for (Pair<UUID, ModelAttachment<?, ?>> entry : list) {
            if (!((UUID)entry.first).equals(uuid)) continue;
            return true;
        }
        return false;
    }

    public List<Pair<UUID, ModelAttachment<?, ?>>> getAttachments() {
        return this.boneAttachments;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        int id = 0;
        for (Pair<UUID, ModelAttachment<?, ?>> pair : this.boneAttachments) {
            CompoundTag attachment = new CompoundTag();
            attachment.m_128362_("uuid", (UUID)pair.first);
            ModelAttachment modelAttachment = (ModelAttachment)pair.second;
            ModelAttachmentType type = modelAttachment.attachmentData().type();
            ResourceLocation key = FDRegistries.MODEL_ATTACHMENT_TYPES.get().getKey(type);
            CompoundTag t = (CompoundTag)modelAttachment.serializeNBT();
            attachment.m_128365_("attachmentData", (Tag)t);
            attachment.m_128359_("attachmentType", key.toString());
            tag.m_128365_("attachment_" + id++, (Tag)attachment);
        }
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.boneAttachments = new ArrayList();
        int id = 0;
        while (tag.m_128441_("attachment_" + id)) {
            CompoundTag attachment = tag.m_128469_("attachment_" + id);
            UUID uuid = attachment.m_128342_("uuid");
            CompoundTag modelAttachmentTag = attachment.m_128469_("attachmentData");
            ResourceLocation location = ResourceLocation.m_135820_((String)attachment.m_128461_("attachmentType"));
            ModelAttachmentType type = (ModelAttachmentType)FDRegistries.MODEL_ATTACHMENT_TYPES.get().getValue(location);
            Object modelAttachment = type.createInstance();
            modelAttachment.deserializeNBT((Tag)modelAttachmentTag);
            this.boneAttachments.add(new Pair(uuid, modelAttachment));
            ++id;
        }
    }
}

