/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdlib.systems.bedrock.animations.animation_system.item;

import com.finderfeed.fdlib.systems.bedrock.models.FDModelInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.item.ItemDisplayContext;
import org.joml.Vector3f;

public class FDModelItemRendererOptions {
    protected List<Supplier<FDModelInfo>> modelInfos = new ArrayList<Supplier<FDModelInfo>>();
    protected List<RenderType> renderTypes = new ArrayList<RenderType>();
    protected Function<ItemDisplayContext, Float> rotation = t -> Float.valueOf(0.0f);
    protected Function<ItemDisplayContext, Float> scale = t -> Float.valueOf(t == ItemDisplayContext.GUI ? 0.6f : 0.35f);
    protected Function<ItemDisplayContext, Vector3f> translation = t -> new Vector3f();

    public FDModelItemRendererOptions addModel(Supplier<FDModelInfo> info, RenderType renderType) {
        this.modelInfos.add(info);
        this.renderTypes.add(renderType);
        return this;
    }

    public FDModelItemRendererOptions addRotation(Function<ItemDisplayContext, Float> yRotation) {
        this.rotation = yRotation;
        return this;
    }

    public FDModelItemRendererOptions setScale(Function<ItemDisplayContext, Float> scaling) {
        this.scale = scaling;
        return this;
    }

    public FDModelItemRendererOptions addTranslation(Function<ItemDisplayContext, Vector3f> translation) {
        this.translation = translation;
        return this;
    }

    public FDModelItemRendererOptions addRotation(float rotation) {
        this.rotation = t -> Float.valueOf(rotation);
        return this;
    }

    public FDModelItemRendererOptions setScale(float scale) {
        this.scale = t -> Float.valueOf(scale);
        return this;
    }

    public FDModelItemRendererOptions addTranslation(Vector3f translation) {
        this.translation = t -> translation;
        return this;
    }

    public static FDModelItemRendererOptions create() {
        return new FDModelItemRendererOptions();
    }
}

