/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdlib.network;

import com.finderfeed.fdlib.FDHelpers;
import com.finderfeed.fdlib.FDLib;
import com.finderfeed.fdlib.network.FDPacket;
import com.finderfeed.fdlib.network.RegisterFDPacket;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.util.thread.EffectiveSide;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;

public class FDPacketHandler {
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)FDLib.location("main"), () -> "1", "1"::equals, "1"::equals);
    private static int ID = 0;

    public static int nextID() {
        return ID++;
    }

    private static <T extends FDPacket> void registerPacket(Class<T> packetClass) throws NoSuchMethodException {
        Constructor constructor = packetClass.getConstructor(FriendlyByteBuf.class);
        INSTANCE.registerMessage(FDPacketHandler.nextID(), packetClass, FDPacket::write, buf -> {
            try {
                return (FDPacket)constructor.newInstance(buf);
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }, (msg, ctx) -> {
            ((NetworkEvent.Context)ctx.get()).enqueueWork(() -> FDPacketHandler.lambda$registerPacket$2(msg, (Supplier)ctx));
            ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
        });
    }

    public static void registerMessages() {
        List<Class<?>> packets = FDHelpers.getAnnotatedClasses(RegisterFDPacket.class);
        Iterator<Class<?>> iterator = packets.iterator();
        while (iterator.hasNext()) {
            Class<?> clazz;
            Class<?> castedPacket = clazz = iterator.next();
            try {
                FDPacketHandler.registerPacket(castedPacket);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static /* synthetic */ void lambda$registerPacket$2(FDPacket msg, Supplier ctx) {
        if (EffectiveSide.get().isClient()) {
            msg.clientAction(ctx);
        } else {
            msg.serverAction(ctx);
        }
    }
}

