/*
 * Decompiled with CFR 0.152.
 */
package com.armilp.ezvcsurvival.sculk;

import com.armilp.ezvcsurvival.EZVCSurvival;
import com.armilp.ezvcsurvival.sculk.ModGameEvent;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SculkSensorBlockEntity;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.vibrations.VibrationSystem;
import net.minecraft.world.phys.Vec3;

public class SculkVibrationHelper {
    public static void generateVibration(ServerPlayer player, int distance, double audioLevel) {
        if (player == null || player.m_9236_() == null) {
            return;
        }
        player.m_20194_().execute(() -> {
            try {
                SculkVibrationHelper.generateVibrationSync(player, distance, audioLevel);
            }
            catch (Exception e) {
                EZVCSurvival.LOGGER.error("Error generating sculk vibration", (Throwable)e);
            }
        });
    }

    private static void generateVibrationSync(ServerPlayer player, int distance, double audioLevel) {
        Level level = player.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        if (ModGameEvent.VOICE_TALK == null) {
            return;
        }
        BlockPos playerPos = player.m_20183_();
        Vec3 sourcePos = player.m_20182_().m_82520_(0.0, 0.5, 0.0);
        GameEvent event = ModGameEvent.VOICE_TALK;
        List<SculkSensorBlockEntity> sensors = SculkVibrationHelper.findNearbySculkSensors(level2, playerPos, distance);
        for (SculkSensorBlockEntity sensor : sensors) {
            try {
                VibrationSystem.Listener listener = sensor.m_280052_();
                if (listener == null) continue;
                listener.m_280275_(level2, event, new GameEvent.Context((Entity)player, null), sourcePos);
            }
            catch (Exception e) {
                EZVCSurvival.LOGGER.error("Failed to activate sensor", (Throwable)e);
            }
        }
    }

    private static List<SculkSensorBlockEntity> findNearbySculkSensors(ServerLevel level, BlockPos center, int distance) {
        ArrayList<SculkSensorBlockEntity> sensors = new ArrayList<SculkSensorBlockEntity>();
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)center.m_7918_(-distance, -distance, -distance), (BlockPos)center.m_7918_(distance, distance, distance))) {
            BlockEntity be = level.m_7702_(pos.m_7949_());
            if (!(be instanceof SculkSensorBlockEntity)) continue;
            SculkSensorBlockEntity sensor = (SculkSensorBlockEntity)be;
            sensors.add(sensor);
        }
        return sensors;
    }
}

