/*
 * Decompiled with CFR 0.152.
 */
package com.armilp.ezvcsurvival.network;

import com.armilp.ezvcsurvival.config.GeneralSoundsConfig;
import com.armilp.ezvcsurvival.events.SoundEventTracker;
import com.armilp.ezvcsurvival.goals.ReactToGeneralSoundGoal;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;

public class GeneralSoundPacket {
    private final ResourceLocation sound;
    private final double x;
    private final double y;
    private final double z;
    private final double speedMultiplier;
    private final double rangeMultiplier;

    public GeneralSoundPacket(ResourceLocation sound, double x, double y, double z, double speedMultiplier, double rangeMultiplier) {
        this.sound = sound;
        this.x = x;
        this.y = y;
        this.z = z;
        this.speedMultiplier = speedMultiplier;
        this.rangeMultiplier = rangeMultiplier;
    }

    public static void encode(GeneralSoundPacket packet, FriendlyByteBuf buf) {
        buf.m_130085_(packet.sound);
        buf.writeDouble(packet.x);
        buf.writeDouble(packet.y);
        buf.writeDouble(packet.z);
        buf.writeDouble(packet.speedMultiplier);
        buf.writeDouble(packet.rangeMultiplier);
    }

    public static GeneralSoundPacket decode(FriendlyByteBuf buf) {
        ResourceLocation sound = buf.m_130281_();
        double x = buf.readDouble();
        double y = buf.readDouble();
        double z = buf.readDouble();
        double speedMultiplier = buf.readDouble();
        double rangeMultiplier = buf.readDouble();
        return new GeneralSoundPacket(sound, x, y, z, speedMultiplier, rangeMultiplier);
    }

    public static void handle(GeneralSoundPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            GeneralSoundsConfig.SoundEntry cfg;
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                return;
            }
            ServerLevel level = player.m_284548_();
            Vec3 soundPos = new Vec3(packet.x, packet.y, packet.z);
            if (!(Double.isFinite(soundPos.f_82479_) && Double.isFinite(soundPos.f_82480_) && Double.isFinite(soundPos.f_82481_))) {
                return;
            }
            SoundEventTracker.setLastPlayedPosition(packet.sound, soundPos.f_82479_, soundPos.f_82480_, soundPos.f_82481_, packet.speedMultiplier, packet.rangeMultiplier);
            Map<String, GeneralSoundsConfig.SoundEntry> soundMap = GeneralSoundsConfig.getSounds();
            if (soundMap != null && (cfg = soundMap.get(packet.sound.toString())) != null && cfg.is_priority) {
                ReactToGeneralSoundGoal.setPrioritySound(soundPos);
            }
            SoundEventTracker.notifyNearbyMobs(level, packet.sound, soundPos.f_82479_, soundPos.f_82480_, soundPos.f_82481_, packet.speedMultiplier, packet.rangeMultiplier);
        });
        ctx.get().setPacketHandled(true);
    }
}

