/*
 * Decompiled with CFR 0.152.
 */
package com.armilp.ezvcsurvival.mixins;

import com.armilp.ezvcsurvival.config.EntityVoiceConfig;
import com.armilp.ezvcsurvival.config.GeneralSoundsConfig;
import com.armilp.ezvcsurvival.config.GunfireConfig;
import com.armilp.ezvcsurvival.config.SoundConfig;
import com.armilp.ezvcsurvival.config.VoiceConfig;
import com.armilp.ezvcsurvival.data.SoundGroupData;
import com.armilp.ezvcsurvival.goals.FollowVoiceGoal;
import com.armilp.ezvcsurvival.goals.ReactToGeneralSoundGoal;
import com.armilp.ezvcsurvival.goals.ReactToGunfireGoal;
import com.armilp.ezvcsurvival.goals.RunawayVoiceGoal;
import com.armilp.ezvcsurvival.util.IGoalRefresher;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.registries.ForgeRegistries;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Mob.class}, priority=1100)
public abstract class MobEntityMixin
implements IGoalRefresher {
    @Unique
    private boolean ezvcsurvival$goalsInjected = false;
    @Unique
    private String ezvcsurvival$cachedMobId = null;
    @Unique
    private Goal ezvcsurvival$followGoal = null;
    @Unique
    private Goal ezvcsurvival$runawayGoal = null;
    @Unique
    private Goal ezvcsurvival$generalSoundGoal = null;
    @Unique
    private Goal ezvcsurvival$gunfireGoal = null;

    @Inject(method={"registerGoals"}, at={@At(value="TAIL")})
    private void ezvcsurvival$injectGoalsAfterRegister(CallbackInfo ci) {
        this.ezvcsurvival$tryInjectGoals();
    }

    @Inject(method={"finalizeSpawn"}, at={@At(value="RETURN")})
    private void ezvcsurvival$injectGoalsOnSpawn(ServerLevelAccessor p_21434_, DifficultyInstance p_21435_, MobSpawnType p_21436_, @Nullable SpawnGroupData p_21437_, @Nullable CompoundTag p_21438_, CallbackInfoReturnable<SpawnGroupData> cir) {
        this.ezvcsurvival$tryInjectGoals();
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="RETURN")})
    private void ezvcsurvival$injectGoalsOnLoad(CompoundTag tag, CallbackInfo ci) {
        Mob mob = (Mob)this;
        if (!mob.m_9236_().f_46443_) {
            this.ezvcsurvival$goalsInjected = false;
            this.ezvcsurvival$tryInjectGoals();
        }
    }

    @Unique
    private void ezvcsurvival$tryInjectGoals() {
        Mob mob = (Mob)this;
        if (mob.m_9236_().f_46443_ || this.ezvcsurvival$goalsInjected) {
            return;
        }
        if (this.ezvcsurvival$cachedMobId == null) {
            ResourceLocation mobId = ForgeRegistries.ENTITY_TYPES.getKey((Object)mob.m_6095_());
            if (mobId == null) {
                this.ezvcsurvival$goalsInjected = true;
                return;
            }
            this.ezvcsurvival$cachedMobId = mobId.toString();
        }
        try {
            this.ezvcsurvival$injectAllGoals(mob);
        }
        catch (Exception e) {
            if (((Boolean)VoiceConfig.DEBUG.get()).booleanValue()) {
                System.err.println("[EZVCSurvival] Error injecting goals for " + this.ezvcsurvival$cachedMobId + ": " + e.getMessage());
                e.printStackTrace();
            }
            this.ezvcsurvival$goalsInjected = true;
        }
    }

    @Unique
    private void ezvcsurvival$injectAllGoals(Mob mob) {
        if (this.ezvcsurvival$goalsInjected) {
            return;
        }
        boolean isAnimal = mob instanceof Animal;
        int goalsAdded = 0;
        if (EntityVoiceConfig.isEnabled()) {
            if (!isAnimal) {
                if (this.ezvcsurvival$injectFollowVoiceGoal(mob)) {
                    ++goalsAdded;
                }
            } else if (this.ezvcsurvival$injectRunawayVoiceGoal((Animal)mob)) {
                ++goalsAdded;
            }
        }
        if (GeneralSoundsConfig.isEnabled() && this.ezvcsurvival$injectGeneralSoundGoal(mob)) {
            ++goalsAdded;
        }
        if (GunfireConfig.isEnabled() && this.ezvcsurvival$injectGunfireGoal(mob)) {
            ++goalsAdded;
        }
        if (((Boolean)VoiceConfig.DEBUG.get()).booleanValue() && goalsAdded > 0) {
            System.out.println("[DEBUG] Injected " + goalsAdded + " goals for " + this.ezvcsurvival$cachedMobId);
        }
        this.ezvcsurvival$goalsInjected = true;
    }

    @Unique
    private boolean ezvcsurvival$injectFollowVoiceGoal(Mob mob) {
        EntityVoiceConfig.EntityConfig cfg = EntityVoiceConfig.getMonster(this.ezvcsurvival$cachedMobId);
        if (cfg == null || !cfg.enabled || cfg.speed <= 0.0 || cfg.range <= 0.0) {
            return false;
        }
        this.ezvcsurvival$followGoal = new FollowVoiceGoal(mob, cfg.speed, (int)cfg.range, cfg.threshold, 10000L);
        mob.f_21345_.m_25352_(0, this.ezvcsurvival$followGoal);
        if (((Boolean)VoiceConfig.DEBUG.get()).booleanValue()) {
            System.out.println("[DEBUG] Added FollowVoiceGoal to " + this.ezvcsurvival$cachedMobId + " (speed: " + cfg.speed + ", range: " + cfg.range + ", threshold: " + cfg.threshold + ")");
        }
        return true;
    }

    @Unique
    private boolean ezvcsurvival$injectRunawayVoiceGoal(Animal animal) {
        EntityVoiceConfig.EntityConfig cfg = EntityVoiceConfig.getAnimal(this.ezvcsurvival$cachedMobId);
        if (cfg == null || !cfg.enabled || cfg.speed <= 0.0 || cfg.range <= 0.0) {
            return false;
        }
        this.ezvcsurvival$runawayGoal = new RunawayVoiceGoal(animal, cfg.speed, (int)cfg.range, cfg.threshold);
        animal.f_21345_.m_25352_(4, this.ezvcsurvival$runawayGoal);
        return true;
    }

    @Unique
    private boolean ezvcsurvival$injectGeneralSoundGoal(Mob mob) {
        GeneralSoundsConfig.Reaction reaction = GeneralSoundsConfig.getMobReactions().get(this.ezvcsurvival$cachedMobId);
        if (reaction == null || !reaction.enabled || reaction.speed <= 0.0 || reaction.range <= 0.0) {
            return false;
        }
        List<SoundGroupData> soundGroups = SoundConfig.getEnabledSoundGroups();
        if (soundGroups.isEmpty()) {
            return false;
        }
        this.ezvcsurvival$generalSoundGoal = new ReactToGeneralSoundGoal(mob, reaction.speed, (int)reaction.range, soundGroups);
        mob.f_21345_.m_25352_(0, this.ezvcsurvival$generalSoundGoal);
        return true;
    }

    @Unique
    private boolean ezvcsurvival$injectGunfireGoal(Mob mob) {
        GunfireConfig.Reaction reaction = GunfireConfig.getMobReactions().get(this.ezvcsurvival$cachedMobId);
        if (reaction == null || !reaction.enabled || reaction.speed <= 0.0 || reaction.range <= 0.0) {
            return false;
        }
        this.ezvcsurvival$gunfireGoal = new ReactToGunfireGoal(mob, reaction.speed, (int)reaction.range);
        mob.f_21345_.m_25352_(0, this.ezvcsurvival$gunfireGoal);
        return true;
    }

    @Unique
    private void ezvcsurvival$removeGoal(Mob mob, Goal goal) {
        if (goal != null) {
            mob.f_21345_.m_25363_(goal);
        }
    }

    @Unique
    private void ezvcsurvival$cleanupOldGoals(Mob mob) {
        this.ezvcsurvival$removeGoal(mob, this.ezvcsurvival$followGoal);
        this.ezvcsurvival$removeGoal(mob, this.ezvcsurvival$runawayGoal);
        this.ezvcsurvival$removeGoal(mob, this.ezvcsurvival$generalSoundGoal);
        this.ezvcsurvival$removeGoal(mob, this.ezvcsurvival$gunfireGoal);
        this.ezvcsurvival$followGoal = null;
        this.ezvcsurvival$runawayGoal = null;
        this.ezvcsurvival$generalSoundGoal = null;
        this.ezvcsurvival$gunfireGoal = null;
    }

    @Override
    public void ezvcsurvival$RefreshGoals() {
        block3: {
            Mob mob = (Mob)this;
            if (mob.m_9236_().f_46443_) {
                return;
            }
            try {
                this.ezvcsurvival$cleanupOldGoals(mob);
                this.ezvcsurvival$goalsInjected = false;
                this.ezvcsurvival$injectAllGoals(mob);
            }
            catch (Exception e) {
                if (!((Boolean)VoiceConfig.DEBUG.get()).booleanValue()) break block3;
                System.err.println("[EZVCSurvival] Error refreshing goals: " + e.getMessage());
                e.printStackTrace();
            }
        }
    }
}

