/*
 * Decompiled with CFR 0.152.
 */
package com.armilp.ezvcsurvival.goals;

import com.armilp.ezvcsurvival.voicechat.Plugin;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;

public class RunawayVoiceGoal
extends Goal {
    private final Animal mob;
    private final double speedModifier;
    private final double voiceDetectionRange;
    private final double threshold;
    private BlockPos targetSoundPosition;
    private int ambientSoundCount;
    private int distanceCovered = 0;

    public RunawayVoiceGoal(Animal mob, double speedModifier, double detectionRange, double threshold) {
        this.mob = mob;
        this.speedModifier = speedModifier;
        this.voiceDetectionRange = detectionRange;
        this.threshold = threshold;
        this.ambientSoundCount = 0;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.TARGET));
    }

    public boolean m_8036_() {
        this.targetSoundPosition = Plugin.getLastSoundLocation(this.mob.m_20183_(), this.voiceDetectionRange, this.threshold);
        return this.targetSoundPosition != null;
    }

    public boolean m_8045_() {
        return this.targetSoundPosition != null && !this.mob.m_21573_().m_26571_();
    }

    public void m_8056_() {
        if (this.targetSoundPosition != null) {
            Vec3 groundedDanger = this.grounded(Vec3.m_82512_((Vec3i)this.targetSoundPosition));
            this.fleeFrom(groundedDanger);
        }
    }

    public void m_8037_() {
        if (this.targetSoundPosition != null) {
            this.handleSoundThreat();
        }
    }

    public void m_8041_() {
        this.targetSoundPosition = null;
        this.ambientSoundCount = 0;
        this.mob.m_21573_().m_26573_();
    }

    private void handleSoundThreat() {
        ++this.distanceCovered;
        BlockPos groundedPos = this.mob.m_9236_().m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, this.targetSoundPosition);
        double gx = (double)groundedPos.m_123341_() + 0.5;
        double gz = (double)groundedPos.m_123343_() + 0.5;
        if (this.distanceCovered > 10 && this.distanceCovered % 20 == 0) {
            this.mob.m_21573_().m_26573_();
            this.mob.m_21563_().m_24950_(gx, (double)groundedPos.m_123342_(), gz, 30.0f, 30.0f);
        }
        double dx = this.mob.m_20185_() - gx;
        double dz = this.mob.m_20189_() - gz;
        double distanceSq2D = dx * dx + dz * dz;
        if (this.targetSoundPosition == null || distanceSq2D > this.threshold * this.threshold) {
            this.targetSoundPosition = Plugin.getLastSoundLocation(this.mob.m_20183_(), this.voiceDetectionRange, this.threshold);
        } else {
            this.fleeFrom(new Vec3(gx, (double)groundedPos.m_123342_(), gz));
        }
    }

    private void fleeFrom(Vec3 dangerPosition) {
        Vec3 fleeDirection = this.mob.m_20182_().m_82546_(dangerPosition).m_82541_().m_82490_(20.0);
        double randomOffsetX = (this.mob.m_217043_().m_188500_() - 0.5) * 5.0;
        double randomOffsetZ = (this.mob.m_217043_().m_188500_() - 0.5) * 5.0;
        Vec3 fleeTarget = this.mob.m_20182_().m_82549_(fleeDirection).m_82520_(randomOffsetX, 0.0, randomOffsetZ);
        Vec3 groundedTarget = this.grounded(fleeTarget);
        if (this.isDangerousBlock(BlockPos.m_274446_((Position)groundedTarget))) {
            fleeDirection = fleeDirection.m_82520_(this.mob.m_217043_().m_188500_() * 5.0, 0.0, this.mob.m_217043_().m_188500_() * 5.0);
            fleeTarget = this.mob.m_20182_().m_82549_(fleeDirection);
            groundedTarget = this.grounded(fleeTarget);
        }
        this.mob.m_21573_().m_26519_(groundedTarget.f_82479_, groundedTarget.f_82480_, groundedTarget.f_82481_, this.speedModifier);
        if (this.ambientSoundCount < 2 && this.mob.m_217043_().m_188500_() < 0.5) {
            this.mob.m_8032_();
            ++this.ambientSoundCount;
        }
    }

    private Vec3 grounded(Vec3 desiredXZ) {
        BlockPos base = BlockPos.m_274561_((double)desiredXZ.f_82479_, (double)0.0, (double)desiredXZ.f_82481_);
        BlockPos top = this.mob.m_9236_().m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, base);
        return new Vec3((double)top.m_123341_() + 0.5, (double)top.m_123342_(), (double)top.m_123343_() + 0.5);
    }

    private boolean isDangerousBlock(BlockPos pos) {
        ServerLevel level = (ServerLevel)this.mob.m_9236_();
        BlockState blockState = level.m_8055_(pos);
        return !blockState.m_60819_().m_76178_() || !blockState.m_60804_((BlockGetter)level, pos);
    }
}

