/*
 * Decompiled with CFR 0.152.
 */
package com.armilp.ezvcsurvival.goals;

import com.armilp.ezvcsurvival.config.GeneralSoundsConfig;
import com.armilp.ezvcsurvival.config.SoundConfig;
import com.armilp.ezvcsurvival.data.SoundGroupData;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;

public class ReactToGeneralSoundGoal
extends Goal {
    private static final long PRIORITY_SOUND_DURATION_MS = 3500L;
    private static final int NAVIGATION_UPDATE_INTERVAL = 15;
    private static final int LOOK_UPDATE_INTERVAL = 30;
    private static final long SOUND_REACTION_TIMEOUT = 4000L;
    public static Vec3 lastPrioritySoundPos = null;
    public static long lastPrioritySoundTimestamp = 0L;
    private final Mob mob;
    private final double speed;
    private final double range;
    private final List<SoundGroupData> soundGroups;
    private final String entityId;
    private final boolean isMonster;
    private Vec3 targetSoundPos = null;
    private double targetSpeedMultiplier = 1.0;
    private double targetRangeMultiplier = 1.0;
    private long targetSetTime = 0L;
    private int tickCounter = 0;

    public ReactToGeneralSoundGoal(Mob mob, double speed, double range, List<SoundGroupData> soundGroups) {
        this.mob = mob;
        this.speed = speed;
        this.range = range;
        this.soundGroups = soundGroups;
        this.entityId = Objects.requireNonNull(ForgeRegistries.ENTITY_TYPES.getKey((Object)mob.m_6095_())).toString();
        this.isMonster = mob instanceof Monster;
    }

    public void onSoundPlayed(ResourceLocation soundLoc, Vec3 soundPos, double speedMult, double rangeMult) {
        double distSq;
        if (this.mob.m_5448_() != null) {
            return;
        }
        String soundId = soundLoc.toString();
        if (!GeneralSoundsConfig.canEntityReactToSound(this.entityId, soundId)) {
            return;
        }
        boolean isPriority = false;
        int size = this.soundGroups.size();
        for (int i = 0; i < size; ++i) {
            SoundGroupData group = this.soundGroups.get(i);
            if (!group.groupName().startsWith("auto_priority_") || !group.sounds().contains(soundId)) continue;
            isPriority = true;
            speedMult = group.speedMultiplier();
            rangeMult = group.rangeMultiplier();
            break;
        }
        if (!isPriority) {
            boolean found = false;
            int size2 = this.soundGroups.size();
            for (int i = 0; i < size2; ++i) {
                SoundGroupData group = this.soundGroups.get(i);
                if (!group.sounds().contains(soundId)) continue;
                speedMult = group.speedMultiplier();
                rangeMult = group.rangeMultiplier();
                found = true;
                break;
            }
            if (!found) {
                return;
            }
        }
        Vec3 mobPos = this.mob.m_20182_();
        double effectiveRange = this.range * rangeMult;
        if (this.mob.m_9236_().m_46471_() || this.mob.m_9236_().m_46470_()) {
            effectiveRange *= ((Double)SoundConfig.THUNDER_RANGE_MULTIPLIER.get()).doubleValue();
        }
        if ((distSq = mobPos.m_82557_(soundPos)) > effectiveRange * effectiveRange) {
            return;
        }
        this.targetSoundPos = soundPos;
        this.targetSpeedMultiplier = speedMult;
        this.targetRangeMultiplier = rangeMult;
        this.targetSetTime = System.currentTimeMillis();
        if (isPriority && lastPrioritySoundPos == null) {
            ReactToGeneralSoundGoal.setPrioritySound(soundPos);
        }
    }

    public boolean m_8036_() {
        if (this.mob.m_5448_() != null) {
            return false;
        }
        long now = System.currentTimeMillis();
        if (lastPrioritySoundPos != null && now - lastPrioritySoundTimestamp > 3500L) {
            lastPrioritySoundPos = null;
        }
        if (lastPrioritySoundPos != null) {
            Vec3 mobPos = this.mob.m_20182_();
            double effectiveRange = this.range * 1.5;
            if (this.mob.m_9236_().m_46471_() || this.mob.m_9236_().m_46470_()) {
                effectiveRange *= ((Double)SoundConfig.THUNDER_RANGE_MULTIPLIER.get()).doubleValue();
            }
            if (mobPos.m_82557_(lastPrioritySoundPos) <= effectiveRange * effectiveRange) {
                this.targetSoundPos = lastPrioritySoundPos;
                this.targetSpeedMultiplier = 1.5;
                this.targetRangeMultiplier = 1.5;
                return true;
            }
        }
        return this.targetSoundPos != null && now - this.targetSetTime < 4000L;
    }

    public boolean m_8045_() {
        if (this.mob.m_5448_() != null) {
            return false;
        }
        long now = System.currentTimeMillis();
        if (this.targetSoundPos == null) {
            return false;
        }
        if (lastPrioritySoundPos != null && now - lastPrioritySoundTimestamp <= 3500L) {
            return true;
        }
        if (now - this.targetSetTime > 4000L) {
            return false;
        }
        Vec3 mobPos = this.mob.m_20182_();
        double effectiveRange = this.range * this.targetRangeMultiplier;
        if (this.mob.m_9236_().m_46471_() || this.mob.m_9236_().m_46470_()) {
            effectiveRange *= ((Double)SoundConfig.THUNDER_RANGE_MULTIPLIER.get()).doubleValue();
        }
        return mobPos.m_82557_(this.targetSoundPos) <= effectiveRange * effectiveRange;
    }

    public void m_8056_() {
        this.tickCounter = 0;
        if (this.targetSoundPos != null) {
            this.updateNavigation();
        }
    }

    public void m_8037_() {
        if (this.targetSoundPos == null) {
            return;
        }
        ++this.tickCounter;
        if (this.tickCounter % 15 != 0) {
            return;
        }
        this.updateNavigation();
        if (this.isMonster && this.targetSoundPos != null && this.tickCounter % 30 == 0) {
            this.mob.m_21563_().m_24950_(this.targetSoundPos.f_82479_, this.targetSoundPos.f_82480_, this.targetSoundPos.f_82481_, 30.0f, 30.0f);
        }
    }

    public void m_8041_() {
        this.targetSoundPos = null;
        this.tickCounter = 0;
    }

    private void updateNavigation() {
        double distance;
        if (this.targetSoundPos == null || this.mob.m_5448_() != null) {
            return;
        }
        long now = System.currentTimeMillis();
        if (lastPrioritySoundPos != null && now - lastPrioritySoundTimestamp > 3500L) {
            lastPrioritySoundPos = null;
        }
        Vec3 currentPos = this.mob.m_20182_();
        boolean isPriority = lastPrioritySoundPos != null && this.targetSoundPos.equals((Object)lastPrioritySoundPos);
        double effectiveRange = this.range * this.targetRangeMultiplier;
        double effectiveSpeed = this.speed * this.targetSpeedMultiplier;
        if (isPriority) {
            effectiveRange *= 1.5;
            effectiveSpeed *= 1.3;
        }
        if (this.mob.m_9236_().m_46471_() || this.mob.m_9236_().m_46470_()) {
            effectiveRange *= ((Double)SoundConfig.THUNDER_RANGE_MULTIPLIER.get()).doubleValue();
        }
        if ((distance = currentPos.m_82554_(this.targetSoundPos)) > effectiveRange) {
            return;
        }
        if (isPriority && distance < 2.0) {
            lastPrioritySoundPos = null;
            this.targetSoundPos = null;
            return;
        }
        if (distance > 50.0) {
            effectiveSpeed *= 0.8;
        }
        Vec3 target = this.isMonster ? this.grounded(this.targetSoundPos) : this.grounded(currentPos.m_82549_(currentPos.m_82546_(this.targetSoundPos).m_82541_().m_82490_(effectiveRange)));
        this.mob.m_21573_().m_26519_(target.f_82479_, target.f_82480_, target.f_82481_, effectiveSpeed);
    }

    private Vec3 grounded(Vec3 desiredXZ) {
        BlockPos base = BlockPos.m_274561_((double)desiredXZ.f_82479_, (double)0.0, (double)desiredXZ.f_82481_);
        BlockPos top = this.mob.m_9236_().m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, base);
        return new Vec3((double)top.m_123341_() + 0.5, (double)top.m_123342_(), (double)top.m_123343_() + 0.5);
    }

    public static void setPrioritySound(Vec3 position) {
        lastPrioritySoundPos = position;
        lastPrioritySoundTimestamp = System.currentTimeMillis();
    }
}

