/*
 * Decompiled with CFR 0.152.
 */
package com.armilp.ezvcsurvival.goals;

import com.armilp.ezvcsurvival.voicechat.Plugin;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.levelgen.Heightmap;

public class FollowVoiceGoal
extends Goal {
    private final Mob mob;
    private final double speedModifier;
    private final int voiceDetectionRange;
    private Player targetPlayer;
    private final double threshold;
    private BlockPos targetSoundPosition;
    private long timePlayerInRange;
    private final long maxFollowTime;

    public FollowVoiceGoal(Mob mob, double speedModifier, int detectionRange, double threshold, long maxFollowTime) {
        this.mob = mob;
        this.speedModifier = speedModifier;
        this.voiceDetectionRange = detectionRange;
        this.threshold = threshold;
        this.maxFollowTime = maxFollowTime;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.TARGET));
    }

    public boolean m_8036_() {
        if (this.mob.m_5448_() != null) {
            return false;
        }
        this.targetPlayer = this.getNearestPlayerInRange();
        this.targetSoundPosition = Plugin.getLastSoundLocation(this.mob.m_20183_(), this.voiceDetectionRange, this.threshold);
        return this.targetPlayer != null || this.targetSoundPosition != null;
    }

    public void m_8056_() {
        if (this.targetPlayer != null) {
            this.timePlayerInRange = System.currentTimeMillis();
        } else if (this.targetSoundPosition != null) {
            this.moveToSoundPosition();
        }
    }

    public boolean m_8045_() {
        if (this.mob.m_5448_() != null) {
            return false;
        }
        return this.targetPlayer != null || this.targetSoundPosition != null && !this.mob.m_21573_().m_26571_();
    }

    public void m_8037_() {
        if (this.targetPlayer != null) {
            this.targetSoundPosition = null;
            this.handlePlayerInteraction();
        } else if (this.targetSoundPosition != null) {
            this.handleSoundInteraction();
        }
    }

    public void m_8041_() {
        this.targetSoundPosition = null;
        this.targetPlayer = null;
        this.mob.m_21573_().m_26573_();
    }

    private void handlePlayerInteraction() {
        if (this.targetPlayer.m_7500_() || this.targetPlayer.m_5833_()) {
            this.targetPlayer = null;
            this.mob.m_21573_().m_26573_();
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.timePlayerInRange > this.maxFollowTime) {
            this.targetPlayer = null;
            this.mob.m_21573_().m_26573_();
            return;
        }
        this.mob.m_21573_().m_26517_(this.speedModifier);
        if (this.mob.m_5448_() == null) {
            this.mob.m_6710_((LivingEntity)this.targetPlayer);
        }
    }

    private void handleSoundInteraction() {
        double arrivalThresholdSq;
        double dz;
        BlockPos groundedPos = this.mob.m_9236_().m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, this.targetSoundPosition);
        double dx = this.mob.m_20185_() - ((double)groundedPos.m_123341_() + 0.5);
        double distanceSq = dx * dx + (dz = this.mob.m_20189_() - ((double)groundedPos.m_123343_() + 0.5)) * dz;
        if (distanceSq <= (arrivalThresholdSq = this.threshold * this.threshold)) {
            this.targetSoundPosition = Plugin.getLastSoundLocation(this.mob.m_20183_(), this.voiceDetectionRange, this.threshold);
            if (this.targetSoundPosition != null) {
                this.moveToSoundPosition();
            } else {
                this.mob.m_21573_().m_26573_();
            }
            return;
        }
        if (distanceSq > (double)(this.voiceDetectionRange * this.voiceDetectionRange) / 2.0) {
            BlockPos newSoundPosition = Plugin.getLastSoundLocation(this.mob.m_20183_(), this.voiceDetectionRange, this.threshold);
            if (newSoundPosition == null) {
                this.targetSoundPosition = null;
                this.mob.m_21573_().m_26573_();
                return;
            }
            this.targetSoundPosition = newSoundPosition;
            this.moveToSoundPosition();
        }
        this.mob.m_21573_().m_26517_(this.speedModifier);
    }

    private Player getNearestPlayerInRange() {
        return this.mob.m_9236_().m_45930_((Entity)this.mob, 5.0);
    }

    private void moveToSoundPosition() {
        if (this.targetSoundPosition != null) {
            BlockPos ground = this.mob.m_9236_().m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, this.targetSoundPosition);
            this.mob.m_21573_().m_26519_((double)ground.m_123341_() + 0.5, (double)ground.m_123342_(), (double)ground.m_123343_() + 0.5, this.speedModifier);
        }
    }
}

