/*
 * Decompiled with CFR 0.152.
 */
package com.armilp.ezvcsurvival.events;

import com.armilp.ezvcsurvival.data.TimedSoundData;
import com.armilp.ezvcsurvival.goals.ReactToGeneralSoundGoal;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.phys.Vec3;

public class SoundEventTracker {
    private static final long SOUND_EXPIRATION_MS = 4000L;
    private static final Map<ResourceLocation, TimedSoundData> lastPlayedPositions = new ConcurrentHashMap<ResourceLocation, TimedSoundData>();

    public static void setLastPlayedPosition(ResourceLocation sound, double x, double y, double z, double speedMultiplier, double rangeMultiplier) {
        lastPlayedPositions.put(sound, new TimedSoundData(new Vec3(x, y, z), System.currentTimeMillis(), speedMultiplier, rangeMultiplier));
    }

    public static void notifyNearbyMobs(ServerLevel level, ResourceLocation sound, double x, double y, double z, double speedMultiplier, double rangeMultiplier) {
        Vec3 soundPos = new Vec3(x, y, z);
        block0: for (Entity entity : level.m_8583_()) {
            Mob mob;
            if (!(entity instanceof Mob) || (mob = (Mob)entity).m_5448_() != null) continue;
            for (WrappedGoal wrappedGoal : mob.f_21345_.m_148105_()) {
                if (!(wrappedGoal.m_26015_() instanceof ReactToGeneralSoundGoal)) continue;
                ((ReactToGeneralSoundGoal)wrappedGoal.m_26015_()).onSoundPlayed(sound, soundPos, speedMultiplier, rangeMultiplier);
                continue block0;
            }
        }
    }

    public static Vec3 getLastPlayedPositionForSound(ResourceLocation soundLocation) {
        TimedSoundData data = lastPlayedPositions.get(soundLocation);
        if (data != null && System.currentTimeMillis() - data.timestamp() <= 4000L) {
            return data.position();
        }
        return null;
    }
}

