/*
 * Decompiled with CFR 0.152.
 */
package com.armilp.ezvcsurvival.events;

import com.armilp.ezvcsurvival.config.GeneralSoundsConfig;
import com.armilp.ezvcsurvival.network.EZVCNetwork;
import com.armilp.ezvcsurvival.network.GeneralSoundPacket;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="ezvcsurvival", value={Dist.CLIENT})
public class SoundEventHandler {
    private static final Map<ResourceLocation, Long> SOUND_COOLDOWNS = new ConcurrentHashMap<ResourceLocation, Long>(128);
    private static final long EXPLOSION_COOLDOWN_MS = 300L;
    private static final long DEFAULT_COOLDOWN_MS = 50L;
    private static long lastCleanupTime = 0L;
    private static final long CLEANUP_INTERVAL_MS = 10000L;
    private static final int MAX_COOLDOWN_ENTRIES = 150;

    @SubscribeEvent
    public static void onPlaySound(PlaySoundEvent event) {
        SoundInstance soundInstance = event.getSound();
        if (!(soundInstance instanceof SimpleSoundInstance)) {
            return;
        }
        SimpleSoundInstance sound = (SimpleSoundInstance)soundInstance;
        Minecraft mc = Minecraft.m_91087_();
        if (mc.m_91403_() == null || mc.f_91074_ == null) {
            return;
        }
        Map<String, GeneralSoundsConfig.SoundEntry> soundMap = GeneralSoundsConfig.getSounds();
        if (soundMap == null) {
            return;
        }
        ResourceLocation soundLoc = sound.m_7904_();
        String soundId = soundLoc.toString();
        GeneralSoundsConfig.SoundEntry cfg = soundMap.get(soundId);
        if (cfg == null || !cfg.enabled) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (cfg.is_priority) {
            Long lastTime = SOUND_COOLDOWNS.get(soundLoc);
            if (lastTime != null && currentTime - lastTime < 50L) {
                return;
            }
            SOUND_COOLDOWNS.put(soundLoc, currentTime);
        } else if (SoundEventHandler.shouldApplyCooldown(soundId, cfg.is_priority)) {
            Long lastTime = SOUND_COOLDOWNS.get(soundLoc);
            long cooldownDuration = SoundEventHandler.getCooldownDuration(soundId, cfg.is_priority);
            if (lastTime != null && currentTime - lastTime < cooldownDuration) {
                return;
            }
            SOUND_COOLDOWNS.put(soundLoc, currentTime);
        }
        if (currentTime - lastCleanupTime > 10000L) {
            SoundEventHandler.cleanupCooldowns(currentTime);
            lastCleanupTime = currentTime;
        }
        EZVCNetwork.INSTANCE.sendToServer((Object)new GeneralSoundPacket(soundLoc, sound.m_7772_(), sound.m_7780_(), sound.m_7778_(), cfg.speed_multiplier, cfg.range_multiplier));
    }

    private static boolean shouldApplyCooldown(String soundId, boolean isPriority) {
        if (isPriority) {
            return true;
        }
        if (soundId.contains("explode") || soundId.contains("explosion")) {
            return true;
        }
        return soundId.contains("tnt");
    }

    private static long getCooldownDuration(String soundId, boolean isPriority) {
        if (isPriority) {
            return 50L;
        }
        if (soundId.contains("explode") || soundId.contains("explosion") || soundId.contains("tnt")) {
            return 300L;
        }
        return 50L;
    }

    private static void cleanupCooldowns(long currentTime) {
        if (SOUND_COOLDOWNS.size() > 150) {
            SOUND_COOLDOWNS.clear();
            return;
        }
        Iterator<Map.Entry<ResourceLocation, Long>> iterator = SOUND_COOLDOWNS.entrySet().iterator();
        long threshold = 1200L;
        while (iterator.hasNext()) {
            Map.Entry<ResourceLocation, Long> entry = iterator.next();
            if (currentTime - entry.getValue() <= threshold) continue;
            iterator.remove();
        }
    }
}

