/*
 * Decompiled with CFR 0.152.
 */
package com.armilp.ezvcsurvival.config;

import com.armilp.ezvcsurvival.EZVCSurvival;
import com.armilp.ezvcsurvival.config.GeneralSoundsConfig;
import com.armilp.ezvcsurvival.config.GunfireConfig;
import com.armilp.ezvcsurvival.data.GunTypeModifiers;
import com.armilp.ezvcsurvival.data.SoundGroupData;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;

@Mod.EventBusSubscriber(modid="ezvcsurvival", bus=Mod.EventBusSubscriber.Bus.MOD)
public class SoundConfig {
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> TACZ_GUN_TYPE_MODIFIERS;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> SILENCED_GUN_IDS;
    public static final ForgeConfigSpec.DoubleValue THUNDER_RANGE_MULTIPLIER;
    public static final ForgeConfigSpec.BooleanValue DEBUG;
    private static final List<SoundGroupData> priorityGroups;
    private static final Map<String, Map<String, Object>> generalReactionsMap;
    private static final Map<String, Map<String, Object>> gunfireReactionsMap;
    private static final Map<String, GunTypeModifiers> gunModifiersMap;
    private static final Set<String> silencedGunIds;
    private static final List<SoundGroupData> customSoundGroups;
    private static volatile boolean configLoaded;
    public static final ForgeConfigSpec.BooleanValue ENABLE_GUNFIRE;
    public static final ForgeConfigSpec.BooleanValue ENABLE_GENERAL_SOUNDS;
    public static final ForgeConfigSpec SPEC;

    @SubscribeEvent
    public static void onModConfigLoading(ModConfigEvent.Loading event) {
        if (event.getConfig().getSpec() == SPEC) {
            EZVCSurvival.LOGGER.info("[SoundConfig] Loading configuration...");
            SoundConfig.loadConfigs();
            configLoaded = true;
        }
    }

    @SubscribeEvent
    public static void onModConfigReloading(ModConfigEvent.Reloading event) {
        if (event.getConfig().getSpec() == SPEC) {
            EZVCSurvival.LOGGER.info("[SoundConfig] Reloading configuration...");
            SoundConfig.loadConfigs();
        }
    }

    public static void loadConfigs() {
        SoundConfig.loadGunTypeModifiers();
        SoundConfig.loadSilencedGuns();
        try {
            GeneralSoundsConfig.init();
            GunfireConfig.init();
            SoundConfig.mergeGeneralSoundsFromJson();
            SoundConfig.mergeGunfireFromJson();
            SoundConfig.refreshPriorityGroups();
        }
        catch (Exception e) {
            EZVCSurvival.LOGGER.warn("[SoundConfig] Error loading JSON configs: {}", (Object)e.getMessage());
        }
    }

    private static void loadDefaultGunTypeModifiers() {
        if (SoundConfig.isDebugEnabled()) {
            EZVCSurvival.LOGGER.info("[SoundConfig] Loading DEFAULT gun type modifiers...");
        }
        gunModifiersMap.put("pistol", new GunTypeModifiers(1.0, 3.8));
        gunModifiersMap.put("sniper", new GunTypeModifiers(1.0, 8.0));
        gunModifiersMap.put("rifle", new GunTypeModifiers(1.0, 6.5));
        gunModifiersMap.put("shotgun", new GunTypeModifiers(1.0, 4.8));
        gunModifiersMap.put("smg", new GunTypeModifiers(1.0, 3.0));
        gunModifiersMap.put("rpg", new GunTypeModifiers(1.0, 10.0));
        gunModifiersMap.put("mg", new GunTypeModifiers(1.0, 4.0));
        if (SoundConfig.isDebugEnabled()) {
            EZVCSurvival.LOGGER.info("[SoundConfig] Loaded {} default modifiers", (Object)gunModifiersMap.size());
            gunModifiersMap.forEach((key, value) -> EZVCSurvival.LOGGER.info("[SoundConfig]   '{}' -> speed={}x, range={}x", new Object[]{key, value.speedMultiplier(), value.rangeMultiplier()}));
        }
    }

    private static void loadGunTypeModifiers() {
        if (!configLoaded) {
            if (SoundConfig.isDebugEnabled()) {
                EZVCSurvival.LOGGER.info("[SoundConfig] Config not loaded yet, keeping defaults");
            }
            return;
        }
        gunModifiersMap.clear();
        List modifiers = (List)TACZ_GUN_TYPE_MODIFIERS.get();
        if (SoundConfig.isDebugEnabled()) {
            EZVCSurvival.LOGGER.info("[SoundConfig] Loading {} gun modifiers from config...", (Object)modifiers.size());
        }
        for (String entry : modifiers) {
            String[] parts = entry.split("=", 2);
            if (parts.length < 2) {
                EZVCSurvival.LOGGER.warn("[SoundConfig] Invalid entry (no '='): {}", (Object)entry);
                continue;
            }
            String[] types = parts[0].split(",");
            String[] values = parts[1].split(",");
            if (values.length != 2) {
                EZVCSurvival.LOGGER.warn("[SoundConfig] Invalid values (need 2): {}", (Object)entry);
                continue;
            }
            try {
                double speed = Double.parseDouble(values[0].trim());
                double range = Double.parseDouble(values[1].trim());
                for (String type : types) {
                    String t = type.trim().toLowerCase();
                    if (t.isEmpty()) continue;
                    gunModifiersMap.put(t, new GunTypeModifiers(speed, range));
                    if (!SoundConfig.isDebugEnabled()) continue;
                    EZVCSurvival.LOGGER.info("[SoundConfig] Loaded: '{}' -> speed={}x, range={}x", new Object[]{t, speed, range});
                }
            }
            catch (NumberFormatException e) {
                EZVCSurvival.LOGGER.warn("[SoundConfig] Invalid numbers in: {}", (Object)entry);
            }
        }
        if (SoundConfig.isDebugEnabled()) {
            EZVCSurvival.LOGGER.info("[SoundConfig] Config load complete: {} types", (Object)gunModifiersMap.size());
        }
    }

    private static void loadSilencedGuns() {
        silencedGunIds.clear();
        List list = (List)SILENCED_GUN_IDS.get();
        if (list != null) {
            for (String id : list) {
                silencedGunIds.add(id.trim().toLowerCase());
            }
        }
    }

    private static void refreshPriorityGroups() {
        priorityGroups.clear();
        GeneralSoundsConfig.processPrioritySounds(priorityGroups);
    }

    private static void mergeGeneralSoundsFromJson() {
        Map<String, GeneralSoundsConfig.Reaction> mobs = GeneralSoundsConfig.getMobReactions();
        if (mobs != null) {
            for (Map.Entry<String, GeneralSoundsConfig.Reaction> e : mobs.entrySet()) {
                GeneralSoundsConfig.Reaction r = e.getValue();
                HashMap<String, Double> map = new HashMap<String, Double>();
                map.put("speed", r.speed);
                map.put("range", r.range);
                generalReactionsMap.put(e.getKey(), map);
            }
        }
        customSoundGroups.removeIf(g -> g.groupName().startsWith("auto_sound_"));
        Map<String, GeneralSoundsConfig.SoundEntry> sounds = GeneralSoundsConfig.getSounds();
        if (sounds != null) {
            for (Map.Entry<String, GeneralSoundsConfig.SoundEntry> e : sounds.entrySet()) {
                GeneralSoundsConfig.SoundEntry se = e.getValue();
                customSoundGroups.add(new SoundGroupData("auto_sound_" + e.getKey().replace(':', '_').replace('.', '_'), List.of(e.getKey()), se.speed_multiplier, se.range_multiplier));
            }
        }
        GeneralSoundsConfig.processPrioritySounds(priorityGroups);
    }

    private static void mergeGunfireFromJson() {
        Map<String, GunfireConfig.Reaction> mobs = GunfireConfig.getMobReactions();
        if (mobs != null) {
            for (Map.Entry<String, GunfireConfig.Reaction> e : mobs.entrySet()) {
                GunfireConfig.Reaction r = e.getValue();
                if (r == null) continue;
                HashMap<String, Constable> map = new HashMap<String, Constable>();
                map.put("speed", Double.valueOf(r.speed));
                map.put("range", Double.valueOf(r.range));
                map.put("enabled", Boolean.valueOf(r.enabled));
                gunfireReactionsMap.put(e.getKey(), map);
            }
        }
    }

    public static double getSpeedMultiplier(String gunType) {
        if (gunType == null || gunType.isEmpty()) {
            return 1.0;
        }
        String key = gunType.toLowerCase();
        GunTypeModifiers mod = gunModifiersMap.get(key);
        return mod != null ? mod.speedMultiplier() : 1.0;
    }

    public static double getRangeMultiplier(String gunType) {
        if (gunType == null || gunType.isEmpty()) {
            return 1.0;
        }
        String key = gunType.toLowerCase();
        GunTypeModifiers mod = gunModifiersMap.get(key);
        return mod != null ? mod.rangeMultiplier() : 1.0;
    }

    public static boolean isSilencedGun(ResourceLocation id) {
        return id != null && silencedGunIds.contains(id.toString().toLowerCase());
    }

    public static List<SoundGroupData> getEnabledSoundGroups() {
        return Collections.unmodifiableList(customSoundGroups);
    }

    public static List<SoundGroupData> getPriorityGroups() {
        return Collections.unmodifiableList(priorityGroups);
    }

    public static boolean isDebugEnabled() {
        try {
            return (Boolean)DEBUG.get();
        }
        catch (Exception e) {
            return false;
        }
    }

    static {
        priorityGroups = new ArrayList<SoundGroupData>();
        generalReactionsMap = new HashMap<String, Map<String, Object>>();
        gunfireReactionsMap = new HashMap<String, Map<String, Object>>();
        gunModifiersMap = new HashMap<String, GunTypeModifiers>();
        silencedGunIds = new HashSet<String>();
        customSoundGroups = new ArrayList<SoundGroupData>();
        configLoaded = false;
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.comment(new String[]{"GunFire Generation", "If true, automatically adds new entities to gunfire.json when detected", "If false, only uses entities already in the file (allows manual control)"}).push("gunfire_generation");
        ENABLE_GUNFIRE = builder.define("enable_generation", true);
        builder.pop();
        builder.comment(new String[]{"GeneralSounds Generation", "If true, automatically adds new entities to generalsounds.json when detected", "If false, only uses entities and sounds already in the file (allows manual control)"}).push("generalsounds_generation");
        ENABLE_GENERAL_SOUNDS = builder.define("enable_generation", true);
        builder.pop();
        builder.comment("Debug Mode").push("debugging");
        DEBUG = builder.define("debug", false);
        builder.pop();
        builder.push("weather");
        THUNDER_RANGE_MULTIPLIER = builder.defineInRange("thunder_range_multiplier", 0.8, 0.0, 1.0);
        builder.pop();
        builder.push("tacz_gun_modifiers");
        builder.comment(new String[]{"Gun type modifiers in format: type=speed,range", "Speed: multiplier for mob reaction speed", "Range: multiplier for detection range", "Example: 'pistol=1.0,3.8' means normal speed, 3.8x range"});
        TACZ_GUN_TYPE_MODIFIERS = builder.defineList("modifiers", () -> List.of("pistol=1.0,3.8", "sniper=1.0,8.0", "rifle=1.0,6.5", "shotgun=1.0,4.8", "smg=1.0,3.0", "rpg=1.0,10.0", "mg=1.0,4.0"), obj -> obj instanceof String && ((String)obj).contains("="));
        builder.pop();
        builder.push("tacz_silenced_guns");
        SILENCED_GUN_IDS = builder.defineList("ids", () -> List.of("daffas_arsenal:hk45_sup", "daffas_arsenal:apacoba9_sup"), obj -> {
            if (!(obj instanceof String)) {
                return false;
            }
            String s = ((String)obj).trim();
            return ResourceLocation.m_135830_((String)s);
        });
        builder.pop();
        SPEC = builder.build();
        SoundConfig.loadDefaultGunTypeModifiers();
    }
}

