/*
 * Decompiled with CFR 0.152.
 */
package com.armilp.ezvcsurvival.config;

import com.armilp.ezvcsurvival.EZVCSurvival;
import com.armilp.ezvcsurvival.config.VoiceConfig;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.MalformedJsonException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.ForgeRegistries;

public final class EntityVoiceConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Type ROOT_TYPE = new TypeToken<RootConfig>(){}.getType();
    private static Map<String, EntityConfig> MONSTER_CONFIGS = new HashMap<String, EntityConfig>();
    private static Map<String, EntityConfig> ANIMAL_CONFIGS = new HashMap<String, EntityConfig>();
    public static RootConfig ROOT = new RootConfig();
    private static boolean isInitialized = false;

    private EntityVoiceConfig() {
    }

    public static void init() {
        if (!isInitialized) {
            EntityVoiceConfig.loadOrCreate();
            isInitialized = true;
        } else {
            EntityVoiceConfig.reloadFromDisk();
        }
    }

    private static void reloadFromDisk() {
        Path path = EntityVoiceConfig.getConfigPath();
        if (Files.exists(path, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(path, StandardCharsets.UTF_8);){
                RootConfig loaded = (RootConfig)GSON.fromJson((Reader)reader, ROOT_TYPE);
                if (loaded != null) {
                    ROOT = loaded;
                    MONSTER_CONFIGS = loaded.monsters != null ? new HashMap<String, EntityConfig>(loaded.monsters) : new HashMap();
                    ANIMAL_CONFIGS = loaded.animals != null ? new HashMap<String, EntityConfig>(loaded.animals) : new HashMap();
                }
            }
            catch (Exception e) {
                EZVCSurvival.LOGGER.warn("Error reloading entities_voices.json: {}", (Object)e.getMessage());
            }
        }
    }

    public static Set<String> getAllEntityIds() {
        HashSet<String> all = new HashSet<String>();
        all.addAll(MONSTER_CONFIGS.keySet());
        all.addAll(ANIMAL_CONFIGS.keySet());
        return all;
    }

    public static EntityConfig getMonster(String entityId) {
        return MONSTER_CONFIGS.get(entityId);
    }

    public static EntityConfig getAnimal(String entityId) {
        return ANIMAL_CONFIGS.get(entityId);
    }

    public static EntityConfig get(String entityId) {
        EntityConfig ec = MONSTER_CONFIGS.get(entityId);
        if (ec == null) {
            ec = ANIMAL_CONFIGS.get(entityId);
        }
        return ec;
    }

    public static void set(String entityId, EntityConfig value) {
        if (MONSTER_CONFIGS.containsKey(entityId)) {
            MONSTER_CONFIGS.put(entityId, value);
        } else {
            ANIMAL_CONFIGS.put(entityId, value);
        }
    }

    public static void persist() {
        EntityVoiceConfig.save(EntityVoiceConfig.getConfigPath());
    }

    private static Path getConfigPath() {
        Path configDir = FMLPaths.CONFIGDIR.get().resolve("ezvcsurvival");
        try {
            Files.createDirectories(configDir, new FileAttribute[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return configDir.resolve("entities_voices.json");
    }

    private static void loadOrCreate() {
        Path path = EntityVoiceConfig.getConfigPath();
        if (Files.exists(path, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(path, StandardCharsets.UTF_8);){
                RootConfig loaded = (RootConfig)GSON.fromJson((Reader)reader, ROOT_TYPE);
                if (loaded != null) {
                    ROOT = loaded;
                    MONSTER_CONFIGS = loaded.monsters != null ? new HashMap<String, EntityConfig>(loaded.monsters) : new HashMap();
                    HashMap<String, EntityConfig> hashMap = ANIMAL_CONFIGS = loaded.animals != null ? new HashMap<String, EntityConfig>(loaded.animals) : new HashMap();
                    if (((Boolean)VoiceConfig.DEBUG.get()).booleanValue()) {
                        EZVCSurvival.LOGGER.info("[EntityVoiceConfig] Loaded {} monsters, {} animals from file", (Object)MONSTER_CONFIGS.size(), (Object)ANIMAL_CONFIGS.size());
                    }
                } else {
                    ROOT = new RootConfig();
                    MONSTER_CONFIGS = new HashMap<String, EntityConfig>();
                    ANIMAL_CONFIGS = new HashMap<String, EntityConfig>();
                    EntityVoiceConfig.generateDefaults();
                    EntityVoiceConfig.save(path);
                }
            }
            catch (JsonParseException | MalformedJsonException e) {
                EZVCSurvival.LOGGER.warn("Malformed JSON in entities_voices.json, using defaults: {}", (Object)e.getMessage());
                ROOT = new RootConfig();
                MONSTER_CONFIGS = new HashMap<String, EntityConfig>();
                ANIMAL_CONFIGS = new HashMap<String, EntityConfig>();
                EntityVoiceConfig.generateDefaults();
                EntityVoiceConfig.save(path);
            }
            catch (IOException e) {
                EZVCSurvival.LOGGER.warn("Error reading entities_voices.json, regenerating: {}", (Object)e.getMessage());
                ROOT = new RootConfig();
                MONSTER_CONFIGS = new HashMap<String, EntityConfig>();
                ANIMAL_CONFIGS = new HashMap<String, EntityConfig>();
                EntityVoiceConfig.generateDefaults();
                EntityVoiceConfig.save(path);
            }
        } else {
            ROOT = new RootConfig();
            EntityVoiceConfig.generateDefaults();
            EntityVoiceConfig.save(path);
        }
        if (((Boolean)VoiceConfig.ENABLE_ENTITY_VOICE.get()).booleanValue()) {
            boolean addedNew = EntityVoiceConfig.ensureAllEntitiesPresent();
            if (addedNew) {
                EntityVoiceConfig.save(path);
                if (((Boolean)VoiceConfig.DEBUG.get()).booleanValue()) {
                    EZVCSurvival.LOGGER.info("[EntityVoiceConfig] Auto-generation enabled: added new entities");
                }
            }
        } else if (((Boolean)VoiceConfig.DEBUG.get()).booleanValue()) {
            EZVCSurvival.LOGGER.info("[EntityVoiceConfig] Auto-generation disabled: using existing entities only");
        }
    }

    private static boolean ensureAllEntitiesPresent() {
        boolean added = false;
        for (EntityType type : ForgeRegistries.ENTITY_TYPES) {
            MobCategory category = type.m_20674_();
            if (category == MobCategory.MISC) continue;
            String id = Objects.requireNonNull(ForgeRegistries.ENTITY_TYPES.getKey((Object)type)).toString();
            if (EntityVoiceConfig.isMonsterCategory(category)) {
                if (MONSTER_CONFIGS.containsKey(id)) continue;
                MONSTER_CONFIGS.put(id, EntityConfig.defaultFor(type));
                added = true;
                continue;
            }
            if (!EntityVoiceConfig.isAnimalLikeCategory(category) || ANIMAL_CONFIGS.containsKey(id)) continue;
            ANIMAL_CONFIGS.put(id, EntityConfig.defaultFor(type));
            added = true;
        }
        return added;
    }

    private static void generateDefaults() {
        MONSTER_CONFIGS.clear();
        ANIMAL_CONFIGS.clear();
        for (EntityType type : ForgeRegistries.ENTITY_TYPES) {
            MobCategory category = type.m_20674_();
            if (category == MobCategory.MISC) continue;
            if (EntityVoiceConfig.isMonsterCategory(category)) {
                MONSTER_CONFIGS.put(Objects.requireNonNull(ForgeRegistries.ENTITY_TYPES.getKey((Object)type)).toString(), EntityConfig.defaultFor(type));
                continue;
            }
            if (!EntityVoiceConfig.isAnimalLikeCategory(category)) continue;
            ANIMAL_CONFIGS.put(Objects.requireNonNull(ForgeRegistries.ENTITY_TYPES.getKey((Object)type)).toString(), EntityConfig.defaultFor(type));
        }
        EntityVoiceConfig.putIfPresent(MONSTER_CONFIGS, "minecraft:zombie", new EntityConfig(true, 1.0, 60.0, -20.0));
        EntityVoiceConfig.putIfPresent(MONSTER_CONFIGS, "minecraft:skeleton", new EntityConfig(true, 1.0, 40.0, -15.0));
        EntityVoiceConfig.putIfPresent(MONSTER_CONFIGS, "quiet_place:death_angel", new EntityConfig(true, 1.0, 50.0, -10.0));
        EntityVoiceConfig.putIfPresent(ANIMAL_CONFIGS, "minecraft:cow", new EntityConfig(true, 1.0, 25.0, -18.0));
        EntityVoiceConfig.putIfPresent(ANIMAL_CONFIGS, "minecraft:pig", new EntityConfig(true, 1.0, 15.0, -18.0));
        EntityVoiceConfig.activateEntitiesFromMod("zombie_extreme", new EntityConfig(true, 1.0, 40.0, -20.0));
        EntityVoiceConfig.activateEntitiesFromMod("apocalypsenow", new EntityConfig(true, 1.0, 40.0, -20.0));
    }

    private static boolean isMonsterCategory(MobCategory category) {
        return category == MobCategory.MONSTER;
    }

    private static boolean isAnimalLikeCategory(MobCategory category) {
        return category == MobCategory.CREATURE || category == MobCategory.AMBIENT || category == MobCategory.WATER_CREATURE || category == MobCategory.UNDERGROUND_WATER_CREATURE || category.name().equalsIgnoreCase("AXOLOTLS");
    }

    private static void putIfPresent(Map<String, EntityConfig> map, String id, EntityConfig config) {
        if (map.containsKey(id)) {
            map.put(id, config);
        }
    }

    private static void activateEntitiesFromMod(String modId, EntityConfig config) {
        for (EntityType type : ForgeRegistries.ENTITY_TYPES) {
            ResourceLocation key = ForgeRegistries.ENTITY_TYPES.getKey((Object)type);
            if (key == null || !key.m_135827_().equals(modId) || type.m_20674_() != MobCategory.MONSTER) continue;
            String id = key.toString();
            MONSTER_CONFIGS.put(id, config);
        }
    }

    private static void save(Path path) {
        if (MONSTER_CONFIGS == null || ANIMAL_CONFIGS == null) {
            EZVCSurvival.LOGGER.warn("Cannot save null configuration maps");
            return;
        }
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            if (ROOT == null) {
                ROOT = new RootConfig();
            }
            EntityVoiceConfig.ROOT.monsters = MONSTER_CONFIGS;
            EntityVoiceConfig.ROOT.animals = ANIMAL_CONFIGS;
            try (BufferedWriter writer = Files.newBufferedWriter(path, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);){
                GSON.toJson((Object)ROOT, ROOT_TYPE, (Appendable)writer);
                writer.flush();
            }
            if (((Boolean)VoiceConfig.DEBUG.get()).booleanValue()) {
                EZVCSurvival.LOGGER.info("[EntityVoiceConfig] Saved config with enabled={}", (Object)EntityVoiceConfig.ROOT.enabled);
            }
        }
        catch (IOException e) {
            EZVCSurvival.LOGGER.error("Failed to save entities_voices.json: {}", (Object)e.getMessage());
        }
    }

    public static boolean isEnabled() {
        return ROOT == null || EntityVoiceConfig.ROOT.enabled;
    }

    public static void setEnabled(boolean enabled) {
        if (ROOT == null) {
            ROOT = new RootConfig();
        }
        EntityVoiceConfig.ROOT.enabled = enabled;
        EntityVoiceConfig.persist();
        if (((Boolean)VoiceConfig.DEBUG.get()).booleanValue()) {
            EZVCSurvival.LOGGER.info("[EntityVoiceConfig] setEnabled: {}", (Object)enabled);
        }
    }

    public static EntityConfig getOrCreate(String entityId) {
        EntityConfig config = EntityVoiceConfig.get(entityId);
        if (config != null) {
            return config;
        }
        if (!((Boolean)VoiceConfig.ENABLE_ENTITY_VOICE.get()).booleanValue()) {
            if (((Boolean)VoiceConfig.DEBUG.get()).booleanValue()) {
                EZVCSurvival.LOGGER.info("[EntityVoiceConfig] Entity '{}' not found and auto-generation disabled", (Object)entityId);
            }
            return null;
        }
        config = new EntityConfig(true, 1.0, 60.0, -20.0);
        EntityVoiceConfig.set(entityId, config);
        EntityVoiceConfig.persist();
        if (((Boolean)VoiceConfig.DEBUG.get()).booleanValue()) {
            EZVCSurvival.LOGGER.info("[EntityVoiceConfig] Created default config for: {}", (Object)entityId);
        }
        return config;
    }

    public static final class RootConfig {
        public boolean enabled = true;
        public Map<String, EntityConfig> monsters;
        public Map<String, EntityConfig> animals;
    }

    public static final class EntityConfig {
        public boolean enabled;
        public double speed;
        public double range;
        public double threshold;

        public EntityConfig(boolean enabled, double speed, double range, double threshold) {
            this.enabled = enabled;
            this.speed = speed;
            this.range = range;
            this.threshold = threshold;
        }

        public static EntityConfig defaultFor(EntityType<?> type) {
            double baseSpeed = 1.0;
            double baseRange = 50.0;
            double baseThreshold = -20.0;
            if (type != null && type.m_20674_() == MobCategory.MONSTER) {
                baseRange = 60.0;
            }
            return new EntityConfig(false, baseSpeed, baseRange, baseThreshold);
        }
    }
}

