/*
 * Decompiled with CFR 0.152.
 */
package com.armilp.ezvcsurvival.compat.mobs.spore;

import com.Harbinger.Spore.Sentities.BaseEntities.Calamity;
import com.Harbinger.Spore.Sentities.BaseEntities.Infected;
import com.Harbinger.Spore.Sentities.BaseEntities.UtilityEntity;
import com.armilp.ezvcsurvival.compat.mobs.spore.SporeVoiceTargetGoal;
import com.armilp.ezvcsurvival.config.EntityVoiceConfig;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;

public class SporeCompatLoader {
    public static void init() {
        if (!ModList.get().isLoaded("spore")) {
            System.out.println("[EZVCSurvival] Spore not found, skipping compatibility.");
            return;
        }
        MinecraftForge.EVENT_BUS.register((Object)new SporeCompatLoader());
        System.out.println("[EZVCSurvival] Spore compatibility active.");
    }

    @SubscribeEvent
    public void onEntityJoin(EntityJoinLevelEvent event) {
        if (event.getLevel().m_5776_()) {
            return;
        }
        if (!EntityVoiceConfig.isEnabled()) {
            return;
        }
        String id = event.getEntity().m_6095_().m_204041_().m_205785_().m_135782_().toString();
        if (!id.startsWith("spore:")) {
            return;
        }
        EntityVoiceConfig.EntityConfig cfg = EntityVoiceConfig.getOrCreate(id);
        if (!cfg.enabled) {
            return;
        }
        try {
            SporeVoiceTargetGoal voiceGoal = null;
            Entity entity = event.getEntity();
            if (entity instanceof Infected) {
                Infected infected = (Infected)entity;
                voiceGoal = new SporeVoiceTargetGoal(infected, cfg.speed, (int)cfg.range, cfg.threshold, 10000L);
                infected.f_21345_.m_25352_(1, (Goal)voiceGoal);
            } else {
                entity = event.getEntity();
                if (entity instanceof Calamity) {
                    Calamity calamity = (Calamity)entity;
                    voiceGoal = new SporeVoiceTargetGoal(calamity, cfg.speed, (int)cfg.range, cfg.threshold, 10000L);
                    calamity.f_21345_.m_25352_(1, (Goal)voiceGoal);
                } else {
                    entity = event.getEntity();
                    if (entity instanceof UtilityEntity) {
                        UtilityEntity utilityEntity = (UtilityEntity)entity;
                        voiceGoal = new SporeVoiceTargetGoal(utilityEntity, cfg.speed, (int)cfg.range, cfg.threshold, 10000L);
                        utilityEntity.f_21345_.m_25352_(1, (Goal)voiceGoal);
                    }
                }
            }
            if (voiceGoal != null) {
                System.out.println("[EZVCSurvival] Added SporeVoiceTargetGoal to " + id);
            }
        }
        catch (Exception e) {
            System.err.println("[EZVCSurvival] Failed to add goal to Spore entity: " + e);
            e.printStackTrace();
        }
    }
}

