/*
 * Decompiled with CFR 0.152.
 */
package com.armilp.ezvcsurvival.compat.guns;

import com.armilp.ezvcsurvival.EZVCSurvival;
import com.armilp.ezvcsurvival.commands.SoundEffectCommand;
import com.armilp.ezvcsurvival.config.SoundConfig;
import com.armilp.ezvcsurvival.data.GunshotData;
import com.tacz.guns.api.entity.IGunOperator;
import com.tacz.guns.api.event.common.GunFireEvent;
import com.tacz.guns.api.item.GunTabType;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.resource.index.CommonGunIndex;
import com.tacz.guns.resource.modifier.AttachmentCacheProperty;
import com.tacz.guns.resource.modifier.custom.SilenceModifier;
import it.unimi.dsi.fastutil.Pair;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class GunFireListener {
    private static final List<GunshotData> gunshotPositions = new CopyOnWriteArrayList<GunshotData>();
    private static final long EXPIRATION_TIME_MS = 5000L;

    @SubscribeEvent
    public static void onGunFire(GunFireEvent event) {
        ItemStack gunStack = event.getGunItemStack();
        IGun gun = IGun.getIGunOrNull((ItemStack)gunStack);
        LivingEntity shooter = event.getShooter();
        if (shooter != null && GunFireListener.useSilenceSound(shooter, gunStack)) {
            return;
        }
        if (shooter == null) {
            return;
        }
        Vec3 shooterPos = shooter.m_20182_();
        GunTabType gunType = GunTabType.PISTOL;
        if (gun != null) {
            try {
                CommonGunIndex commonGunIndex;
                ResourceLocation gunId = gun.getGunId(gunStack);
                String gunIdStr = gunId.toString().toLowerCase();
                if (SoundConfig.isDebugEnabled()) {
                    EZVCSurvival.LOGGER.info("[GunFire] Gun fired: {}", (Object)gunId);
                }
                if ((commonGunIndex = CommonGunIndexRegistry.getCommonGunIndex(gunId)) != null) {
                    String typeStr = commonGunIndex.getType();
                    try {
                        gunType = GunTabType.valueOf((String)typeStr.toUpperCase());
                        if (SoundConfig.isDebugEnabled()) {
                            EZVCSurvival.LOGGER.info("[GunFire] \u2713 Type from registry: {}", (Object)gunType);
                        }
                    }
                    catch (IllegalArgumentException e) {
                        EZVCSurvival.LOGGER.warn("[GunFire] Invalid gun type in index: {}", (Object)typeStr);
                        gunType = GunFireListener.inferGunTypeFromId(gunIdStr);
                    }
                } else {
                    if (SoundConfig.isDebugEnabled()) {
                        EZVCSurvival.LOGGER.info("[GunFire] No index found, inferring from ID...");
                    }
                    gunType = GunFireListener.inferGunTypeFromId(gunIdStr);
                }
                if (SoundConfig.isDebugEnabled()) {
                    String gunTypeLower = gunType.name().toLowerCase();
                    double speedMult = SoundConfig.getSpeedMultiplier(gunTypeLower);
                    double rangeMult = SoundConfig.getRangeMultiplier(gunTypeLower);
                    EZVCSurvival.LOGGER.info("[GunFire] Final: {} -> Type: {}, Speed: {}x, Range: {}x", new Object[]{gunId, gunType, speedMult, rangeMult});
                }
            }
            catch (Exception e) {
                EZVCSurvival.LOGGER.error("[GunFire] Error determining gun type for {}", (Object)gun.getGunId(gunStack), (Object)e);
                gunType = GunTabType.PISTOL;
            }
        }
        if (shooter instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)shooter;
            SoundEffectCommand.applyEffect(serverPlayer);
        }
        gunshotPositions.add(new GunshotData(shooterPos, System.currentTimeMillis(), gunType));
    }

    private static GunTabType inferGunTypeFromId(String gunIdStr) {
        GunTabType result = gunIdStr.contains("sniper") || gunIdStr.contains("awp") || gunIdStr.contains("barrett") ? GunTabType.SNIPER : (gunIdStr.contains("rifle") || gunIdStr.contains("ak") || gunIdStr.contains("m4") || gunIdStr.contains("scar") || gunIdStr.contains("hk416") ? GunTabType.RIFLE : (gunIdStr.contains("shotgun") || gunIdStr.contains("spas") || gunIdStr.contains("m870") ? GunTabType.SHOTGUN : (gunIdStr.contains("smg") || gunIdStr.contains("mp5") || gunIdStr.contains("ump") || gunIdStr.contains("vector") || gunIdStr.contains("uzi") ? GunTabType.SMG : (gunIdStr.contains("rpg") || gunIdStr.contains("rocket") || gunIdStr.contains("launcher") ? GunTabType.RPG : (gunIdStr.contains("mg") || gunIdStr.contains("lmg") || gunIdStr.contains("m249") || gunIdStr.contains("minigun") ? GunTabType.MG : GunTabType.PISTOL)))));
        if (SoundConfig.isDebugEnabled()) {
            EZVCSurvival.LOGGER.info("[GunFire] Inferred type from '{}': {}", (Object)gunIdStr, (Object)result);
        }
        return result;
    }

    private static boolean useSilenceSound(LivingEntity entity, ItemStack gunStack) {
        Pair silence;
        AttachmentCacheProperty cacheProperty;
        IGunOperator operator = IGunOperator.fromLivingEntity((LivingEntity)entity);
        if (operator != null && (cacheProperty = operator.getCacheProperty()) != null && (silence = (Pair)cacheProperty.getCache(SilenceModifier.ID)) != null && ((Boolean)silence.right()).booleanValue()) {
            return true;
        }
        IGun gun = IGun.getIGunOrNull((ItemStack)gunStack);
        if (gun != null) {
            ResourceLocation gunId = gun.getGunId(gunStack);
            return SoundConfig.isSilencedGun(gunId);
        }
        return false;
    }

    public static GunshotData getLastGunshotData() {
        long currentTime = System.currentTimeMillis();
        gunshotPositions.removeIf(record -> currentTime - record.timestamp() > 5000L);
        return gunshotPositions.isEmpty() ? null : gunshotPositions.get(gunshotPositions.size() - 1);
    }

    public static class CommonGunIndexRegistry {
        private static final Map<ResourceLocation, CommonGunIndex> registry = new HashMap<ResourceLocation, CommonGunIndex>();

        public static CommonGunIndex getCommonGunIndex(ResourceLocation id) {
            return registry.get(id);
        }

        public static void registerCommonGunIndex(ResourceLocation id, CommonGunIndex index) {
            registry.put(id, index);
        }
    }
}

