/*
 * Decompiled with CFR 0.152.
 */
package com.armilp.ezvcsurvival.client.gui.list;

import com.armilp.ezvcsurvival.client.gui.edit.ConfigEditScreen;
import com.armilp.ezvcsurvival.client.gui.list.ConfigListScreen;
import com.armilp.ezvcsurvival.config.EntityVoiceConfig;
import com.armilp.ezvcsurvival.config.GeneralSoundsConfig;
import com.armilp.ezvcsurvival.config.GunfireConfig;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class ConfigListWidget
extends ObjectSelectionList<Entry> {
    private final ConfigListScreen parent;
    private static final int MIN_ENTRY_WIDTH = 300;
    private static final int STATUS_AREA_WIDTH = 120;
    private static final int PADDING = 10;

    public ConfigListWidget(ConfigListScreen parent, Minecraft mc, int width, int height, int top, int bottom, int itemHeight) {
        super(mc, width, height, top, bottom, itemHeight);
        this.parent = parent;
    }

    public void addItem(Object item) {
        this.m_7085_((AbstractSelectionList.Entry)new UniversalEntry(item));
    }

    public void clear() {
        this.m_93516_();
    }

    public int getEntryIndexAt(double mouseX, double mouseY) {
        if (!this.m_5953_(mouseX, mouseY)) {
            return -1;
        }
        int rowLeft = this.m_5747_();
        int rowWidth = this.m_5759_();
        int count = this.m_6702_().size();
        for (int i = 0; i < count; ++i) {
            int rowTop = this.m_7610_(i);
            int rowBottom = rowTop + this.f_93387_;
            if (!(mouseX >= (double)rowLeft) || !(mouseX <= (double)(rowLeft + rowWidth)) || !(mouseY >= (double)rowTop) || !(mouseY <= (double)rowBottom)) continue;
            return i;
        }
        return -1;
    }

    public int m_5759_() {
        return Math.max(300, this.f_93388_ - 20);
    }

    public int m_5747_() {
        return 10;
    }

    protected int m_5756_() {
        return this.m_5747_() + this.m_5759_() + 5;
    }

    public class UniversalEntry
    extends Entry {
        private final Object item;

        public UniversalEntry(Object item) {
            this.item = item;
        }

        public void m_6311_(@NotNull GuiGraphics graphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovered, float partialTick) {
            boolean validHover;
            int actualLeft = ConfigListWidget.this.m_5747_();
            int actualWidth = ConfigListWidget.this.m_5759_();
            boolean bl = validHover = hovered && mouseX >= actualLeft && mouseX <= actualLeft + actualWidth;
            if (validHover) {
                graphics.m_280509_(actualLeft, top, actualLeft + actualWidth, top + height, 0x30FFFFFF);
                graphics.m_280509_(actualLeft, top, actualLeft + actualWidth, top + 1, 0x60FFFFFF);
                graphics.m_280509_(actualLeft, top + height - 1, actualLeft + actualWidth, top + height, 0x60FFFFFF);
            }
            if (index % 2 == 0) {
                graphics.m_280509_(actualLeft, top, actualLeft + actualWidth, top + height, 0x10000000);
            }
            int centerY = top + height / 2;
            int textLeft = actualLeft + 10;
            int statusRight = actualLeft + actualWidth - 10;
            if (this.item instanceof ConfigListScreen.EntityConfigItem) {
                this.renderEntityConfig(graphics, textLeft, top, actualWidth, height, centerY, statusRight);
            } else if (this.item instanceof ConfigListScreen.SoundConfigItem) {
                this.renderSoundConfig(graphics, textLeft, top, actualWidth, height, centerY, statusRight);
            } else if (this.item instanceof ConfigListScreen.EntityReactionItem) {
                this.renderEntityReaction(graphics, textLeft, top, actualWidth, height, centerY, statusRight);
            } else if (this.item instanceof ConfigListScreen.GunfireEntityItem) {
                this.renderGunfireEntity(graphics, textLeft, top, actualWidth, height, centerY, statusRight);
            }
        }

        private void renderEntityConfig(GuiGraphics graphics, int textLeft, int top, int width, int height, int centerY, int statusRight) {
            ConfigListScreen.EntityConfigItem entityItem = (ConfigListScreen.EntityConfigItem)this.item;
            String entityName = entityItem.getDisplayName();
            int maxTextWidth = width - 120 - 20;
            String displayName = this.truncateText(entityName, maxTextWidth);
            graphics.m_280056_(Minecraft.m_91087_().f_91062_, displayName, textLeft, centerY - 4, 0xFFFFFF, false);
            MutableComponent statusText = entityItem.getConfig().enabled ? Component.m_237115_((String)"gui.ezvcsurvival.enabled") : Component.m_237115_((String)"gui.ezvcsurvival.disabled");
            int statusColor = entityItem.getConfig().enabled ? 0x55FF55 : 0xFF5555;
            int statusWidth = Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)statusText);
            graphics.m_280509_(statusRight - statusWidth - 6, centerY - 8, statusRight, centerY + 8, entityItem.getConfig().enabled ? 542506837 : 553604437);
            graphics.m_280614_(Minecraft.m_91087_().f_91062_, (Component)statusText, statusRight - statusWidth - 3, centerY - 4, statusColor, false);
        }

        private void renderSoundConfig(GuiGraphics graphics, int textLeft, int top, int width, int height, int centerY, int statusRight) {
            ConfigListScreen.SoundConfigItem soundItem = (ConfigListScreen.SoundConfigItem)this.item;
            String soundName = soundItem.getId();
            int maxTextWidth = width - 120 - 20;
            String displayName = this.truncateText(soundName, maxTextWidth);
            graphics.m_280056_(Minecraft.m_91087_().f_91062_, displayName, textLeft, centerY - 4, 0xFFFFFF, false);
            MutableComponent statusText = soundItem.getConfig().enabled ? Component.m_237115_((String)"gui.ezvcsurvival.enabled") : Component.m_237115_((String)"gui.ezvcsurvival.disabled");
            int statusColor = soundItem.getConfig().enabled ? 0x55FF55 : 0xFF5555;
            int statusWidth = Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)statusText);
            graphics.m_280509_(statusRight - statusWidth - 6, centerY - 8, statusRight, centerY + 8, soundItem.getConfig().enabled ? 542506837 : 553604437);
            graphics.m_280614_(Minecraft.m_91087_().f_91062_, (Component)statusText, statusRight - statusWidth - 3, centerY - 4, statusColor, false);
        }

        private void renderEntityReaction(GuiGraphics graphics, int textLeft, int top, int width, int height, int centerY, int statusRight) {
            ConfigListScreen.EntityReactionItem entityItem = (ConfigListScreen.EntityReactionItem)this.item;
            String entityId = entityItem.id();
            String entityName = this.getEntityDisplayName(entityId);
            int maxTextWidth = width - 120 - 20;
            String displayName = this.truncateText(entityName, maxTextWidth);
            graphics.m_280056_(Minecraft.m_91087_().f_91062_, displayName, textLeft, centerY - 4, 0xFFFFFF, false);
            MutableComponent statusText = entityItem.reaction().enabled ? Component.m_237115_((String)"gui.ezvcsurvival.enabled") : Component.m_237115_((String)"gui.ezvcsurvival.disabled");
            int statusColor = entityItem.reaction().enabled ? 0x55FF55 : 0xFF5555;
            int statusWidth = Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)statusText);
            graphics.m_280509_(statusRight - statusWidth - 6, centerY - 8, statusRight, centerY + 8, entityItem.reaction().enabled ? 542506837 : 553604437);
            graphics.m_280614_(Minecraft.m_91087_().f_91062_, (Component)statusText, statusRight - statusWidth - 3, centerY - 4, statusColor, false);
        }

        private void renderGunfireEntity(GuiGraphics graphics, int textLeft, int top, int width, int height, int centerY, int statusRight) {
            ConfigListScreen.GunfireEntityItem entityItem = (ConfigListScreen.GunfireEntityItem)this.item;
            String entityId = entityItem.id();
            String entityName = this.getEntityDisplayName(entityId);
            int maxTextWidth = width - 120 - 20;
            String displayName = this.truncateText(entityName, maxTextWidth);
            graphics.m_280056_(Minecraft.m_91087_().f_91062_, displayName, textLeft, centerY - 4, 0xFFFFFF, false);
            MutableComponent statusText = entityItem.reaction().enabled ? Component.m_237115_((String)"gui.ezvcsurvival.enabled") : Component.m_237115_((String)"gui.ezvcsurvival.disabled");
            int statusColor = entityItem.reaction().enabled ? 0x55FF55 : 0xFF5555;
            int statusWidth = Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)statusText);
            graphics.m_280509_(statusRight - statusWidth - 6, centerY - 8, statusRight, centerY + 8, entityItem.reaction().enabled ? 542506837 : 553604437);
            graphics.m_280614_(Minecraft.m_91087_().f_91062_, (Component)statusText, statusRight - statusWidth - 3, centerY - 4, statusColor, false);
        }

        private String truncateText(String text, int maxWidth) {
            if (maxWidth <= 0) {
                return text;
            }
            int textWidth = Minecraft.m_91087_().f_91062_.m_92895_(text);
            if (textWidth <= maxWidth) {
                return text;
            }
            String ellipsis = "...";
            int ellipsisWidth = Minecraft.m_91087_().f_91062_.m_92895_(ellipsis);
            int availableWidth = maxWidth - ellipsisWidth;
            if (availableWidth <= 0) {
                return ellipsis;
            }
            int left = 0;
            int right = text.length();
            while (left < right) {
                int mid = (left + right + 1) / 2;
                String truncated = text.substring(0, mid);
                if (Minecraft.m_91087_().f_91062_.m_92895_(truncated) <= availableWidth) {
                    left = mid;
                    continue;
                }
                right = mid - 1;
            }
            return text.substring(0, left) + ellipsis;
        }

        private String getEntityDisplayName(String entityId) {
            try {
                ResourceLocation key = ResourceLocation.parse((String)entityId);
                EntityType type = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(key);
                if (type != null) {
                    String translationKey = type.m_20675_();
                    return Component.m_237115_((String)translationKey).getString();
                }
                return key.m_135815_();
            }
            catch (Exception ignored) {
                return entityId.contains(":") ? entityId.substring(entityId.indexOf(58) + 1) : entityId;
            }
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            if (button == 0) {
                this.openEditScreen();
                return true;
            }
            return false;
        }

        public void renderTooltip(GuiGraphics graphics, int mouseX, int mouseY) {
            List<Component> tooltipLines = this.getTooltipLines();
            if (tooltipLines.isEmpty()) {
                return;
            }
            Font font = Minecraft.m_91087_().f_91062_;
            int guiW = graphics.m_280182_();
            int guiH = graphics.m_280206_();
            int maxLineWidth = 0;
            for (Component c : tooltipLines) {
                int w = font.m_92852_((FormattedText)c);
                if (w <= maxLineWidth) continue;
                maxLineWidth = w;
            }
            int lineHeight = 10;
            int padding = 8;
            int tooltipHeight = padding + tooltipLines.size() * lineHeight;
            int tooltipX = mouseX + 12;
            int tooltipY = mouseY - 12;
            if (tooltipX + maxLineWidth + padding > guiW) {
                tooltipX = Math.max(8, mouseX - 12 - maxLineWidth - padding);
            }
            if (tooltipY + tooltipHeight > guiH) {
                tooltipY = Math.max(8, guiH - tooltipHeight - 8);
            }
            if (tooltipY < 8) {
                tooltipY = mouseY + 12;
            }
            graphics.m_280666_(font, tooltipLines, tooltipX, tooltipY);
        }

        private List<Component> getTooltipLines() {
            ArrayList<Component> tooltip = new ArrayList<Component>();
            Object object = this.item;
            if (object instanceof ConfigListScreen.EntityConfigItem) {
                ConfigListScreen.EntityConfigItem entityItem = (ConfigListScreen.EntityConfigItem)object;
                config = entityItem.getConfig();
                tooltip.add((Component)Component.m_237113_((String)("\u00a76\u00a7l" + entityItem.getDisplayName())));
                tooltip.add((Component)Component.m_237113_((String)("\u00a77ID: \u00a7f" + entityItem.getId())));
                tooltip.add((Component)Component.m_237113_((String)""));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.ezvcsurvival.configuration"));
                tooltip.add((Component)Component.m_237110_((String)"tooltip.ezvcsurvival.enabled", (Object[])new Object[]{((EntityVoiceConfig.EntityConfig)config).enabled ? Component.m_237115_((String)"gui.ezvcsurvival.enabled") : Component.m_237115_((String)"gui.ezvcsurvival.disabled")}));
                tooltip.add((Component)Component.m_237110_((String)"tooltip.ezvcsurvival.speed", (Object[])new Object[]{Component.m_237113_((String)("\u00a7e" + ((EntityVoiceConfig.EntityConfig)config).speed))}));
                tooltip.add((Component)Component.m_237110_((String)"tooltip.ezvcsurvival.range", (Object[])new Object[]{Component.m_237113_((String)("\u00a7e" + ((EntityVoiceConfig.EntityConfig)config).range))}));
                tooltip.add((Component)Component.m_237110_((String)"tooltip.ezvcsurvival.threshold", (Object[])new Object[]{Component.m_237113_((String)("\u00a7e" + ((EntityVoiceConfig.EntityConfig)config).threshold))}));
            } else {
                config = this.item;
                if (config instanceof ConfigListScreen.SoundConfigItem) {
                    ConfigListScreen.SoundConfigItem soundItem = (ConfigListScreen.SoundConfigItem)config;
                    config = soundItem.getConfig();
                    tooltip.add((Component)Component.m_237113_((String)("\u00a76\u00a7lSound: \u00a7f" + soundItem.getId())));
                    tooltip.add((Component)Component.m_237113_((String)""));
                    tooltip.add((Component)Component.m_237115_((String)"tooltip.ezvcsurvival.configuration"));
                    tooltip.add((Component)Component.m_237110_((String)"tooltip.ezvcsurvival.enabled", (Object[])new Object[]{((GeneralSoundsConfig.SoundEntry)config).enabled ? Component.m_237115_((String)"gui.ezvcsurvival.enabled") : Component.m_237115_((String)"gui.ezvcsurvival.disabled")}));
                    tooltip.add((Component)Component.m_237110_((String)"tooltip.ezvcsurvival.speed_multiplier", (Object[])new Object[]{Component.m_237113_((String)("\u00a7e" + ((GeneralSoundsConfig.SoundEntry)config).speed_multiplier))}));
                    tooltip.add((Component)Component.m_237110_((String)"tooltip.ezvcsurvival.range_multiplier", (Object[])new Object[]{Component.m_237113_((String)("\u00a7e" + ((GeneralSoundsConfig.SoundEntry)config).range_multiplier))}));
                } else {
                    config = this.item;
                    if (config instanceof ConfigListScreen.EntityReactionItem) {
                        ConfigListScreen.EntityReactionItem entityItem = (ConfigListScreen.EntityReactionItem)config;
                        reaction = entityItem.reaction();
                        String entityName = this.getEntityDisplayName(entityItem.id());
                        tooltip.add((Component)Component.m_237113_((String)("\u00a76\u00a7l" + entityName)));
                        tooltip.add((Component)Component.m_237113_((String)("\u00a77ID: \u00a7f" + entityItem.id())));
                        tooltip.add((Component)Component.m_237113_((String)""));
                        tooltip.add((Component)Component.m_237115_((String)"tooltip.ezvcsurvival.sound_reaction"));
                        tooltip.add((Component)Component.m_237110_((String)"tooltip.ezvcsurvival.enabled", (Object[])new Object[]{((GeneralSoundsConfig.Reaction)reaction).enabled ? Component.m_237115_((String)"gui.ezvcsurvival.enabled") : Component.m_237115_((String)"gui.ezvcsurvival.disabled")}));
                        tooltip.add((Component)Component.m_237110_((String)"tooltip.ezvcsurvival.speed", (Object[])new Object[]{Component.m_237113_((String)("\u00a7e" + ((GeneralSoundsConfig.Reaction)reaction).speed))}));
                        tooltip.add((Component)Component.m_237110_((String)"tooltip.ezvcsurvival.range", (Object[])new Object[]{Component.m_237113_((String)("\u00a7e" + ((GeneralSoundsConfig.Reaction)reaction).range))}));
                    } else {
                        reaction = this.item;
                        if (reaction instanceof ConfigListScreen.GunfireEntityItem) {
                            ConfigListScreen.GunfireEntityItem entityItem = (ConfigListScreen.GunfireEntityItem)reaction;
                            reaction = entityItem.reaction();
                            String entityName = this.getEntityDisplayName(entityItem.id());
                            tooltip.add((Component)Component.m_237113_((String)("\u00a76\u00a7l" + entityName)));
                            tooltip.add((Component)Component.m_237113_((String)("\u00a77ID: \u00a7f" + entityItem.id())));
                            tooltip.add((Component)Component.m_237113_((String)""));
                            tooltip.add((Component)Component.m_237115_((String)"tooltip.ezvcsurvival.gunfire_reaction"));
                            tooltip.add((Component)Component.m_237110_((String)"tooltip.ezvcsurvival.enabled", (Object[])new Object[]{((GunfireConfig.Reaction)reaction).enabled ? Component.m_237115_((String)"gui.ezvcsurvival.enabled") : Component.m_237115_((String)"gui.ezvcsurvival.disabled")}));
                            tooltip.add((Component)Component.m_237110_((String)"tooltip.ezvcsurvival.speed", (Object[])new Object[]{Component.m_237113_((String)("\u00a7e" + ((GunfireConfig.Reaction)reaction).speed))}));
                            tooltip.add((Component)Component.m_237110_((String)"tooltip.ezvcsurvival.range", (Object[])new Object[]{Component.m_237113_((String)("\u00a7e" + ((GunfireConfig.Reaction)reaction).range))}));
                        }
                    }
                }
            }
            return tooltip;
        }

        private void openEditScreen() {
            ConfigEditScreen.EditType editType = null;
            String elementName = "";
            if (this.item instanceof ConfigListScreen.EntityConfigItem) {
                editType = ConfigEditScreen.EditType.ENTITY_CONFIG;
                elementName = ((ConfigListScreen.EntityConfigItem)this.item).getDisplayName();
            } else if (this.item instanceof ConfigListScreen.SoundConfigItem) {
                editType = ConfigEditScreen.EditType.GENERAL_SOUND_CONFIG;
                elementName = ((ConfigListScreen.SoundConfigItem)this.item).getId();
            } else if (this.item instanceof ConfigListScreen.EntityReactionItem) {
                editType = ConfigEditScreen.EditType.GENERAL_SOUND_ENTITY;
                elementName = this.getEntityDisplayName(((ConfigListScreen.EntityReactionItem)this.item).id());
            } else if (this.item instanceof ConfigListScreen.GunfireEntityItem) {
                editType = ConfigEditScreen.EditType.GUNFIRE_ENTITY;
                elementName = this.getEntityDisplayName(((ConfigListScreen.GunfireEntityItem)this.item).id());
            }
            if (editType != null) {
                String elementId = this.getElementId();
                Minecraft.m_91087_().m_91152_((Screen)new ConfigEditScreen(ConfigListWidget.this.parent, editType, elementId, elementName));
            }
        }

        private String getElementId() {
            if (this.item instanceof ConfigListScreen.EntityConfigItem) {
                return ((ConfigListScreen.EntityConfigItem)this.item).getId();
            }
            if (this.item instanceof ConfigListScreen.SoundConfigItem) {
                return ((ConfigListScreen.SoundConfigItem)this.item).getId();
            }
            if (this.item instanceof ConfigListScreen.EntityReactionItem) {
                return ((ConfigListScreen.EntityReactionItem)this.item).id();
            }
            if (this.item instanceof ConfigListScreen.GunfireEntityItem) {
                return ((ConfigListScreen.GunfireEntityItem)this.item).id();
            }
            return "";
        }

        @NotNull
        public Component m_142172_() {
            Object object = this.item;
            if (object instanceof ConfigListScreen.EntityConfigItem) {
                ConfigListScreen.EntityConfigItem entityItem = (ConfigListScreen.EntityConfigItem)object;
                return Component.m_237113_((String)entityItem.getDisplayName());
            }
            object = this.item;
            if (object instanceof ConfigListScreen.SoundConfigItem) {
                ConfigListScreen.SoundConfigItem soundItem = (ConfigListScreen.SoundConfigItem)object;
                return Component.m_237113_((String)("Sound: " + soundItem.getId()));
            }
            object = this.item;
            if (object instanceof ConfigListScreen.EntityReactionItem) {
                ConfigListScreen.EntityReactionItem entityItem = (ConfigListScreen.EntityReactionItem)object;
                return Component.m_237113_((String)this.getEntityDisplayName(entityItem.id()));
            }
            object = this.item;
            if (object instanceof ConfigListScreen.GunfireEntityItem) {
                ConfigListScreen.GunfireEntityItem entityItem = (ConfigListScreen.GunfireEntityItem)object;
                return Component.m_237113_((String)this.getEntityDisplayName(entityItem.id()));
            }
            return Component.m_237113_((String)"Unknown Item");
        }
    }

    public static abstract class Entry
    extends ObjectSelectionList.Entry<Entry> {
    }
}

