/*
 * Decompiled with CFR 0.152.
 */
package com.armilp.ezvcsurvival.client.gui.list;

import com.armilp.ezvcsurvival.client.gui.ConfigEditorScreen;
import com.armilp.ezvcsurvival.client.gui.list.ConfigListWidget;
import com.armilp.ezvcsurvival.config.EntityVoiceConfig;
import com.armilp.ezvcsurvival.config.GeneralSoundsConfig;
import com.armilp.ezvcsurvival.config.GunfireConfig;
import com.armilp.ezvcsurvival.network.EZVCNetwork;
import com.armilp.ezvcsurvival.network.UpdateConfigPacket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraftforge.registries.ForgeRegistries;

public class ConfigListScreen
extends Screen {
    private final ListType listType;
    private final Screen parent;
    private EditBox searchBox;
    private String searchQuery = "";
    private Button clearSearchButton;
    private Button backButton;
    private Button toggleViewButton;
    private Button toggleEnabledButton;
    private ConfigListWidget list;
    private List<Object> items;
    private boolean showingSounds = true;
    private static final int MIN_WIDTH = 400;
    private static final int MIN_BUTTON_WIDTH = 60;
    private static final int MAX_BUTTON_WIDTH = 120;
    private static final int BUTTON_HEIGHT = 20;
    private static final int SEARCH_HEIGHT = 20;
    private static final int VERTICAL_SPACING = 6;
    private static final int HORIZONTAL_SPACING = 6;

    public ConfigListScreen(ListType listType, Screen parent) {
        super((Component)Component.m_237115_((String)ConfigListScreen.getTitleKey(listType)));
        this.listType = listType;
        this.parent = parent;
        this.items = new ArrayList<Object>();
        if (this.listType == ListType.GUNFIRE_CONFIG) {
            this.showingSounds = false;
        } else if (this.listType == ListType.GENERAL_SOUNDS_CONFIG) {
            this.showingSounds = false;
        }
    }

    private static String getTitleKey(ListType type) {
        switch (type) {
            case ENTITY_CONFIG: {
                return "screen.ezvcsurvival.entity_config_list";
            }
            case GENERAL_SOUNDS_CONFIG: {
                return "screen.ezvcsurvival.general_sounds_config_list";
            }
            case GUNFIRE_CONFIG: {
                return "screen.ezvcsurvival.gunfire_config_list";
            }
        }
        return "screen.ezvcsurvival.config_list";
    }

    protected void m_7856_() {
        int leftMargin;
        super.m_7856_();
        int usableWidth = Math.max(this.f_96543_ - 40, 400);
        int rightMargin = leftMargin = (this.f_96543_ - usableWidth) / 2;
        int topRowY = 20;
        int searchRowY = topRowY + 20 + 12;
        int listStartY = searchRowY + 20 + 18;
        int availableButtonWidth = usableWidth;
        int buttonCount = this.getButtonCount();
        int buttonWidth = Math.min(120, Math.max(60, (availableButtonWidth - (buttonCount - 1) * 6) / buttonCount));
        this.backButton = Button.m_253074_((Component)Component.m_237115_((String)"button.ezvcsurvival.back"), b -> Minecraft.m_91087_().m_91152_((Screen)(this.parent != null ? this.parent : new ConfigEditorScreen()))).m_252987_(leftMargin, topRowY, buttonWidth, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.backButton);
        int currentX = leftMargin + buttonWidth + 6;
        if (this.listType == ListType.GENERAL_SOUNDS_CONFIG) {
            this.toggleViewButton = Button.m_253074_((Component)Component.m_237115_((String)(this.showingSounds ? "button.ezvcsurvival.show_entities" : "button.ezvcsurvival.show_sounds")), b -> this.toggleView()).m_252987_(currentX, topRowY, buttonWidth, 20).m_253136_();
            this.m_142416_((GuiEventListener)this.toggleViewButton);
            currentX += buttonWidth + 6;
        }
        if (this.listType == ListType.GENERAL_SOUNDS_CONFIG || this.listType == ListType.GUNFIRE_CONFIG || this.listType == ListType.ENTITY_CONFIG) {
            this.toggleEnabledButton = Button.m_253074_((Component)this.getToggleEnabledMessage(), b -> this.toggleEnabled()).m_252987_(currentX, topRowY, buttonWidth, 20).m_253136_();
            this.m_142416_((GuiEventListener)this.toggleEnabledButton);
            currentX += buttonWidth + 6;
        }
        int searchWidth = Math.min(300, usableWidth - 100);
        this.searchBox = new EditBox(this.f_96547_, leftMargin, searchRowY, searchWidth, 20, (Component)Component.m_237115_((String)"textbox.ezvcsurvival.search"));
        this.searchBox.m_94151_(this::onSearchChanged);
        this.searchBox.m_94199_(50);
        this.m_142416_((GuiEventListener)this.searchBox);
        this.clearSearchButton = Button.m_253074_((Component)Component.m_237113_((String)"\u2715"), b -> this.searchBox.m_94144_("")).m_252987_(leftMargin + searchWidth + 6, searchRowY, 20, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.clearSearchButton);
        this.list = new ConfigListWidget(this, this.f_96541_, this.f_96543_, this.f_96544_, listStartY, this.f_96544_ - 40, 28);
        this.m_7787_((GuiEventListener)this.list);
        if (this.items == null || this.items.isEmpty()) {
            this.loadData();
        }
        this.updateList();
    }

    private int getButtonCount() {
        int count = 1;
        if (this.listType == ListType.GENERAL_SOUNDS_CONFIG) {
            count += 2;
        } else if (this.listType == ListType.GUNFIRE_CONFIG || this.listType == ListType.ENTITY_CONFIG) {
            ++count;
        }
        return count;
    }

    private void loadData() {
        this.items = new ArrayList<Object>();
        switch (this.listType) {
            case ENTITY_CONFIG: {
                this.loadEntityConfigs();
                break;
            }
            case GENERAL_SOUNDS_CONFIG: {
                if (this.showingSounds) {
                    this.loadGeneralSoundConfigs();
                    break;
                }
                this.loadGeneralEntityConfigs();
                break;
            }
            case GUNFIRE_CONFIG: {
                this.loadGunfireEntityConfigs();
            }
        }
    }

    private void loadEntityConfigs() {
        this.items.clear();
        for (EntityType type : ForgeRegistries.ENTITY_TYPES) {
            MobCategory category = type.m_20674_();
            if (category == MobCategory.MISC) continue;
            String id = Objects.requireNonNull(ForgeRegistries.ENTITY_TYPES.getKey((Object)type)).toString();
            EntityVoiceConfig.EntityConfig config = EntityVoiceConfig.get(id);
            if (config == null) {
                config = EntityVoiceConfig.EntityConfig.defaultFor(type);
                EntityVoiceConfig.set(id, config);
            }
            this.items.add(new EntityConfigItem(id, type, config));
        }
        this.items.sort(Comparator.comparing(item -> ((EntityConfigItem)item).getDisplayName()));
    }

    private void loadGeneralSoundConfigs() {
        this.items.clear();
        Map<String, GeneralSoundsConfig.SoundEntry> soundConfigs = GeneralSoundsConfig.getSounds();
        for (SoundEvent sound : ForgeRegistries.SOUND_EVENTS) {
            String id = Objects.requireNonNull(ForgeRegistries.SOUND_EVENTS.getKey((Object)sound)).toString();
            GeneralSoundsConfig.SoundEntry config = soundConfigs.get(id);
            if (config == null) {
                config = new GeneralSoundsConfig.SoundEntry(false, 1.0, 1.0);
                GeneralSoundsConfig.setSoundEntry(id, false, 1.0, 1.0);
            }
            this.items.add(new SoundConfigItem(id, sound, config, false));
        }
        this.items.sort(Comparator.comparing(item -> ((SoundConfigItem)item).getId()));
    }

    private void loadGeneralEntityConfigs() {
        this.items.clear();
        Map<String, GeneralSoundsConfig.Reaction> entityConfigs = GeneralSoundsConfig.getMobReactions();
        if (entityConfigs == null) {
            entityConfigs = Collections.emptyMap();
        }
        for (EntityType type : ForgeRegistries.ENTITY_TYPES) {
            MobCategory category = type.m_20674_();
            if (category == MobCategory.MISC) continue;
            String id = Objects.requireNonNull(ForgeRegistries.ENTITY_TYPES.getKey((Object)type)).toString();
            GeneralSoundsConfig.Reaction reaction = entityConfigs.get(id);
            if (reaction == null) {
                reaction = new GeneralSoundsConfig.Reaction(true, 1.0, category == MobCategory.MONSTER ? 60.0 : 50.0);
                GeneralSoundsConfig.setMobReaction(id, true, 1.0, category == MobCategory.MONSTER ? 60.0 : 50.0);
            }
            this.items.add(new EntityReactionItem(id, reaction));
        }
        this.items.sort(Comparator.comparing(item -> ((EntityReactionItem)item).id()));
    }

    private void loadGunfireEntityConfigs() {
        this.items.clear();
        Map<String, GunfireConfig.Reaction> entityConfigs = GunfireConfig.getMobReactions();
        for (EntityType type : ForgeRegistries.ENTITY_TYPES) {
            MobCategory category = type.m_20674_();
            if (category == MobCategory.MISC) continue;
            String id = Objects.requireNonNull(ForgeRegistries.ENTITY_TYPES.getKey((Object)type)).toString();
            GunfireConfig.Reaction reaction = entityConfigs.get(id);
            if (reaction == null) {
                reaction = new GunfireConfig.Reaction(true, 1.0, category == MobCategory.MONSTER ? 50.0 : 40.0);
                GunfireConfig.setMobReaction(id, true, 1.0, category == MobCategory.MONSTER ? 50.0 : 40.0);
            }
            this.items.add(new GunfireEntityItem(id, reaction));
        }
        this.items.sort(Comparator.comparing(item -> ((GunfireEntityItem)item).id()));
    }

    private void toggleView() {
        if (this.listType != ListType.GENERAL_SOUNDS_CONFIG) {
            return;
        }
        this.showingSounds = !this.showingSounds;
        this.toggleViewButton.m_93666_((Component)Component.m_237115_((String)(this.showingSounds ? "button.ezvcsurvival.show_entities" : "button.ezvcsurvival.show_sounds")));
        this.safeRefresh();
    }

    private void toggleEnabled() {
        switch (this.listType) {
            case ENTITY_CONFIG: {
                boolean newEntityState;
                EntityVoiceConfig.ROOT.enabled = newEntityState = !EntityVoiceConfig.isEnabled();
                EntityVoiceConfig.persist();
                EZVCNetwork.INSTANCE.sendToServer((Object)new UpdateConfigPacket(UpdateConfigPacket.ConfigType.ENTITY_VOICE, "global", newEntityState, 1.0, 1.0));
                break;
            }
            case GENERAL_SOUNDS_CONFIG: {
                boolean newGeneralState;
                GeneralSoundsConfig.ROOT.enabled = newGeneralState = !GeneralSoundsConfig.isEnabled();
                GeneralSoundsConfig.persist();
                EZVCNetwork.INSTANCE.sendToServer((Object)new UpdateConfigPacket(UpdateConfigPacket.ConfigType.GENERAL_SOUND, "global", newGeneralState, 1.0, 1.0));
                break;
            }
            case GUNFIRE_CONFIG: {
                boolean newGunfireState;
                GunfireConfig.ROOT.enabled = newGunfireState = !GunfireConfig.isEnabled();
                GunfireConfig.persist();
                EZVCNetwork.INSTANCE.sendToServer((Object)new UpdateConfigPacket(UpdateConfigPacket.ConfigType.GUNFIRE_SOUND, "global", newGunfireState, 1.0, 1.0));
            }
        }
        this.toggleEnabledButton.m_93666_(this.getToggleEnabledMessage());
        this.safeRefresh();
    }

    private Component getToggleEnabledMessage() {
        boolean isEnabled = false;
        switch (this.listType) {
            case ENTITY_CONFIG: {
                isEnabled = EntityVoiceConfig.isEnabled();
                break;
            }
            case GENERAL_SOUNDS_CONFIG: {
                isEnabled = GeneralSoundsConfig.isEnabled();
                break;
            }
            case GUNFIRE_CONFIG: {
                isEnabled = GunfireConfig.isEnabled();
            }
        }
        return Component.m_237115_((String)(isEnabled ? "button.ezvcsurvival.disable_all" : "button.ezvcsurvival.enable_all"));
    }

    public void refreshData() {
        this.safeRefresh();
        EZVCNetwork.INSTANCE.sendToServer((Object)new UpdateConfigPacket(UpdateConfigPacket.ConfigType.GENERAL_SOUND, "refresh", true, 1.0, 1.0));
    }

    public void updateList() {
        this.list.clear();
        ArrayList<Object> filtered = new ArrayList<Object>();
        for (Object item : this.items) {
            String searchableText = this.getSearchableText(item).toLowerCase();
            if (!this.searchQuery.isEmpty() && !searchableText.contains(this.searchQuery)) continue;
            filtered.add(item);
        }
        for (Object item : filtered) {
            this.list.addItem(item);
        }
    }

    private String getSearchableText(Object item) {
        if (item instanceof EntityConfigItem) {
            return ((EntityConfigItem)item).getDisplayName() + " " + ((EntityConfigItem)item).getId();
        }
        if (item instanceof SoundConfigItem) {
            return ((SoundConfigItem)item).getId();
        }
        if (item instanceof EntityReactionItem) {
            return ((EntityReactionItem)item).id();
        }
        if (item instanceof GunfireEntityItem) {
            return ((GunfireEntityItem)item).id();
        }
        return "";
    }

    private void onSearchChanged(String query) {
        this.searchQuery = query.trim().toLowerCase();
        this.updateList();
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(graphics);
        graphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 8, 0xFFFFFF);
        int titleWidth = this.f_96547_.m_92852_((FormattedText)this.f_96539_);
        int separatorY = 20;
        graphics.m_280509_(this.f_96543_ / 2 - titleWidth / 2 - 10, separatorY, this.f_96543_ / 2 + titleWidth / 2 + 10, separatorY + 1, 0x55FFFFFF);
        this.list.m_88315_(graphics, mouseX, mouseY, partialTick);
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
        this.searchBox.m_88315_(graphics, mouseX, mouseY, partialTick);
        if (this.searchBox.m_94155_().isEmpty() && !this.searchBox.m_93696_()) {
            graphics.m_280056_(this.f_96547_, this.searchBox.m_6035_().getString(), this.searchBox.m_252754_() + 4, this.searchBox.m_252907_() + 6, 0x888888, false);
        }
        int searchLabelY = this.searchBox.m_252907_() - 12;
        graphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"gui.ezvcsurvival.search"), this.searchBox.m_252754_(), searchLabelY, 0xCCCCCC, false);
        this.renderFooter(graphics);
        this.renderTooltips(graphics, mouseX, mouseY);
    }

    private void renderFooter(GuiGraphics graphics) {
        int footerY = this.f_96544_ - 30;
        int leftMargin = (this.f_96543_ - Math.max(this.f_96543_ - 40, 400)) / 2;
        Component count = this.getCountComponent();
        int countWidth = this.f_96547_.m_92852_((FormattedText)count);
        graphics.m_280614_(this.f_96547_, count, this.f_96543_ - countWidth - leftMargin, footerY, 0xAAAAAA, false);
        Component instructions = this.getInstructionsComponent();
        graphics.m_280614_(this.f_96547_, instructions, leftMargin, footerY, 0xCCCCCC, false);
    }

    private Component getCountComponent() {
        if (this.listType == ListType.ENTITY_CONFIG || this.listType == ListType.GUNFIRE_CONFIG) {
            return Component.m_237110_((String)"gui.ezvcsurvival.entity_count", (Object[])new Object[]{this.list.m_6702_().size()});
        }
        if (this.listType == ListType.GENERAL_SOUNDS_CONFIG) {
            if (this.showingSounds) {
                return Component.m_237110_((String)"gui.ezvcsurvival.sound_count", (Object[])new Object[]{this.list.m_6702_().size()});
            }
            return Component.m_237110_((String)"gui.ezvcsurvival.entity_count", (Object[])new Object[]{this.list.m_6702_().size()});
        }
        return Component.m_237110_((String)"gui.ezvcsurvival.entity_count", (Object[])new Object[]{this.list.m_6702_().size()});
    }

    private Component getInstructionsComponent() {
        if (this.listType == ListType.ENTITY_CONFIG || this.listType == ListType.GUNFIRE_CONFIG) {
            return Component.m_237115_((String)"gui.ezvcsurvival.click_to_edit_entity");
        }
        if (this.listType == ListType.GENERAL_SOUNDS_CONFIG) {
            if (this.showingSounds) {
                return Component.m_237115_((String)"gui.ezvcsurvival.click_to_edit_sound");
            }
            return Component.m_237115_((String)"gui.ezvcsurvival.click_to_edit_entity");
        }
        return Component.m_237115_((String)"gui.ezvcsurvival.click_to_edit_entity");
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (this.searchBox.m_5953_(mouseX, mouseY)) {
            return false;
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.f_96541_.m_91152_((Screen)(this.parent != null ? this.parent : new ConfigEditorScreen()));
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public void m_86600_() {
        super.m_86600_();
        this.searchBox.m_94120_();
    }

    public void onConfigUpdated() {
        this.loadData();
        this.updateList();
        switch (this.listType) {
            case ENTITY_CONFIG: {
                EntityVoiceConfig.persist();
                break;
            }
            case GENERAL_SOUNDS_CONFIG: {
                GeneralSoundsConfig.persist();
                break;
            }
            case GUNFIRE_CONFIG: {
                GunfireConfig.persist();
            }
        }
    }

    public void safeRefresh() {
        if (this.f_96541_ != null && this.f_96541_.f_91080_ == this) {
            this.loadData();
            this.updateList();
        }
    }

    private void renderTooltips(GuiGraphics graphics, int mouseX, int mouseY) {
        if (this.list == null) {
            return;
        }
        if (!this.list.m_5953_(mouseX, mouseY)) {
            return;
        }
        int index = this.list.getEntryIndexAt(mouseX, mouseY);
        if (index < 0 || index >= this.list.m_6702_().size()) {
            return;
        }
        ConfigListWidget.Entry entry = (ConfigListWidget.Entry)((Object)this.list.m_6702_().get(index));
        if (entry instanceof ConfigListWidget.UniversalEntry) {
            ConfigListWidget.UniversalEntry universalEntry = (ConfigListWidget.UniversalEntry)entry;
            universalEntry.renderTooltip(graphics, mouseX, mouseY);
        }
    }

    public static enum ListType {
        ENTITY_CONFIG,
        GENERAL_SOUNDS_CONFIG,
        GUNFIRE_CONFIG;

    }

    public static class EntityConfigItem {
        private final String id;
        private final EntityType<?> type;
        private final EntityVoiceConfig.EntityConfig config;

        public EntityConfigItem(String id, EntityType<?> type, EntityVoiceConfig.EntityConfig config) {
            this.id = id;
            this.type = type;
            this.config = config;
        }

        public String getId() {
            return this.id;
        }

        public EntityVoiceConfig.EntityConfig getConfig() {
            return this.config;
        }

        public String getDisplayName() {
            return this.type.m_20676_().getString();
        }
    }

    public static class SoundConfigItem {
        private final String id;
        private final SoundEvent sound;
        private final GeneralSoundsConfig.SoundEntry config;
        private final boolean isPriority;

        public SoundConfigItem(String id, SoundEvent sound, GeneralSoundsConfig.SoundEntry config, boolean isPriority) {
            this.id = id;
            this.sound = sound;
            this.config = config;
            this.isPriority = isPriority;
        }

        public String getId() {
            return this.id;
        }

        public SoundEvent getSound() {
            return this.sound;
        }

        public GeneralSoundsConfig.SoundEntry getConfig() {
            return this.config;
        }
    }

    public record EntityReactionItem(String id, GeneralSoundsConfig.Reaction reaction) {
    }

    public record GunfireEntityItem(String id, GunfireConfig.Reaction reaction) {
    }
}

