/*
 * Decompiled with CFR 0.152.
 */
package com.armilp.ezvcsurvival;

import com.armilp.ezvcsurvival.compat.guns.GunFireListener;
import com.armilp.ezvcsurvival.compat.mobs.spore.SporeCompatLoader;
import com.armilp.ezvcsurvival.config.EntityVoiceConfig;
import com.armilp.ezvcsurvival.config.GeneralSoundsConfig;
import com.armilp.ezvcsurvival.config.GunfireConfig;
import com.armilp.ezvcsurvival.config.SoundConfig;
import com.armilp.ezvcsurvival.config.VoiceConfig;
import com.armilp.ezvcsurvival.network.EZVCNetwork;
import com.armilp.ezvcsurvival.sculk.ModGameEvent;
import com.mojang.logging.LogUtils;
import com.tacz.guns.resource.CommonAssetsManager;
import com.tacz.guns.resource.index.CommonGunIndex;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;

@Mod(value="ezvcsurvival")
public class EZVCSurvival {
    public static final String MOD_ID = "ezvcsurvival";
    public static final Logger LOGGER = LogUtils.getLogger();

    public EZVCSurvival() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        EZVCNetwork.registerPackets();
        if (ModList.get().isLoaded("tacz")) {
            MinecraftForge.EVENT_BUS.register(GunFireListener.class);
        }
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)VoiceConfig.CONFIG, "ezvcsurvival/voices.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)SoundConfig.SPEC, "ezvcsurvival/sounds.toml");
        modEventBus.addListener(this::commonSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        EntityVoiceConfig.init();
        GeneralSoundsConfig.init();
        GunfireConfig.init();
        SoundConfig.loadConfigs();
        SporeCompatLoader.init();
        event.enqueueWork(() -> ModGameEvent.register());
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        if (ModList.get().isLoaded("tacz")) {
            this.registerGunIndexes();
        }
    }

    private void registerGunIndexes() {
        try {
            CommonAssetsManager assets = CommonAssetsManager.getInstance();
            if (assets == null) {
                LOGGER.warn("[EZVCSurvival] CommonAssetsManager is null! Gun types may not be detected correctly.");
                return;
            }
            int count = 0;
            for (Map.Entry entry : assets.getAllGuns()) {
                ResourceLocation gunId = (ResourceLocation)entry.getKey();
                CommonGunIndex index = (CommonGunIndex)entry.getValue();
                GunFireListener.CommonGunIndexRegistry.registerCommonGunIndex(gunId, index);
                ++count;
                LOGGER.debug("[EZVCSurvival] Registered gun: {} -> type: {}", (Object)gunId, (Object)index.getType());
            }
            LOGGER.info("[EZVCSurvival] Successfully registered {} gun indexes from TaCZ", (Object)count);
        }
        catch (Exception e) {
            LOGGER.error("[EZVCSurvival] Failed to register gun indexes", (Throwable)e);
        }
    }
}

