/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdbosses;

import com.finderfeed.fdbosses.BossUtil;
import com.finderfeed.fdbosses.FDBosses;
import com.finderfeed.fdbosses.content.data_components.ItemCoreDataComponent;
import com.finderfeed.fdbosses.content.entities.IEffectImmune;
import com.finderfeed.fdbosses.content.entities.base.BossSpawnerEntity;
import com.finderfeed.fdbosses.content.entities.chesed_boss.chesed_mini_ray.ChesedMiniRay;
import com.finderfeed.fdbosses.content.entities.malkuth_boss.MalkuthAttackType;
import com.finderfeed.fdbosses.content.entities.malkuth_boss.MalkuthWeaknessHandler;
import com.finderfeed.fdbosses.content.entities.malkuth_boss.packets.SetClientMalkuthWeaknessAmountPacket;
import com.finderfeed.fdbosses.content.items.WeaponCoreItem;
import com.finderfeed.fdbosses.content.projectiles.MalkuthPlayerFireIceBall;
import com.finderfeed.fdbosses.init.BossConfigs;
import com.finderfeed.fdbosses.init.BossDamageSources;
import com.finderfeed.fdbosses.init.BossEffects;
import com.finderfeed.fdlib.network.FDPacketHandler;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Pattern;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.ExplosionEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkDirection;

@Mod.EventBusSubscriber(modid="fdbosses", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class BossEvents {
    public static final TagKey<MobEffect> NOT_CURABLE_EFFECTS = TagKey.m_203882_((ResourceKey)Registries.f_256929_, (ResourceLocation)FDBosses.location("not_curable"));

    @SubscribeEvent
    public static void effectApplicable(MobEffectEvent.Applicable event) {
        if (event.getEntity() instanceof IEffectImmune) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public static void playerEnterWorld(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            FDPacketHandler.INSTANCE.sendTo((Object)new SetClientMalkuthWeaknessAmountPacket(MalkuthWeaknessHandler.getCurrentWeaknessLevel((Player)serverPlayer)), serverPlayer.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
        }
    }

    @SubscribeEvent
    public static void respawn(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            FDPacketHandler.INSTANCE.sendTo((Object)new SetClientMalkuthWeaknessAmountPacket(MalkuthWeaknessHandler.getCurrentWeaknessLevel((Player)serverPlayer)), serverPlayer.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
        }
    }

    @SubscribeEvent
    public static void preventArenaDestruction(BlockEvent.BreakEvent event) {
        LevelAccessor level = event.getLevel();
        if (!level.m_5776_()) {
            BlockState state;
            boolean v;
            BlockPos pos = event.getPos();
            List spawners = level.m_45976_(BossSpawnerEntity.class, new AABB(-100.0, -100.0, -100.0, 100.0, 100.0, 100.0).m_82383_(pos.m_252807_()));
            if (!spawners.isEmpty() && (v = BossEvents.checkBlockStateAllowedToBreakInArena(state = level.m_8055_(pos)))) {
                return;
            }
            Component message = null;
            for (BossSpawnerEntity bossSpawnerEntity : spawners) {
                if (bossSpawnerEntity.canInteractWithBlockPos(pos)) continue;
                message = bossSpawnerEntity.onArenaDestructionMessage();
                event.setCanceled(true);
                break;
            }
            if (event.isCanceled() && event.getPlayer() != null && message != null) {
                event.getPlayer().m_213846_(message);
            }
        }
    }

    public static boolean checkBlockStateAllowedToBreakInArena(BlockState blockState) {
        List<Pattern> patterns = BossConfigs.BOSS_CONFIG.get().blocksAllowedToBreakInArenaPatterns;
        for (Pattern pattern : patterns) {
            ResourceLocation location = BuiltInRegistries.f_256975_.m_7981_((Object)blockState.m_60734_());
            String string = location.toString();
            boolean test = pattern.asPredicate().test(string);
            if (!test) continue;
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public static void preventArenaDestruction(BlockEvent.EntityPlaceEvent event) {
        LevelAccessor level = event.getLevel();
        if (!level.m_5776_()) {
            Entity entity;
            BlockPos pos = event.getPos();
            List spawners = level.m_45976_(BossSpawnerEntity.class, new AABB(-100.0, -100.0, -100.0, 100.0, 100.0, 100.0).m_82383_(pos.m_252807_()));
            Component message = null;
            for (BossSpawnerEntity bossSpawnerEntity : spawners) {
                if (bossSpawnerEntity.canInteractWithBlockPos(pos)) continue;
                message = bossSpawnerEntity.onArenaDestructionMessage();
                event.setCanceled(true);
                break;
            }
            if (event.isCanceled() && (entity = event.getEntity()) instanceof Player) {
                Player player = (Player)entity;
                if (message != null) {
                    player.m_213846_(message);
                }
            }
        }
    }

    @SubscribeEvent
    public static void preventArenaDestruction(ExplosionEvent.Detonate event) {
        Level level = event.getLevel();
        if (!level.m_5776_()) {
            Object object;
            List list = event.getAffectedBlocks();
            ListIterator blockPosIterator = list.listIterator();
            List spawners = level.m_45976_(BossSpawnerEntity.class, new AABB(-100.0, -100.0, -100.0, 100.0, 100.0, 100.0).m_82383_(event.getExplosion().getPosition()));
            Component message = null;
            block0: while (blockPosIterator.hasNext()) {
                BlockPos pos = (BlockPos)blockPosIterator.next();
                object = spawners.iterator();
                while (object.hasNext()) {
                    BossSpawnerEntity bossSpawnerEntity = (BossSpawnerEntity)((Object)object.next());
                    if (bossSpawnerEntity.canInteractWithBlockPos(pos)) continue;
                    message = bossSpawnerEntity.onArenaDestructionMessage();
                    blockPosIterator.remove();
                    continue block0;
                }
            }
            if (message != null && (object = event.getExplosion().m_252906_()) instanceof Player) {
                Player player = (Player)object;
                player.m_213846_(message);
            }
        }
    }

    @SubscribeEvent
    public static void livingDeathEvent(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            DamageSource source;
            Player player = (Player)livingEntity;
            if (!player.m_9236_().f_46443_ && event.getSource() != null && (source = event.getSource()).m_276093_(BossDamageSources.CHESED_LOR_EASTER_EGG_ATTACK)) {
                ItemStack itemStack = Items.f_42517_.m_7968_();
                itemStack.m_41714_((Component)player.m_7755_().m_6881_());
                ItemEntity item = new ItemEntity(player.m_9236_(), player.m_20185_(), player.m_20186_(), player.m_20189_(), itemStack);
                player.m_9236_().m_7967_((Entity)item);
            }
        }
    }

    @SubscribeEvent
    public static void rightClickItem(PlayerInteractEvent.RightClickItem event) {
        ItemStack itemStack = event.getItemStack();
        Player player = event.getEntity();
        Level level = player.m_9236_();
        ItemCoreDataComponent.CoreType itemCore = WeaponCoreItem.getItemCore(itemStack);
        if (!level.f_46443_ && itemCore != null && itemCore == ItemCoreDataComponent.CoreType.FIRE_AND_ICE) {
            Vec3 look = player.m_20154_();
            float speed = 4.0f;
            Vec3 speedVec = look.m_82542_((double)speed, (double)speed, (double)speed);
            MalkuthAttackType attackType = player.m_6047_() ? MalkuthAttackType.ICE : MalkuthAttackType.FIRE;
            MalkuthPlayerFireIceBall.summon((LivingEntity)player, player.m_146892_().m_82520_(0.0, -0.25, 0.0).m_82549_(look), speedVec, attackType, itemStack);
            if (!player.m_7500_()) {
                int cooldown = BossConfigs.BOSS_CONFIG.get().itemConfig.playerMalkuthFireballAbilityCooldown;
                player.m_36335_().m_41524_(itemStack.m_41720_(), cooldown);
            }
            player.m_21011_(event.getHand(), true);
        }
    }

    @SubscribeEvent
    public static void onEntityAttack(AttackEntityEvent event) {
        Entity entity;
        Player player = event.getEntity();
        ItemStack itemStack = player.m_21205_();
        ItemCoreDataComponent.CoreType core = WeaponCoreItem.getItemCore(itemStack);
        if (!player.m_9236_().f_46443_ && (entity = event.getTarget()) instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (core != null) {
                Item item = itemStack.m_41720_();
                float power = player.m_36403_(0.5f);
                if (power > 0.5f && core == ItemCoreDataComponent.CoreType.LIGHTNING && BossUtil.itemContainsModifierForAttribute(itemStack, Attributes.f_22281_)) {
                    float p = Mth.m_14036_((float)(BossConfigs.BOSS_CONFIG.get().itemConfig.chanceToSummonLightningStrike / 100.0f), (float)0.0f, (float)1.0f);
                    RandomSource randomSource = livingEntity.m_217043_();
                    float n = randomSource.m_188501_();
                    if (n < p) {
                        ChesedMiniRay.summon(player.m_9236_(), livingEntity, player.m_21205_(), (LivingEntity)player);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void deathEvent(LivingDropsEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            Level level = serverPlayer.m_9236_();
            Vec3 pos = serverPlayer.m_20182_();
            float radius = 50.0f;
            List spawners = level.m_6443_(BossSpawnerEntity.class, new AABB((double)(-radius), (double)(-radius), (double)(-radius), (double)radius, (double)radius, (double)radius).m_82383_(pos), bossSpawner -> !bossSpawner.isActive());
            for (BossSpawnerEntity spawner : spawners) {
                Vec3 itemsPos = spawner.getPlayerItemsDropPosition(pos);
                if (itemsPos == null) continue;
                for (ItemEntity itemEntity : event.getDrops()) {
                    itemEntity.m_146884_(itemsPos);
                    itemEntity.m_20256_(Vec3.f_82478_);
                }
            }
        }
    }

    @SubscribeEvent
    public static void livingDamageEvent(LivingHurtEvent event) {
        LivingEntity damager;
        DamageSource damageSource;
        Entity entity;
        LivingEntity livingEntity = event.getEntity();
        if (!livingEntity.m_9236_().f_46443_ && (entity = (damageSource = event.getSource()).m_7639_()) instanceof LivingEntity && (damager = (LivingEntity)entity).m_21023_((MobEffect)BossEffects.SHOCKED.get())) {
            float amount = event.getAmount();
            float p = Mth.m_14036_((float)(1.0f - BossConfigs.BOSS_CONFIG.get().effectConfig.shockDamageReductionPercent / 100.0f), (float)0.0f, (float)1.0f);
            event.setAmount(amount * p);
        }
    }
}

