/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.block.behavior;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Display;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CarpetBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeMod;
import org.jetbrains.annotations.Nullable;
import snownee.kiwi.customization.CustomFeatureTags;
import snownee.kiwi.customization.block.KBlockSettings;
import snownee.kiwi.customization.block.KBlockUtils;
import snownee.kiwi.customization.block.behavior.KSitCommonConfig;
import snownee.kiwi.customization.block.component.KBlockComponent;
import snownee.kiwi.mixin.customization.sit.EntityAccess;

public class SitManager {
    public static final Component ENTITY_NAME = Component.m_237113_((String)"Seat from Kiwi");
    public static final double VERTICAL_OFFSET = 0.23;

    public static void tick(Display.BlockDisplay display) {
        if (display.f_19797_ < 7) {
            return;
        }
        if (!display.m_20160_()) {
            display.m_146870_();
        }
        BlockPos pos = BlockPos.m_274561_((double)display.m_20185_(), (double)(display.m_20186_() + 0.23), (double)display.m_20189_());
        BlockState blockState = display.m_9236_().m_8055_(pos);
        if (!blockState.m_60713_(display.m_269134_().m_60734_())) {
            display.m_146870_();
        }
    }

    public static boolean sit(Player player, BlockHitResult hitResult) {
        BlockPos pos;
        if (!(!KSitCommonConfig.requireEmptyHand || player.m_21205_().m_41619_() && player.m_21206_().m_41619_())) {
            return false;
        }
        if (!KSitCommonConfig.allowClickBlockBottomToSit && hitResult.m_82434_() == Direction.DOWN) {
            return false;
        }
        if (player.m_36341_()) {
            return false;
        }
        Level level = player.m_9236_();
        BlockState blockState = level.m_8055_(pos = hitResult.m_82425_());
        if (!blockState.m_204336_(CustomFeatureTags.SITTABLE)) {
            return false;
        }
        Block block = blockState.m_60734_();
        if (block instanceof BedBlock) {
            ServerPlayer serverPlayer;
            if (((Boolean)blockState.m_61143_((Property)BedBlock.f_49441_)).booleanValue() || !BedBlock.m_49488_((Level)level)) {
                return false;
            }
            Direction direction = (Direction)blockState.m_61143_((Property)BedBlock.f_54117_);
            if (player instanceof ServerPlayer && (serverPlayer = (ServerPlayer)player).m_9116_(pos, direction)) {
                return false;
            }
        } else if (player.m_146892_().m_82557_(hitResult.m_82450_()) > Mth.m_144952_((double)(player.m_21133_((Attribute)ForgeMod.BLOCK_REACH.get()) * (double)KSitCommonConfig.sitActionReachDistanceRatio))) {
            return false;
        }
        if (!player.m_21205_().m_41619_() && player.m_21205_().m_150930_(block.m_5456_())) {
            return false;
        }
        if (!KSitCommonConfig.sitOnStairs && block instanceof StairBlock) {
            return false;
        }
        if (!KSitCommonConfig.sitOnSlab && block instanceof SlabBlock) {
            return false;
        }
        if (!KSitCommonConfig.sitOnCarpet && block instanceof CarpetBlock) {
            return false;
        }
        if (!KSitCommonConfig.sitOnBed && block instanceof BedBlock) {
            return false;
        }
        if (!level.m_142425_((EntityTypeTest)EntityType.f_268573_, new AABB(pos).m_82363_(0.0, 1.0, 0.0), SitManager::isSeatEntity).isEmpty()) {
            return false;
        }
        if (!level.f_46443_) {
            Display.BlockDisplay display = new Display.BlockDisplay(EntityType.f_268573_, level);
            display.m_6593_(ENTITY_NAME);
            display.m_269329_(blockState);
            VoxelShape shape = blockState.m_60651_((BlockGetter)level, pos, CollisionContext.m_82750_((Entity)player));
            Vec3 seatPos = null;
            Direction facing = SitManager.guessBlockFacing(blockState, player);
            if (!shape.m_83281_()) {
                Vec3 traceEnd;
                Vec3 traceStart;
                BlockHitResult hit;
                AABB bounds = shape.m_83215_();
                double x = (bounds.f_82288_ + bounds.f_82291_) / 2.0;
                double y = bounds.f_82291_ + 0.1;
                double z = (bounds.f_82290_ + bounds.f_82293_) / 2.0;
                if (facing != null) {
                    x += (double)facing.m_122429_() * 0.1;
                    z += (double)facing.m_122431_() * 0.1;
                }
                if ((hit = shape.m_83220_(traceStart = new Vec3((double)pos.m_123341_() + x, (double)pos.m_123342_() + y, (double)pos.m_123343_() + z), traceEnd = traceStart.m_82520_(0.0, -2.0, 0.0), pos)) != null && hit.m_6662_() == HitResult.Type.BLOCK) {
                    seatPos = hit.m_82450_();
                }
            }
            if (facing == null) {
                display.m_146922_(player.m_146908_());
            } else {
                float yRot = facing.m_122435_();
                display.m_146922_(yRot);
                display.m_20242_(true);
            }
            if (seatPos == null) {
                seatPos = Vec3.m_82512_((Vec3i)pos);
            }
            double clampedY = Mth.m_14008_((double)seatPos.f_82480_, (double)pos.m_123342_(), (double)((double)pos.m_123342_() + 0.999));
            display.m_6034_(seatPos.f_82479_, clampedY - 0.23, seatPos.f_82481_);
            Player rider = player;
            if (KSitCommonConfig.makeLeashedMobSit) {
                List<Mob> list = SitManager.leashableInArea(level, player.m_20183_(), player, leashable -> leashable.m_21524_() == player);
                double dist = Double.MAX_VALUE;
                for (Mob leashable2 : list) {
                    if (leashable2.m_21525_() || !((EntityAccess)leashable2).callCanRide((Entity)display)) continue;
                    double d = leashable2.m_20280_((Entity)player);
                    if (rider != player && !(d < dist)) continue;
                    rider = leashable2;
                    dist = d;
                }
            }
            if (level.m_7967_((Entity)display)) {
                rider.m_146922_(display.m_146908_());
                rider.m_7998_((Entity)display, true);
                if (rider != player) {
                    ((Mob)rider).m_21455_(true, true);
                }
            }
        }
        return true;
    }

    @Nullable
    public static Direction guessBlockFacing(BlockState blockState, @Nullable Player player) {
        Direction direction;
        Direction.Axis axis;
        if (blockState.m_204336_(BlockTags.f_13038_)) {
            return null;
        }
        KBlockSettings settings = KBlockSettings.of(blockState.m_60734_());
        if (settings != null) {
            for (KBlockComponent component : settings.components.values()) {
                Direction facing = component.getHorizontalFacing(blockState);
                if (facing == null) continue;
                return facing;
            }
        }
        boolean oppose = false;
        try {
            String shape = KBlockUtils.getValueString(blockState, "shape");
            if (!"straight".equals(shape)) {
                return null;
            }
            oppose = blockState.m_60734_() instanceof StairBlock;
        }
        catch (Throwable shape) {
            // empty catch block
        }
        if (blockState.m_61138_((Property)BlockStateProperties.f_61374_)) {
            Direction direction2 = (Direction)blockState.m_61143_((Property)BlockStateProperties.f_61374_);
            return oppose ? direction2.m_122424_() : direction2;
        }
        if (player != null && blockState.m_61138_((Property)BlockStateProperties.f_61364_) && (axis = (Direction.Axis)blockState.m_61143_((Property)BlockStateProperties.f_61364_)).test(direction = player.m_6350_())) {
            return direction;
        }
        return null;
    }

    public static boolean isSeatEntity(@Nullable Entity entity) {
        if (entity == null || entity.m_6095_() != EntityType.f_268573_) {
            return false;
        }
        Component customName = entity.m_7770_();
        return customName != null && Objects.equals(customName.getString(), ENTITY_NAME.getString());
    }

    public static void clampRotation(Player player, Entity seat) {
        if (!seat.m_20068_()) {
            return;
        }
        float seatRot = Mth.m_14177_((float)seat.m_146908_());
        float f = Mth.m_14177_((float)(player.m_146908_() - seatRot));
        float f1 = Mth.m_14036_((float)f, (float)-105.0f, (float)105.0f);
        player.f_19859_ += f1 - f;
        player.m_146922_(player.m_146908_() + f1 - f);
        player.m_5616_(player.m_146908_());
        player.m_5618_(seatRot);
        f = Mth.m_14177_((float)player.m_146909_());
        f1 = Math.max(f, -45.0f);
        player.m_146926_(f1);
    }

    public static Vec3 dismount(Entity display, LivingEntity passenger) {
        Direction direction = display.m_20068_() ? display.m_6350_() : passenger.m_6350_();
        BlockPos pos = BlockPos.m_274561_((double)display.m_20185_(), (double)(display.m_20186_() + 0.23), (double)display.m_20189_());
        Optional vec3 = BedBlock.m_260958_((EntityType)passenger.m_6095_(), (CollisionGetter)passenger.m_9236_(), (BlockPos)pos, (Direction)direction, (float)passenger.m_146908_());
        return vec3.orElseGet(() -> Vec3.m_82539_((Vec3i)pos.m_7494_()));
    }

    public static List<Mob> leashableInArea(Level level, BlockPos blockPos, Player player, Predicate<Mob> mobPredicate) {
        double radius = 7.0;
        int x = blockPos.m_123341_();
        int y = blockPos.m_123342_();
        int z = blockPos.m_123343_();
        AABB searchArea = new AABB((double)x - radius, (double)y - radius, (double)z - radius, (double)x + radius, (double)y + radius, (double)z + radius);
        return level.m_6443_(Mob.class, searchArea, mob -> (mob.m_21523_() || mob.m_6573_(player)) && mobPredicate.test((Mob)mob)).stream().toList();
    }
}

