/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.block;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import snownee.kiwi.customization.block.KBlockSettings;

public interface KBlockUtils {
    public static final Interner<Property<?>> PROPERTY_INTERNER = Interners.newStrongInterner();
    public static final BiMap<String, Property<?>> COMMON_PROPERTIES = KBlockUtils.generateCommonProperties();

    public static BiMap<String, Property<?>> generateCommonProperties() {
        ImmutableBiMap.Builder map = ImmutableBiMap.builder();
        map.put((Object)"attached", (Object)BlockStateProperties.f_61386_);
        map.put((Object)"bottom", (Object)BlockStateProperties.f_61427_);
        map.put((Object)"conditional", (Object)BlockStateProperties.f_61428_);
        map.put((Object)"disarmed", (Object)BlockStateProperties.f_61429_);
        map.put((Object)"drag", (Object)BlockStateProperties.f_61430_);
        map.put((Object)"enabled", (Object)BlockStateProperties.f_61431_);
        map.put((Object)"extended", (Object)BlockStateProperties.f_61432_);
        map.put((Object)"eye", (Object)BlockStateProperties.f_61433_);
        map.put((Object)"falling", (Object)BlockStateProperties.f_61434_);
        map.put((Object)"hanging", (Object)BlockStateProperties.f_61435_);
        map.put((Object)"has_record", (Object)BlockStateProperties.f_61439_);
        map.put((Object)"has_book", (Object)BlockStateProperties.f_61440_);
        map.put((Object)"inverted", (Object)BlockStateProperties.f_61441_);
        map.put((Object)"in_wall", (Object)BlockStateProperties.f_61442_);
        map.put((Object)"lit", (Object)BlockStateProperties.f_61443_);
        map.put((Object)"locked", (Object)BlockStateProperties.f_61444_);
        map.put((Object)"occupied", (Object)BlockStateProperties.f_61445_);
        map.put((Object)"open", (Object)BlockStateProperties.f_61446_);
        map.put((Object)"persistent", (Object)BlockStateProperties.f_61447_);
        map.put((Object)"powered", (Object)BlockStateProperties.f_61448_);
        map.put((Object)"short", (Object)BlockStateProperties.f_61449_);
        map.put((Object)"signal_fire", (Object)BlockStateProperties.f_61450_);
        map.put((Object)"snowy", (Object)BlockStateProperties.f_61451_);
        map.put((Object)"triggered", (Object)BlockStateProperties.f_61360_);
        map.put((Object)"unstable", (Object)BlockStateProperties.f_61361_);
        map.put((Object)"waterlogged", (Object)BlockStateProperties.f_61362_);
        map.put((Object)"berries", (Object)BlockStateProperties.f_155977_);
        map.put((Object)"bloom", (Object)BlockStateProperties.f_222995_);
        map.put((Object)"shrieking", (Object)BlockStateProperties.f_222996_);
        map.put((Object)"can_summon", (Object)BlockStateProperties.f_222997_);
        map.put((Object)"horizontal_axis", (Object)BlockStateProperties.f_61364_);
        map.put((Object)"axis", (Object)BlockStateProperties.f_61365_);
        map.put((Object)"up", (Object)BlockStateProperties.f_61366_);
        map.put((Object)"down", (Object)BlockStateProperties.f_61367_);
        map.put((Object)"north", (Object)BlockStateProperties.f_61368_);
        map.put((Object)"east", (Object)BlockStateProperties.f_61369_);
        map.put((Object)"south", (Object)BlockStateProperties.f_61370_);
        map.put((Object)"west", (Object)BlockStateProperties.f_61371_);
        map.put((Object)"facing", (Object)BlockStateProperties.f_61372_);
        map.put((Object)"facing_hopper", (Object)BlockStateProperties.f_61373_);
        map.put((Object)"horizontal_facing", (Object)BlockStateProperties.f_61374_);
        map.put((Object)"flower_amount", (Object)BlockStateProperties.f_271526_);
        map.put((Object)"orientation", (Object)BlockStateProperties.f_61375_);
        map.put((Object)"attach_face", (Object)BlockStateProperties.f_61376_);
        map.put((Object)"bell_attachment", (Object)BlockStateProperties.f_61377_);
        map.put((Object)"east_wall", (Object)BlockStateProperties.f_61378_);
        map.put((Object)"north_wall", (Object)BlockStateProperties.f_61379_);
        map.put((Object)"south_wall", (Object)BlockStateProperties.f_61380_);
        map.put((Object)"west_wall", (Object)BlockStateProperties.f_61381_);
        map.put((Object)"east_redstone", (Object)BlockStateProperties.f_61382_);
        map.put((Object)"north_redstone", (Object)BlockStateProperties.f_61383_);
        map.put((Object)"south_redstone", (Object)BlockStateProperties.f_61384_);
        map.put((Object)"west_redstone", (Object)BlockStateProperties.f_61385_);
        map.put((Object)"double_block_half", (Object)BlockStateProperties.f_61401_);
        map.put((Object)"half", (Object)BlockStateProperties.f_61402_);
        map.put((Object)"rail_shape", (Object)BlockStateProperties.f_61403_);
        map.put((Object)"rail_shape_straight", (Object)BlockStateProperties.f_61404_);
        map.put((Object)"age_1", (Object)BlockStateProperties.f_61405_);
        map.put((Object)"age_2", (Object)BlockStateProperties.f_61406_);
        map.put((Object)"age_3", (Object)BlockStateProperties.f_61407_);
        map.put((Object)"age_4", (Object)BlockStateProperties.f_222999_);
        map.put((Object)"age_5", (Object)BlockStateProperties.f_61408_);
        map.put((Object)"age_7", (Object)BlockStateProperties.f_61409_);
        map.put((Object)"age_15", (Object)BlockStateProperties.f_61410_);
        map.put((Object)"age_25", (Object)BlockStateProperties.f_61411_);
        map.put((Object)"bites", (Object)BlockStateProperties.f_61412_);
        map.put((Object)"candles", (Object)BlockStateProperties.f_155994_);
        map.put((Object)"delay", (Object)BlockStateProperties.f_61413_);
        map.put((Object)"distance", (Object)BlockStateProperties.f_61414_);
        map.put((Object)"eggs", (Object)BlockStateProperties.f_61415_);
        map.put((Object)"hatch", (Object)BlockStateProperties.f_61416_);
        map.put((Object)"layers", (Object)BlockStateProperties.f_61417_);
        map.put((Object)"level_cauldron", (Object)BlockStateProperties.f_61418_);
        map.put((Object)"level_composter", (Object)BlockStateProperties.f_61419_);
        map.put((Object)"level_flowing", (Object)BlockStateProperties.f_61420_);
        map.put((Object)"level_honey", (Object)BlockStateProperties.f_61421_);
        map.put((Object)"level", (Object)BlockStateProperties.f_61422_);
        map.put((Object)"moisture", (Object)BlockStateProperties.f_61423_);
        map.put((Object)"note", (Object)BlockStateProperties.f_61424_);
        map.put((Object)"pickles", (Object)BlockStateProperties.f_61425_);
        map.put((Object)"power", (Object)BlockStateProperties.f_61426_);
        map.put((Object)"stage", (Object)BlockStateProperties.f_61387_);
        map.put((Object)"stability_distance", (Object)BlockStateProperties.f_61388_);
        map.put((Object)"rotation_16", (Object)BlockStateProperties.f_61390_);
        map.put((Object)"bed_part", (Object)BlockStateProperties.f_61391_);
        map.put((Object)"chest_type", (Object)BlockStateProperties.f_61392_);
        map.put((Object)"mode_comparator", (Object)BlockStateProperties.f_61393_);
        map.put((Object)"door_hinge", (Object)BlockStateProperties.f_61394_);
        map.put((Object)"piston_type", (Object)BlockStateProperties.f_61396_);
        map.put((Object)"slab_type", (Object)BlockStateProperties.f_61397_);
        map.put((Object)"stairs_shape", (Object)BlockStateProperties.f_61398_);
        map.put((Object)"bamboo_leaves", (Object)BlockStateProperties.f_61400_);
        map.put((Object)"tilt", (Object)BlockStateProperties.f_155996_);
        map.put((Object)"vertical_direction", (Object)BlockStateProperties.f_155997_);
        map.put((Object)"dripstone_thickness", (Object)BlockStateProperties.f_155998_);
        map.put((Object)"sculk_sensor_phase", (Object)BlockStateProperties.f_155999_);
        map.put((Object)"dusted", (Object)BlockStateProperties.f_271112_);
        map.put((Object)"cracked", (Object)BlockStateProperties.f_276520_);
        return map.build();
    }

    public static <T extends Property<?>> T internProperty(T property) {
        return (T)((Property)PROPERTY_INTERNER.intern(property));
    }

    public static Property<?> getProperty(BlockState blockState, String key) {
        Property property = blockState.m_60734_().m_49965_().m_61081_(key);
        if (property == null) {
            throw new IllegalStateException("Property %s not found".formatted(key));
        }
        return property;
    }

    public static <T extends Comparable<T>> String getValueString(BlockState blockState, String key) {
        Property property = blockState.m_60734_().m_49965_().m_61081_(key);
        if (property == null) {
            throw new IllegalStateException("Property %s not found".formatted(key));
        }
        return property.m_6940_(blockState.m_61143_(property));
    }

    public static <T extends Comparable<T>> BlockState setValueByString(BlockState blockState, String key, String value) {
        Property property = blockState.m_60734_().m_49965_().m_61081_(key);
        if (property == null) {
            throw new IllegalStateException("Property %s not found".formatted(key));
        }
        return (BlockState)blockState.m_61124_(property, (Comparable)property.m_6215_(value).orElseThrow());
    }

    public static <T extends Comparable<T>> String getNameByValue(Property<T> property, Object value) {
        return property.m_6940_((Comparable)value);
    }

    @Nullable
    default public BlockState componentsUpdateShape(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pPos, BlockPos pNeighborPos) {
        KBlockSettings settings = KBlockSettings.of(this);
        if (settings == null) {
            return pState;
        }
        return settings.updateShape(pState, pDirection, pNeighborState, pLevel, pPos, pNeighborPos);
    }

    @Nullable
    default public BlockState componentsGetStateForPlacement(BlockState pState, BlockPlaceContext pContext) {
        KBlockSettings settings = KBlockSettings.of(this);
        if (settings == null) {
            return pState;
        }
        return settings.getStateForPlacement(pState, pContext);
    }
}

