/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import kotlin.jvm.internal.Intrinsics;

public final class Challenge {
    private final String scheme;
    private final Map authParams;

    public Challenge(String object, Map object2) {
        LinkedHashMap linkedHashMap;
        Map map;
        Intrinsics.checkNotNullParameter(object, "scheme");
        Intrinsics.checkNotNullParameter(object2, "authParams");
        ((Challenge)((Object)map)).scheme = object;
        object = linkedHashMap;
        linkedHashMap = new LinkedHashMap();
        for (Map.Entry entry : object2.entrySet()) {
            Object object3 = (String)entry.getKey();
            String object32 = (String)entry.getValue();
            if (object3 == null) {
                object3 = null;
            } else {
                String string = object3;
                object3 = Locale.US;
                Intrinsics.checkNotNullExpressionValue(object3, "US");
                object3 = string.toLowerCase((Locale)object3);
                Intrinsics.checkNotNullExpressionValue(object3, "this as java.lang.String).toLowerCase(locale)");
            }
            object.put(object3, object32);
        }
        Challenge challenge = map;
        map = Collections.unmodifiableMap(object);
        Intrinsics.checkNotNullExpressionValue(map, "unmodifiableMap<String?, String>(newAuthParams)");
        challenge.authParams = map;
    }

    public final String scheme() {
        return this.scheme;
    }

    public final String realm() {
        return (String)this.authParams.get("realm");
    }

    public final Charset charset() {
        String string = (String)((Challenge)((Object)string)).authParams.get("charset");
        if (string != null) {
            try {
                Charset charset = Charset.forName(string);
                Intrinsics.checkNotNullExpressionValue(charset, "forName(charset)");
                return charset;
            }
            catch (Exception exception) {}
        }
        Charset charset = StandardCharsets.ISO_8859_1;
        Intrinsics.checkNotNullExpressionValue(charset, "ISO_8859_1");
        return charset;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (!(object instanceof Challenge)) return false;
        object = (Challenge)object;
        if (!Intrinsics.areEqual(((Challenge)object).scheme, this.scheme)) return false;
        if (!Intrinsics.areEqual(((Challenge)object).authParams, this.authParams)) return false;
        return true;
    }

    public int hashCode() {
        return (899 + this.scheme.hashCode()) * 31 + ((Object)this.authParams).hashCode();
    }

    public String toString() {
        return this.scheme + " authParams=" + this.authParams;
    }
}

