/*
 * Decompiled with CFR 0.152.
 */
package link.infra.packwiz.installer.target;

import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import link.infra.packwiz.installer.target.CachedTarget;
import link.infra.packwiz.installer.target.CachedTargetStatus;
import link.infra.packwiz.installer.target.CachedTargetValidationKt$validate$1$1;
import link.infra.packwiz.installer.target.PathNode;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\"\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a0\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00040\b2\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\t0\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\n\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u000b"}, d2={"buildTree", "Llink/infra/packwiz/installer/target/PathNode;", "Llink/infra/packwiz/installer/target/CachedTargetStatus;", "targets", "", "baseDir", "Ljava/nio/file/Path;", "validate", "Lkotlin/Result;", "Llink/infra/packwiz/installer/target/CachedTarget;", "(Ljava/util/List;Ljava/nio/file/Path;)Ljava/lang/Object;", "packwiz-installer"})
public final class CachedTargetValidationKt {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final Object validate(List<CachedTarget> object, Path path) {
        ArrayList<CachedTargetStatus> arrayList;
        Intrinsics.checkNotNullParameter(object, "targets");
        Intrinsics.checkNotNullParameter(path, "baseDir");
        // empty try
        ArrayList<CachedTargetStatus> arrayList2 = arrayList;
        try {
            arrayList = new ArrayList<CachedTargetStatus>(CollectionsKt.collectionSizeOrDefault((Iterable)object, 10));
            object = object.iterator();
            while (object.hasNext()) {
                CachedTarget cachedTarget = (CachedTarget)object.next();
                arrayList2.add(new CachedTargetStatus(cachedTarget, false, false));
            }
        }
        catch (Throwable throwable) {
            return Result.constructor-impl(ResultKt.createFailure(throwable));
        }
        {
            continue;
        }
        ArrayList<CachedTargetStatus> arrayList3 = arrayList2;
        object = CachedTargetValidationKt.buildTree(arrayList2, path);
        Files.walkFileTree(path, SetsKt.setOf((Object)FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, new CachedTargetValidationKt$validate$1$1((PathNode<CachedTargetStatus>)object));
        return Result.constructor-impl(arrayList3);
    }

    public static final PathNode<CachedTargetStatus> buildTree(List<CachedTargetStatus> pathNode, Path path) {
        PathNode pathNode2;
        List<CachedTargetStatus> list = pathNode;
        Intrinsics.checkNotNullParameter(pathNode, "targets");
        Intrinsics.checkNotNullParameter(path, "baseDir");
        pathNode = pathNode2;
        pathNode2 = new PathNode();
        for (CachedTargetStatus cachedTargetStatus : list) {
            Path path2 = PathsKt.relativeTo(cachedTargetStatus.getTarget().getCachedLocation(), path);
            int n = path2.getNameCount() - 1;
            PathNode pathNode3 = pathNode;
            for (int i = 0; i < n; ++i) {
                PathNode pathNode4 = pathNode3;
                pathNode3 = path2.getName(i);
                Intrinsics.checkNotNullExpressionValue(pathNode3, "relPath.getName(i)");
                pathNode3 = pathNode4.createSubdir((Path)((Object)pathNode3));
            }
            Map map = pathNode3.getFiles();
            Path path3 = path2;
            Path path4 = path3.getName(path3.getNameCount() - 1);
            Intrinsics.checkNotNullExpressionValue(path4, "relPath.getName(relPath.nameCount - 1)");
            map.put(path4, cachedTargetStatus);
        }
        return pathNode;
    }
}

