/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types.typesApproximation;

import java.util.ArrayList;
import java.util.List;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotated;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRenderer;
import kotlin.reflect.jvm.internal.impl.resolve.calls.inference.CapturedTypeConstructor;
import kotlin.reflect.jvm.internal.impl.resolve.calls.inference.CapturedTypeConstructorKt;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.types.FlexibleTypesKt;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeFactory;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.TypeProjectionImpl;
import kotlin.reflect.jvm.internal.impl.types.TypeSubstitutionKt;
import kotlin.reflect.jvm.internal.impl.types.TypeSubstitutor;
import kotlin.reflect.jvm.internal.impl.types.TypeUtils;
import kotlin.reflect.jvm.internal.impl.types.TypeWithEnhancementKt;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;
import kotlin.reflect.jvm.internal.impl.types.typesApproximation.ApproximationBounds;
import kotlin.reflect.jvm.internal.impl.types.typesApproximation.CapturedTypeApproximationKt$WhenMappings;
import kotlin.reflect.jvm.internal.impl.types.typesApproximation.CapturedTypeApproximationKt$approximateCapturedTypesIfNecessary$1;
import kotlin.reflect.jvm.internal.impl.types.typesApproximation.CapturedTypeApproximationKt$substituteCapturedTypesWithProjections$typeSubstitutor$1;
import kotlin.reflect.jvm.internal.impl.types.typesApproximation.CapturedTypeApproximationKt$toTypeProjection$1$descriptorRenderer$1;
import kotlin.reflect.jvm.internal.impl.types.typesApproximation.TypeArgument;

public abstract class CapturedTypeApproximationKt {
    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private static final TypeProjection toTypeProjection(TypeArgument object) {
        TypeProjectionImpl typeProjectionImpl;
        void var1_12;
        boolean bl = ((TypeArgument)object).isConsistent();
        if (_Assertions.ENABLED && !bl) {
            DescriptorRenderer descriptorRenderer2 = DescriptorRenderer.Companion.withOptions(CapturedTypeApproximationKt$toTypeProjection$1$descriptorRenderer$1.INSTANCE);
            String string = "Only consistent enhanced type projection can be converted to type projection, but [" + descriptorRenderer2.render(((TypeArgument)object).getTypeParameter()) + ": <" + descriptorRenderer2.renderType(((TypeArgument)object).getInProjection()) + ", " + descriptorRenderer2.renderType(((TypeArgument)object).getOutProjection()) + ">] was found";
            throw new AssertionError((Object)string);
        }
        if (!Intrinsics.areEqual(((TypeArgument)object).getInProjection(), ((TypeArgument)object).getOutProjection())) {
            Variance variance = Variance.IN_VARIANCE;
            if (((TypeArgument)object).getTypeParameter().getVariance() != variance) {
                TypeProjectionImpl typeProjectionImpl2;
                if (KotlinBuiltIns.isNothing(((TypeArgument)object).getInProjection()) && ((TypeArgument)object).getTypeParameter().getVariance() != variance) {
                    TypeProjectionImpl typeProjectionImpl3;
                    TypeProjectionImpl typeProjectionImpl4 = typeProjectionImpl3;
                    Object object2 = object;
                    Variance variance2 = CapturedTypeApproximationKt.toTypeProjection$removeProjectionIfRedundant((TypeArgument)object2, Variance.OUT_VARIANCE);
                    typeProjectionImpl3 = new TypeProjectionImpl(variance2, ((TypeArgument)object2).getOutProjection());
                    return var1_12;
                }
                if (KotlinBuiltIns.isNullableAny(((TypeArgument)object).getOutProjection())) {
                    TypeProjectionImpl typeProjectionImpl5;
                    TypeProjectionImpl typeProjectionImpl6 = typeProjectionImpl5;
                    Object object3 = object;
                    Variance variance3 = CapturedTypeApproximationKt.toTypeProjection$removeProjectionIfRedundant((TypeArgument)object3, variance);
                    typeProjectionImpl5 = new TypeProjectionImpl(variance3, ((TypeArgument)object3).getInProjection());
                    TypeProjectionImpl typeProjectionImpl7 = typeProjectionImpl6;
                    return var1_12;
                }
                TypeProjectionImpl typeProjectionImpl8 = typeProjectionImpl2;
                Object object4 = object;
                Variance variance4 = CapturedTypeApproximationKt.toTypeProjection$removeProjectionIfRedundant((TypeArgument)object4, Variance.OUT_VARIANCE);
                typeProjectionImpl2 = new TypeProjectionImpl(variance4, ((TypeArgument)object4).getOutProjection());
                return var1_12;
            }
        }
        TypeProjectionImpl typeProjectionImpl9 = typeProjectionImpl;
        typeProjectionImpl = new TypeProjectionImpl(((TypeArgument)object).getInProjection());
        return var1_12;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final TypeArgument toTypeArgument(TypeProjection object, TypeParameterDescriptor annotated) {
        TypeArgument typeArgument;
        int n = CapturedTypeApproximationKt$WhenMappings.$EnumSwitchMapping$0[TypeSubstitutor.combine(annotated.getVariance(), (TypeProjection)object).ordinal()];
        if (n != 1) {
            if (n != 2) {
                TypeArgument typeArgument2;
                if (n != 3) throw new NoWhenBranchMatchedException();
                typeArgument = typeArgument2;
                Object object2 = object;
                object = DescriptorUtilsKt.getBuiltIns((DeclarationDescriptor)annotated).getNothingType();
                Intrinsics.checkNotNullExpressionValue(object, "typeParameter.builtIns.nothingType");
                KotlinType kotlinType = object2.getType();
                Intrinsics.checkNotNullExpressionValue(kotlinType, "type");
                typeArgument2 = new TypeArgument((TypeParameterDescriptor)annotated, (KotlinType)object, kotlinType);
                return typeArgument;
            } else {
                TypeArgument typeArgument3;
                typeArgument = typeArgument3;
                Annotated annotated2 = annotated;
                object = object.getType();
                Intrinsics.checkNotNullExpressionValue(object, "type");
                SimpleType simpleType2 = DescriptorUtilsKt.getBuiltIns((DeclarationDescriptor)annotated2).getNullableAnyType();
                Intrinsics.checkNotNullExpressionValue(simpleType2, "typeParameter.builtIns.nullableAnyType");
                typeArgument3 = new TypeArgument((TypeParameterDescriptor)annotated2, (KotlinType)object, simpleType2);
            }
            return typeArgument;
        } else {
            TypeArgument typeArgument4;
            typeArgument = typeArgument4;
            Object object3 = object;
            object = object3.getType();
            Intrinsics.checkNotNullExpressionValue(object, "type");
            KotlinType kotlinType = object3.getType();
            Intrinsics.checkNotNullExpressionValue(kotlinType, "type");
            typeArgument4 = new TypeArgument((TypeParameterDescriptor)annotated, (KotlinType)object, kotlinType);
        }
        return typeArgument;
    }

    public static final TypeProjection approximateCapturedTypesIfNecessary(TypeProjection object, boolean bl) {
        if (object == null) {
            return null;
        }
        if (object.isStarProjection()) {
            return object;
        }
        KotlinType kotlinType = object.getType();
        Intrinsics.checkNotNullExpressionValue(kotlinType, "typeProjection.type");
        if (!TypeUtils.contains(kotlinType, CapturedTypeApproximationKt$approximateCapturedTypesIfNecessary$1.INSTANCE)) {
            return object;
        }
        Variance variance = object.getProjectionKind();
        Intrinsics.checkNotNullExpressionValue((Object)variance, "typeProjection.projectionKind");
        if (variance == Variance.OUT_VARIANCE) {
            object = CapturedTypeApproximationKt.approximateCapturedTypes(kotlinType);
            return new TypeProjectionImpl(variance, (KotlinType)((ApproximationBounds)object).getUpper());
        }
        if (bl) {
            object = (KotlinType)CapturedTypeApproximationKt.approximateCapturedTypes(kotlinType).getLower();
            return new TypeProjectionImpl(variance, (KotlinType)object);
        }
        return CapturedTypeApproximationKt.substituteCapturedTypesWithProjections((TypeProjection)object);
    }

    private static final TypeProjection substituteCapturedTypesWithProjections(TypeProjection typeProjection) {
        TypeSubstitutor typeSubstitutor2 = TypeSubstitutor.create(new CapturedTypeApproximationKt$substituteCapturedTypesWithProjections$typeSubstitutor$1());
        Intrinsics.checkNotNullExpressionValue(typeSubstitutor2, "create(object : TypeCons\u2026ojection\n        }\n    })");
        return typeSubstitutor2.substituteWithoutApproximation(typeProjection);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final ApproximationBounds approximateCapturedTypes(KotlinType kotlinType) {
        boolean bl;
        ArrayList<Object> arrayList;
        Object object;
        KotlinType kotlinType2 = kotlinType;
        Intrinsics.checkNotNullParameter(kotlinType2, "type");
        if (FlexibleTypesKt.isFlexible(kotlinType2)) {
            KotlinType kotlinType3 = kotlinType;
            ApproximationBounds approximationBounds = CapturedTypeApproximationKt.approximateCapturedTypes(FlexibleTypesKt.lowerIfFlexible(kotlinType3));
            ApproximationBounds approximationBounds2 = CapturedTypeApproximationKt.approximateCapturedTypes(FlexibleTypesKt.upperIfFlexible(kotlinType3));
            return new ApproximationBounds(TypeWithEnhancementKt.inheritEnhancement(KotlinTypeFactory.flexibleType(FlexibleTypesKt.lowerIfFlexible((KotlinType)approximationBounds.getLower()), FlexibleTypesKt.upperIfFlexible((KotlinType)approximationBounds2.getLower())), kotlinType), TypeWithEnhancementKt.inheritEnhancement(KotlinTypeFactory.flexibleType(FlexibleTypesKt.lowerIfFlexible((KotlinType)approximationBounds.getUpper()), FlexibleTypesKt.upperIfFlexible((KotlinType)approximationBounds2.getUpper())), kotlinType));
        }
        KotlinType kotlinType4 = kotlinType;
        Object object2 = kotlinType4.getConstructor();
        if (CapturedTypeConstructorKt.isCaptured(kotlinType4)) {
            ApproximationBounds approximationBounds;
            TypeConstructor typeConstructor2 = object2;
            Intrinsics.checkNotNull(typeConstructor2, "null cannot be cast to non-null type org.jetbrains.kotlin.resolve.calls.inference.CapturedTypeConstructor");
            object2 = ((CapturedTypeConstructor)typeConstructor2).getProjection();
            KotlinType kotlinType5 = object2.getType();
            Intrinsics.checkNotNullExpressionValue(kotlinType5, "typeProjection.type");
            KotlinType kotlinType6 = CapturedTypeApproximationKt.approximateCapturedTypes$makeNullableIfNeeded(kotlinType5, kotlinType);
            int n = CapturedTypeApproximationKt$WhenMappings.$EnumSwitchMapping$0[object2.getProjectionKind().ordinal()];
            if (n != 2) {
                ApproximationBounds approximationBounds3;
                if (n != 3) throw new AssertionError((Object)("Only nontrivial projections should have been captured, not: " + object2));
                object2 = approximationBounds3;
                SimpleType simpleType2 = TypeUtilsKt.getBuiltIns(kotlinType).getNothingType();
                Intrinsics.checkNotNullExpressionValue(simpleType2, "type.builtIns.nothingType");
                approximationBounds3 = new ApproximationBounds(CapturedTypeApproximationKt.approximateCapturedTypes$makeNullableIfNeeded(simpleType2, kotlinType), kotlinType6);
                return object2;
            }
            object2 = approximationBounds;
            kotlinType = TypeUtilsKt.getBuiltIns(kotlinType).getNullableAnyType();
            Intrinsics.checkNotNullExpressionValue(kotlinType, "type.builtIns.nullableAnyType");
            approximationBounds = new ApproximationBounds(kotlinType6, kotlinType);
            return object2;
        }
        if (!kotlinType.getArguments().isEmpty() && kotlinType.getArguments().size() == object2.getParameters().size()) {
            ArrayList<Object> arrayList2;
            ArrayList arrayList3;
            object = arrayList3;
            arrayList3 = new ArrayList();
            arrayList = arrayList2;
            arrayList2 = new ArrayList<Object>();
            List list = kotlinType.getArguments();
            List list2 = object2.getParameters();
            Intrinsics.checkNotNullExpressionValue(list2, "typeConstructor.parameters");
            object2 = CollectionsKt.zip(list, list2).iterator();
        } else {
            KotlinType kotlinType7 = kotlinType;
            return new ApproximationBounds(kotlinType7, kotlinType7);
        }
        while (object2.hasNext()) {
            Object object3 = (Pair)object2.next();
            TypeProjection typeProjection = (TypeProjection)((Pair)object3).component1();
            TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)((Pair)object3).component2();
            Intrinsics.checkNotNullExpressionValue(typeParameterDescriptor, "typeParameter");
            object3 = CapturedTypeApproximationKt.toTypeArgument(typeProjection, typeParameterDescriptor);
            if (typeProjection.isStarProjection()) {
                ((ArrayList)object).add(object3);
                arrayList.add(object3);
                continue;
            }
            ApproximationBounds approximationBounds = CapturedTypeApproximationKt.approximateProjection((TypeArgument)object3);
            object3 = approximationBounds;
            object3 = (TypeArgument)((ApproximationBounds)object3).component2();
            ((ArrayList)object).add((TypeArgument)approximationBounds.component1());
            arrayList.add(object3);
        }
        if (!object.isEmpty()) {
            object2 = object.iterator();
            while (object2.hasNext()) {
                if (!(((TypeArgument)object2.next()).isConsistent() ^ true)) continue;
                bl = true;
                break;
            }
        } else {
            bl = false;
        }
        if (bl) {
            object = TypeUtilsKt.getBuiltIns(kotlinType).getNothingType();
            Intrinsics.checkNotNullExpressionValue(object, "type.builtIns.nothingType");
        } else {
            object = CapturedTypeApproximationKt.replaceTypeArguments(kotlinType, object);
        }
        Object object4 = object2;
        ((ApproximationBounds)object4)(object, CapturedTypeApproximationKt.replaceTypeArguments(kotlinType, arrayList));
        return object4;
    }

    private static final KotlinType replaceTypeArguments(KotlinType object, List object2) {
        ArrayList<TypeProjection> arrayList;
        boolean bl = ((KotlinType)object).getArguments().size() == object2.size();
        if (_Assertions.ENABLED && !bl) {
            object = "Incorrect type arguments " + object2;
            throw new AssertionError(object);
        }
        ArrayList<TypeProjection> arrayList2 = arrayList;
        arrayList = new ArrayList<TypeProjection>(CollectionsKt.collectionSizeOrDefault((Iterable)object2, 10));
        object2 = object2.iterator();
        while (object2.hasNext()) {
            arrayList2.add(CapturedTypeApproximationKt.toTypeProjection((TypeArgument)object2.next()));
        }
        return TypeSubstitutionKt.replace$default((KotlinType)object, arrayList2, null, null, 6, null);
    }

    private static final ApproximationBounds approximateProjection(TypeArgument typeArgument) {
        TypeArgument typeArgument2;
        TypeArgument typeArgument3 = typeArgument;
        ApproximationBounds approximationBounds = CapturedTypeApproximationKt.approximateCapturedTypes(typeArgument3.getInProjection());
        KotlinType kotlinType = (KotlinType)approximationBounds.component1();
        Object object = (KotlinType)approximationBounds.component2();
        ApproximationBounds approximationBounds2 = CapturedTypeApproximationKt.approximateCapturedTypes(typeArgument3.getOutProjection());
        KotlinType kotlinType2 = (KotlinType)approximationBounds2.component1();
        KotlinType kotlinType3 = (KotlinType)approximationBounds2.component2();
        TypeArgument typeArgument4 = new TypeArgument(typeArgument.getTypeParameter(), (KotlinType)object, kotlinType2);
        object = typeArgument2;
        typeArgument2 = new TypeArgument(typeArgument.getTypeParameter(), kotlinType, kotlinType3);
        return new ApproximationBounds(typeArgument4, object);
    }

    private static final Variance toTypeProjection$removeProjectionIfRedundant(TypeArgument typeArgument, Variance variance) {
        if (variance == typeArgument.getTypeParameter().getVariance()) {
            variance = Variance.INVARIANT;
        }
        return variance;
    }

    private static final KotlinType approximateCapturedTypes$makeNullableIfNeeded(KotlinType kotlinType, KotlinType kotlinType2) {
        KotlinType kotlinType3 = TypeUtils.makeNullableIfNeeded(kotlinType, kotlinType2.isMarkedNullable());
        Intrinsics.checkNotNullExpressionValue(kotlinType3, "makeNullableIfNeeded(this, type.isMarkedNullable)");
        return kotlinType3;
    }
}

