/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.renderer;

import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.name.FqNameUnsafe;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.renderer.KeywordStringsGenerated;

public abstract class RenderingUtilsKt {
    public static final String render(Name object) {
        Name name = object;
        Intrinsics.checkNotNullParameter(name, "<this>");
        if (RenderingUtilsKt.shouldBeEscaped(name)) {
            StringBuilder stringBuilder = new StringBuilder();
            object = ((Name)object).asString();
            Intrinsics.checkNotNullExpressionValue(object, "asString()");
            object = stringBuilder.append('`' + (String)object).append('`').toString();
        } else {
            object = ((Name)object).asString();
            Intrinsics.checkNotNullExpressionValue(object, "asString()");
        }
        return object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean shouldBeEscaped(Name object) {
        object = ((Name)object).asString();
        Intrinsics.checkNotNullExpressionValue(object, "asString()");
        if (KeywordStringsGenerated.KEYWORDS.contains(object)) return true;
        int n = 0;
        while (n < object.length()) {
            char c = object.charAt(n);
            if (!Character.isLetterOrDigit(c) && c != '_') {
                return true;
            }
            boolean bl = false;
            if (bl) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static final String render(FqNameUnsafe fqNameUnsafe) {
        FqNameUnsafe fqNameUnsafe2 = fqNameUnsafe;
        Intrinsics.checkNotNullParameter(fqNameUnsafe2, "<this>");
        List list = fqNameUnsafe2.pathSegments();
        Intrinsics.checkNotNullExpressionValue(list, "pathSegments()");
        return RenderingUtilsKt.renderFqName(list);
    }

    public static final String renderFqName(List object) {
        StringBuilder stringBuilder;
        List list = object;
        Intrinsics.checkNotNullParameter(list, "pathSegments");
        object = stringBuilder;
        stringBuilder = new StringBuilder();
        for (Name name : list) {
            if (((StringBuilder)object).length() > 0) {
                ((StringBuilder)object).append(".");
            }
            ((StringBuilder)object).append(RenderingUtilsKt.render(name));
        }
        String string = ((StringBuilder)object).toString();
        Intrinsics.checkNotNullExpressionValue(string, "StringBuilder().apply(builderAction).toString()");
        return string;
    }
}

